/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa1263.h"
#include "eif_built_in.h"
#include "eif_path_name.h"
#include "eif_eiffel.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F2113_21956
static int inline_F2113_21956 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F2113_21956
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F2113_21895 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2082, 0).id);
	F2078_20851(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_current */
void F2113_21896 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2082, 0).id);
	ti4_1 = F2113_21941(Current);
	F2081_20981(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(tr1))-2082])(tr1, (EIF_CHARACTER_8) '.');
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(tr1))-2082])(tr1, (EIF_CHARACTER_8) '\000');
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_string */
void F2113_21897 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2082, 0).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17258[Dtype(RTCW(arg1))-2081])(arg1);
	ti4_2 = F2113_21941(Current);
	F2081_20981(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17236[Dtype(RTCW(arg1))-2081])(arg1);
	if ((EIF_BOOLEAN) !tb1) {
		F2113_21950(Current, *(EIF_REFERENCE *)(Current), arg1, (EIF_CHARACTER_8) '\000');
		F2113_21943(Current);
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_storage */
void F2113_21899 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	F2113_21943(Current);
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_normalized_storage */
void F2113_21900 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_pointer */
void F2113_21901 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc2 = F924_13133(Current, arg1);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 -= (EIF_INTEGER_32) (loc2 % ti4_1);
	loc1 = RTLNS(eif_new_type(1058, 0x00).id, 1058, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F1059_15103(RTCW(loc1), arg1, loc2);
	tr1 = F1059_15111(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		F2113_21943(Current);
	}
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F2113_21902 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
		RTLE;
		return (EIF_BOOLEAN) F2113_21953(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F2113_21903 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * ti4_2))) {
		Result = F2113_21953(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		tr1 = *(EIF_REFERENCE *)(Current);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = F2113_21953(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_2), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F2113_21904 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	ti4_1 = F2113_21947(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTLE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F2113_21905 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	Result = tb1;
	RTLE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F2113_21906 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	Result = F2113_21907(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTLE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F2113_21907 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	loc1 = F2113_21947(Current);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			tr1 = *(EIF_REFERENCE *)(Current);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			{
				/* INLINED CODE (PATH.directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb1) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			Result = F2113_21953(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc2);
		} else {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F2113_21909 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = F2113_21938(Current);
	loc2 = F2113_21938(RTCW(arg1));
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F2113_21956(tp1, tp2));
	RTLE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F2113_21910 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	Result = '\0';
	tr1 = F2113_21914(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F2078_20893(loc1, arg1);
		Result = tb1;
	}
	RTLE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F2113_21911 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	loc1 = F2113_21947(Current);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F2113_21900(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTLE;
			return (EIF_REFERENCE) tr1;
		} else {
			Result = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17299[Dtype(RTCW(tr1))-2081])(tr1, ((EIF_INTEGER_32) 1L), loc1);
			F2113_21900(RTCW(Result), tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F2113_21912 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F2113_21948(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		tr1 = F2113_21911(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			RTLE;
			return (EIF_REFERENCE) loc3;
		} else {
			tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F2113_21896(RTCW(tr1));
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			Result = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F2113_21941(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17299[Dtype(RTCW(tr1))-2081])(tr1, ((EIF_INTEGER_32) 1L), ti4_1);
			F2113_21900(RTCW(Result), tr1);
		} else {
			loc2 = F2113_21947(Current);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTLE;
					return (EIF_REFERENCE) Current;
				} else {
					Result = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr1 = *(EIF_REFERENCE *)(Current);
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17299[Dtype(RTCW(tr1))-2081])(tr1, ((EIF_INTEGER_32) 1L), loc2);
					F2113_21900(RTCW(Result), tr1);
				}
			} else {
				Result = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F2113_21941(Current);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17299[Dtype(RTCW(tr1))-2081])(tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F2113_21900(RTCW(Result), tr1);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F2113_21913 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F2113_21948(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		loc2 = F2113_21947(Current);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				Result = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17299[Dtype(RTCW(tr1))-2081])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F2113_21900(RTCW(Result), tr1);
			}
		} else {
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		loc2 = F2113_21947(Current);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				Result = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17299[Dtype(RTCW(tr1))-2081])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F2113_21900(RTCW(Result), tr1);
			}
		} else {
			Result = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17299[Dtype(RTCW(tr1))-2081])(tr1, (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F2113_21900(RTCW(Result), tr1);
		}
	}
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		{
			/* INLINED CODE (PATH.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			tb4 = F1489_16235(RTCW(tr1));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		if (!tb4) {
			{
				/* INLINED CODE (PATH.is_current_symbol) */
				tb4 = (EIF_BOOLEAN)  0;
				(void) RTCW(Result);
				tr1 = *(EIF_REFERENCE *)(Result);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F2113_21941(Result);
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tb4 = F2113_21953(Result, *(EIF_REFERENCE *)(Result), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F2113_21903(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) NULL;
	}
	RTLE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F2113_21914 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tr1 = F2113_21913(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc1 = F2113_21936(loc4);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F2085_21160(RTCW(loc1), tw1, loc3);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			tr1 = F2086_21216(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTLE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F2113_21915 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc1);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1723,2112,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1723, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F1724_17104(RTCW(Result), ((EIF_INTEGER_32) 10L));
	loc3 = F2113_21947(Current);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		loc1 = RTLNS(eif_new_type(2082, 0x00).id, 2082, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2081_20981(RTCW(loc1), loc3);
		F2083_21095(RTCW(loc1), *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), loc3);
		tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F2113_21900(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R13903[Dtype(RTCW(Result))-1462])(Result, tr1);
		loc3++;
	} else {
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		loc2 = (EIF_INTEGER_32) loc3;
		loc3 = F2113_21949(Current, loc2);
		for (;;) {
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			loc1 = RTLNS(eif_new_type(2082, 0x00).id, 2082, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F2081_20981(RTCW(loc1), (EIF_INTEGER_32) (loc3 - loc2));
			F2083_21095(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F2113_21900(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R13903[Dtype(RTCW(Result))-1462])(Result, tr1);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			loc2 = ti4_1;
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			loc3 = F2113_21949(Current, loc2);
		}
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			loc1 = RTLNS(eif_new_type(2082, 0x00).id, 2082, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			F2081_20981(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 - loc2));
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			F2083_21095(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, ti4_1);
			tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F2113_21900(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R13903[Dtype(RTCW(Result))-1462])(Result, tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F2113_21916 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	tr1 = F927_13217(RTCV(RTOSCF(21946,F2113_21946, (Current))));
	Result = F2113_21917(Current, tr1);
	RTLE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F2113_21917 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) arg1;
	} else {
		if (F2113_21907(Current)) {
			RTLE;
			return (EIF_REFERENCE) Current;
		} else {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				tr1 = F2113_21911(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
					} else {
						Result = (EIF_REFERENCE) loc1;
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F2113_21952(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc2);
				} else {
					if (F2113_21953(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
						tr1 = F2113_21911(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F2113_21951(Current, tr1, tr2, tc2);
				}
			} else {
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				{
					/* INLINED CODE (PATH.directory_separator) */
					tc1 = (EIF_CHARACTER_8)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
					if (tb1) {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
					} else {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
					}
					/* END INLINED CODE */
				}
				tc2 = tc1;
				F2113_21951(Current, tr1, tr2, tc2);
			}
			{
				/* INLINED CODE (PATH.reset_internal_data) */
				(void) RTCW(Result);
				*(EIF_REFERENCE *)(Result + _REFACS_1_) = (EIF_REFERENCE) NULL;
				/* END INLINED CODE */
			}
			;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F2113_21918 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,loc4);
	RTLR(5,loc3);
	RTLR(6,loc1);
	RTLR(7,loc5);
	RTLIU(8);
	
	RTGC;
	{
		/* INLINED CODE (PATH.absolute_path) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = F927_13217(RTCV(RTOSCF(21946,F2113_21946, (Current))));
		tr1 = F2113_21917(Current, tr2);
		/* END INLINED CODE */
	}
	loc2 = tr1;
	tr1 = F2113_21911(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc3 = RTLNSMART(eif_new_type(2082, 0).id);
		tr1 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		F2081_20981(RTCW(loc3), ti4_1);
		loc1 = F2113_21915(RTCW(loc2));
		{
			/* INLINED CODE (ARRAYED_LIST.start) */
			(void) RTCW(loc1);
			*(EIF_INTEGER_32 *)(loc1 + O14444[Dtype(loc1)-1723]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			/* END INLINED CODE */
		}
		;
		{
			/* INLINED CODE (ARRAYED_LIST.item) */
			tr1 = (EIF_REFERENCE)  0;
			(void) RTCW(loc1);
			tr2 = *(EIF_REFERENCE *)(loc1);
			tr1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_REFERENCE *)RTCW(tr2) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(loc1 + O14444[Dtype(loc1)-1723]) - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tr1 = tr1;
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F2113_21951(Current, loc3, tr1, tc2);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R13921[Dtype(RTCW(loc1))-1555])(loc1);
		for (;;) {
			{
				/* INLINED CODE (LIST.after) */
				tb1 = (EIF_BOOLEAN)  0;
				(void) RTCW(loc1);
				ti4_1 = *(EIF_INTEGER_32 *)(loc1 + O14444[Dtype(loc1)-1723]);
				ti4_2 = F1724_17125(loc1);
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) 1L)));
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			{
				/* INLINED CODE (ARRAYED_LIST.item) */
				tr1 = (EIF_REFERENCE)  0;
				(void) RTCW(loc1);
				tr2 = *(EIF_REFERENCE *)(loc1);
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr2) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(loc1 + O14444[Dtype(loc1)-1723]) - ((EIF_INTEGER_32) 1L))))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			{
				/* INLINED CODE (PATH.is_current_symbol) */
				tb2 = (EIF_BOOLEAN)  0;
				(void) RTCW(tr1);
				tr2 = *(EIF_REFERENCE *)(tr1);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F2113_21941(tr1);
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tb2 = F2113_21953(tr1, *(EIF_REFERENCE *)(tr1), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) {
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R13921[Dtype(RTCW(loc1))-1555])(loc1);
			} else {
				{
					/* INLINED CODE (ARRAYED_LIST.item) */
					tr1 = (EIF_REFERENCE)  0;
					(void) RTCW(loc1);
					tr2 = *(EIF_REFERENCE *)(loc1);
					tr1 = 
						/* INLINED CODE (SPECIAL.item) */
						*((EIF_REFERENCE *)RTCW(tr2) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(loc1 + O14444[Dtype(loc1)-1723]) - ((EIF_INTEGER_32) 1L))))
						/* END INLINED CODE */;
					/* END INLINED CODE */
				}
				tr1 = tr1;
				tb2 = F2113_21903(RTCW(tr1));
				if (tb2) {
					{
						/* INLINED CODE (CHAIN.isfirst) */
						tb2 = (EIF_BOOLEAN)  0;
						(void) RTCW(loc1);
						tb2 = '\0';
						tb3 = F1487_16235(loc1);
						if ((EIF_BOOLEAN) !tb3) {
							ti4_1 = *(EIF_INTEGER_32 *)(loc1 + O14444[Dtype(loc1)-1723]);
							tb2 = (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 1L));
						}
						/* END INLINED CODE */
					}
					tb2 = tb2;
					if ((EIF_BOOLEAN) !tb2) {
						{
							/* INLINED CODE (ARRAYED_LIST.back) */
							(void) RTCW(loc1);
							(*(EIF_INTEGER_32 *)(loc1 + O14444[Dtype(loc1)-1723]))--;
							/* END INLINED CODE */
						}
						;
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R13921[Dtype(RTCW(loc1))-1555])(loc1);
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R13921[Dtype(RTCW(loc1))-1555])(loc1);
				} else {
					{
						/* INLINED CODE (ARRAYED_LIST.forth) */
						(void) RTCW(loc1);
						(*(EIF_INTEGER_32 *)(loc1 + O14444[Dtype(loc1)-1723]))++;
						/* END INLINED CODE */
					}
					;
				}
			}
		}
		loc5 = F1724_17118(RTCW(loc1));
		for (;;) {
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.after) */
				tb2 = (EIF_BOOLEAN)  0;
				(void) loc5;
				ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_);
				ti4_2 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_1_);
				tb2 = (EIF_BOOLEAN) (EIF_BOOLEAN) (ti4_1 > ti4_2);
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) break;
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.item) */
				tr1 = (EIF_REFERENCE)  0;
				(void) loc5;
				tr2 = *(EIF_REFERENCE *)(loc5);
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr2) + (*(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_)))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			{
				/* INLINED CODE (PATH.directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb3) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			F2113_21951(Current, loc3, tr1, tc2);
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.forth) */
				(void) loc5;
				(*(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_))++;
				/* END INLINED CODE */
			}
			;
		}
		tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F2113_21900(RTCW(tr1), loc3);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F2113_21919 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16370[Dtype(RTCW(tr1))-1970])(tr1);
	} else {
		Result = F2078_20861(RTCV(F2113_21936(Current)));
	}
	RTLE;
	return Result;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F2113_21923 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F2113_21924 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2082, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17258[Dtype(RTCW(arg1))-2081])(arg1);
	ti4_3 = F2113_21941(Current);
	ti4_4 = F2113_21941(Current);
	F2081_20981(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17405[Dtype(RTCW(loc1))-2082])(loc1, *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F2113_21947(Current) == ti4_1);
	}
	if (tb1) {
		F2113_21950(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F2113_21950(Current, loc1, arg1, tc2);
	}
	tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F2113_21899(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F2113_21925 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2082, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_3 = F2113_21941(Current);
	F2081_20981(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17405[Dtype(RTCW(loc1))-2082])(loc1, *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F2113_21947(Current) == ti4_1);
	}
	if (tb1) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F2113_21951(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F2113_21951(Current, loc1, tr1, tc2);
	}
	tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F2113_21900(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F2113_21926 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2082, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17258[Dtype(RTCW(arg1))-2081])(arg1);
	ti4_3 = F2113_21941(Current);
	F2081_20981(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17405[Dtype(RTCW(loc1))-2082])(loc1, *(EIF_REFERENCE *)(Current));
	F2113_21950(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F2113_21899(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F2113_21927 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2082, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17258[Dtype(RTCW(arg1))-2081])(arg1);
	ti4_3 = F2113_21941(Current);
	ti4_4 = F2113_21941(Current);
	F2081_20981(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17405[Dtype(RTCW(loc1))-2082])(loc1, *(EIF_REFERENCE *)(Current));
	F2113_21950(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	tr1 = RTLNS(eif_new_type(2112, 0x00).id, 2112, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F2113_21900(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F2113_21928 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				{
					/* INLINED CODE (PATH.is_case_sensitive_equal) */
					tb1 = (EIF_BOOLEAN)  0;
					if ((EIF_BOOLEAN)(arg1 == Current)) {
						tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					} else {
						tr1 = *(EIF_REFERENCE *)(Current);
						tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
						tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(RTCW(tr1))-35])(tr1, tr2);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_BOOLEAN) tb1;
			} else {
				RTLE;
				return (EIF_BOOLEAN) F2113_21932(Current, arg1);
			}
		}
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F2113_21929 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11670[Dtype(RTCW(tr1))-941])(tr1, tr2);
	} else {
		tr1 = F2086_21213(RTCV(F2113_21936(Current)));
		tr2 = F2113_21936(RTCW(arg1));
		tr2 = F2086_21213(RTCW(tr2));
		Result = F2085_21176(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F2113_21930 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	
	
	return (EIF_BOOLEAN) F2113_21928(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F2113_21931 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(RTCW(tr1))-35])(tr1, tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F2113_21932 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = F2113_21936(Current);
		tr2 = F2113_21936(RTCW(arg1));
		Result = F2085_21172(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.copy */
void F2113_21933 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		eif_builtin_ANY_standard_copy__o_ (Current, arg1);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin__o (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTLE;
}

/* {PATH}.out */
EIF_REFERENCE F2113_21934 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	tr1 = F2113_21936(Current);
	loc1 = tr1;
	loc1 = RTRV(eif_new_type(2080, 0x00),loc1);
	if (EIF_TEST(loc1)) {
		tr1 = RTLNS(eif_new_type(2082, 0x00).id, 2082, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2081_20983(RTCW(tr1), loc1);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) F2113_21935(Current);
	}/* NOTREACHED */
	
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F2113_21935 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_213 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(246, 0x00).id);
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	tr1 = F2113_21936(Current);
	{
		/* INLINED CODE (UTF_CONVERTER.escaped_utf_32_string_to_utf_8_string_8) */
		tr2 = (EIF_REFERENCE)  0;
		(void) RTCW(loc1);
		tr2 = RTLNS(eif_new_type(2082, 0x00).id, 2082, _OBJSIZ_1_1_0_3_0_0_0_0_);
		ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17258[Dtype(RTCW(tr1))-2081])(tr1);
		F2081_20981(RTCW(tr2), ti4_1);
		F247_4285(loc1, tr1, tr2);
		/* END INLINED CODE */
	}
	Result = tr2;
	RTLE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F2113_21936 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_213 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(246, 0x00).id);
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTLE;
		return (EIF_REFERENCE) loc2;
	} else {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			Result = RTLNS(eif_new_type(2085, 0x00).id, 2085, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F247_4323(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2085_21149(RTCW(Result), tr1);
		} else {
			Result = RTLNS(eif_new_type(2085, 0x00).id, 2085, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F247_4296(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2085_21149(RTCW(Result), tr1);
		}
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F2113_21938 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(1058, 0x00).id, 1058, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = F2113_21941(Current);
	F1059_15099(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	{
		/* INLINED CODE (C_STRING.set_string) */
		tr1 = *(EIF_REFERENCE *)(Current);
		(void) RTCW(loc1);
		ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17258[Dtype(RTCW(tr1))-2081])(tr1);
		F1059_15127(loc1, tr1, ((EIF_INTEGER_32) 1L), ti4_1);
		/* END INLINED CODE */
	}
	;
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.unit_size */
EIF_INTEGER_32 F2113_21941 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F2113_21942 (EIF_REFERENCE Current)
{
	GTCX
	
	
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
}

/* {PATH}.normalize */
void F2113_21943 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTGC;
	loc1 = *(EIF_REFERENCE *)(Current);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			tb1 = '\01';
			tb2 = '\0';
			if (F2113_21953(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F2113_21953(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F2113_21953(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!tb2) {
				tb2 = '\0';
				if (F2113_21953(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F2113_21953(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F2113_21953(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F2113_21953(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F2113_21953(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F2113_21953(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F2113_21953(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				if (F2113_21953(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R13912[Dtype(RTCW(loc1))-1629])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					loc6 = F2113_21953(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(loc1))-1629])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R13912[Dtype(RTCW(loc1))-1629])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(loc1))-1629])(loc1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R13912[Dtype(RTCW(loc1))-1629])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = F2113_21953(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				loc6 = F2113_21953(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(loc1))-1629])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R13912[Dtype(RTCW(loc1))-1629])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				loc3++;
			}
			loc2++;
		}
	}
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R17337[Dtype(RTCW(loc1))-2082])(loc1, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	if (loc8) {
		loc5 = F2113_21947(Current);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R17343[Dtype(RTCW(loc1))-2082])(loc1, ti4_2);
		}
	}
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb2) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	ti4_3 = ti4_2;
	{
		/* INLINED CODE (PATH.directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb2) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	tc2 = tc1;
	if (F2113_21953(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), tc2)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (F2113_21947(Current) < ti4_1);
	}
	if (tb1) {
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R17345[Dtype(RTCW(loc1))-2082])(loc1, ti4_2);
	}
	RTLE;
}

/* {PATH}.env */
static EIF_REFERENCE F2113_21946_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(1);
	RTLR(0,tr1);
	RTLIU(1);
	
	RTEV;
	RTGC;
	RTOSP (21946);
#define Result RTOSR(21946)
	RTOC_NEW(Result);
	tr1 = RTLNS(eif_new_type(926, 0x00).id, 926, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (21946);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F2113_21946 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(21946,F2113_21946_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F2113_21947 (EIF_REFERENCE Current)
{
	GTCX
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb2) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
				tb1 = F2113_21953(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				{
					/* INLINED CODE (PATH.unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
					if (tb1) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_INTEGER_32) ti4_1;
			} else {
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 1L)));
					loc1 = eif_builtin_CHARACTER_8_as_lower__c1_c1(tc1);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						{
							/* INLINED CODE (PATH.unit_size) */
							ti4_2 = (EIF_INTEGER_32)  0;
							tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
							if (tb2) {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
							} else {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
							}
							/* END INLINED CODE */
						}
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * ti4_2))) {
							tb1 = F2113_21953(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							{
								/* INLINED CODE (PATH.unit_size) */
								ti4_1 = (EIF_INTEGER_32)  0;
								tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
								if (tb1) {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
								} else {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
								}
								/* END INLINED CODE */
							}
							Result = ti4_1;
						} else {
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								loc2 = F2113_21949(Current, ((EIF_INTEGER_32) 7L));
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									{
										/* INLINED CODE (PATH.unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
										if (tb2) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + ti4_1) <= ti4_2);
								}
								if (tb1) {
									{
										/* INLINED CODE (PATH.unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
										if (tb1) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									ti4_2 = ti4_1;
									ti4_1 = F2113_21949(Current, (EIF_INTEGER_32) (loc2 + ti4_2));
									loc2 = (EIF_INTEGER_32) ti4_1;
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTLE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									}
								}
							}
						}
					}
				}
			}
		} else {
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(tr1))-1629])(tr1, ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTLE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F2113_21948 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_2) + ((EIF_INTEGER_32) 1L));
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
						if (tb2) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					tb1 = F2113_21953(Current, tr1, Result, tc2);
				}
				if (tb1) break;
				{
					/* INLINED CODE (PATH.unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
					if (tb2) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				Result -= ti4_1;
			}
		}
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb2) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_2) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F2113_21949 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTGC;
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 = ti4_1;
	{
		/* INLINED CODE (PATH.directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	loc3 = tc1;
	Result = (EIF_INTEGER_32) arg1;
	loc4 = *(EIF_REFERENCE *)(Current);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4)+ _LNGOFF_1_1_0_2_);
	for (;;) {
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F2113_21953(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		Result += loc2;
	}
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {PATH}.internal_append_into */
void F2113_21950 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	struct eif_ex_213 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(246, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17236[Dtype(RTCW(arg2))-2081])(arg2);
	if ((EIF_BOOLEAN) !tb1) {
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			{
				/* INLINED CODE (FINITE.is_empty) */
				tb4 = (EIF_BOOLEAN)  0;
				(void) RTCW(arg1);
				ti4_1 = *(EIF_INTEGER_32 *)(arg1+ _LNGOFF_1_1_0_2_);
				tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb3) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_3 = ti4_2;
			tb2 = (EIF_BOOLEAN) !F2113_21953(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R17222[Dtype(RTCW(arg2))-2081])(arg2, ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R17222[Dtype(RTCW(arg2))-2081])(arg2, ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(arg1))-2082])(arg1, arg3);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(arg1))-2082])(arg1, (EIF_CHARACTER_8) '\000');
				}
			} else {
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(arg1))-2082])(arg1, arg3);
			}
		}
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			F247_4310(RTCW(loc1), arg2, arg1);
		} else {
			F247_4285(RTCW(loc1), arg2, arg1);
		}
	}
	RTLE;
}

/* {PATH}.internal_path_append_into */
void F2113_21951 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (FINITE.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			(void) RTCW(arg1);
			ti4_1 = *(EIF_INTEGER_32 *)(arg1+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F2113_21953(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F2113_21953(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(arg1))-2082])(arg1, arg3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(arg1))-2082])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17405[Dtype(RTCW(arg1))-2082])(arg1, arg2);
	RTLE;
}

/* {PATH}.internal_path_append_substring_into */
void F2113_21952 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (FINITE.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			(void) RTCW(arg1);
			ti4_1 = *(EIF_INTEGER_32 *)(arg1+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F2113_21953(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F2113_21953(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(arg1))-2082])(arg1, arg5);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17409[Dtype(RTCW(arg1))-2082])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	F2083_21095(RTCW(arg1), arg2, arg3, arg4);
	RTLE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F2113_21953 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,arg1);
	RTLIU(1);
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		Result = '\0';
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(arg1))-1629])(arg1, arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(arg1))-1629])(arg1, (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14251[Dtype(RTCW(arg1))-1629])(arg1, arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTLE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F2113_21956 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F2113_21956 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	return Result;
}

void EIF_Minit1263 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
