/*
 * Code for class EW_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "ew178.h"
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <sys/wait.h>
#include <signal.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F83_1015
static void inline_F83_1015 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	int rc;
  				int fd[2];
  				EIF_INTEGER * read_ptr;
  				EIF_INTEGER * write_ptr;

  				rc = pipe(fd);
  				if (rc != 0) {
    					xraise(EN_SYS);
  				}
  				read_ptr = (EIF_INTEGER *) arg1;
  				write_ptr = (EIF_INTEGER *) arg2;
  				*read_ptr = fd[0];
  				*write_ptr = fd[1];
	;
}
#define INLINE_F83_1015
#endif
#ifndef INLINE_F83_1018
static EIF_INTEGER_32 inline_F83_1018 (void)
{
	pid_t pid;

  				pid = eif_thread_fork();
  				if (pid == (pid_t) -1) {
    					xraise(EN_SYS);
  				}
  				return (EIF_INTEGER) pid;
	;
}
#define INLINE_F83_1018
#endif
#ifndef INLINE_F83_1016
static EIF_POINTER inline_F83_1016 (EIF_INTEGER_32 arg1)
{
	char ** result;

  				result = (char **) malloc((size_t) (arg1 * sizeof(char *)));
  				if (result == NULL) {
    					enomem();
  				}
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F83_1016
#endif
#ifndef INLINE_F83_1014
static EIF_POINTER inline_F83_1014 (EIF_POINTER arg1)
{
	void * result;

  				result = (char *) malloc((size_t) (strlen((char *) arg1) + 1));
  				if (result == NULL) {
    					enomem();
  				}
  				strcpy(result, arg1);
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F83_1014
#endif
#ifndef INLINE_F83_1017
static void inline_F83_1017 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	char ** arguments;

				arguments = (char **) arg1;
				arguments[arg2] = (char *) arg3;
	;
}
#define INLINE_F83_1017
#endif
#ifndef INLINE_F83_1019
static void inline_F83_1019 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	int getdtablesize(void);
  				int max_descriptors;
  				int k, rc;
  
  				if (arg4 == EIF_TRUE) {
    					max_descriptors = getdtablesize();
  					for (k = 3; k < max_descriptors; k++) {
    						rc = fcntl(k, F_SETFD, 1);
    						if (rc == -1 && errno != EBADF) {
      							xraise(EN_SYS);
    						}
  					}
  				}
  				if (arg3 == NULL) {
    					(void) execv((char *) arg1, (char **) arg2);
  				} else {
    					(void) execve((char *) arg1, (char **) arg2, (char **) arg3);
  				}
  				xraise(EN_SYS);
	;
}
#define INLINE_F83_1019
#endif
#ifndef INLINE_F83_1021
static EIF_INTEGER_32 inline_F83_1021 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	pid_t rc;
  				int status, options;
  				EIF_BOOLEAN * ptr;

  				options = ((arg2 == EIF_TRUE) ? 0 : WNOHANG) | WUNTRACED;
  				ptr = (EIF_BOOLEAN *) arg3;
  				rc = waitpid((pid_t) arg1, &status, options);
  				if (rc == (pid_t) -1) {
    					xraise(EN_SYS);
  				} else if (rc == (pid_t) 0) {	/* No process has status to report yet */
    					*ptr = EIF_FALSE;
  				} else {		/* Process reported status */
    					*ptr = EIF_TRUE;
  				}
  				return (EIF_INTEGER) status;
	;
}
#define INLINE_F83_1021
#endif
#ifndef INLINE_F83_1020
static void inline_F83_1020 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = kill((pid_t) arg1, (int) arg2);
  				if (rc != 0 && errno != ESRCH) {
    					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F83_1020
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {EW_UNIX_OS}.null_file_name */

EIF_REFERENCE F214_2396 (EIF_REFERENCE Current)
{
	GTCX
	RTOUC (186,RTMS32_EX_H("/\000\000\000d\000\000\000e\000\000\000v\000\000\000/\000\000\000n\000\000\000u\000\000\000l\000\000\000l\000\000\000",9,2028729708));
}

/* {EW_UNIX_OS}.executable_full_file_name */
EIF_REFERENCE F214_2397 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("executable_full_file_name", 213, Current, 0, 2, 2530);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F213_2390(Current, arg1, arg2);
}

/* {EW_UNIX_OS}.full_directory_name */
EIF_REFERENCE F214_2398 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("full_directory_name", 213, Current, 0, 2, 2531);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F213_2390(Current, arg1, arg2);
}

/* {EW_UNIX_OS}.new_pipe */
EIF_REFERENCE F214_2399 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("new_pipe", 213, Current, 2, 0, 2532);
	RTGC;
	RTHOOK(1);
	inline_F83_1015((EIF_INTEGER_32 *) &(loc1), (EIF_INTEGER_32 *) &(loc2));
	RTHOOK(2);
	tr1 = RTLNS(eif_new_type(931, 0x00).id, 931, _OBJSIZ_0_0_0_2_0_0_0_0_);
	F932_6475(RTCW(tr1), loc1, loc2);
	RTHOOK(3);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {EW_UNIX_OS}.fork_process */
EIF_INTEGER_32 F214_2400 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 213, Current, 0, 0, 2533);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) inline_F83_1018();
}

/* {EW_UNIX_OS}.exec_process */
void F214_2401 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_POINTER loc7 = (EIF_POINTER) 0;
	EIF_POINTER loc8 = (EIF_POINTER) 0;
	struct eif_ex_31 sloc9;
	EIF_REFERENCE loc9 = (EIF_REFERENCE) sloc9.data;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	memset (&sloc9.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc9.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc9.overhead, eif_new_type(52, 0x00).id);
	RTLI(7);
	RTLR(0,arg2);
	RTLR(1,loc4);
	RTLR(2,loc9);
	RTLR(3,arg1);
	RTLR(4,tr1);
	RTLR(5,loc5);
	RTLR(6,Current);
	RTLIU(7);
	
	RTEAA("exec_process", 213, Current, 9, 4, 2534);
	RTGC;
	RTHOOK(1);
	loc2 = F594_3503(RTCW(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCW(arg2)+ _LNGOFF_1_1_0_1_);
	RTHOOK(3);
	tr1 = F53_646(RTCW(loc9), arg1);
	loc4 = F917_6164(RTCW(tr1));
	RTHOOK(4);
	loc6 = inline_F83_1016((EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		tr1 = F594_3496(RTCW(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		tr1 = F53_646(RTCW(loc9), tr1);
		loc5 = F917_6164(RTCW(tr1));
		RTHOOK(8);
		loc7 = inline_F83_1014(loc5);
		RTHOOK(9);
		inline_F83_1017(loc6, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc7);
		RTHOOK(10);
		loc1++;
	}
	RTHOOK(11);
	inline_F83_1017(loc6, loc2, loc8);
	RTHOOK(12);
	inline_F83_1019(loc4, loc6, arg3, arg4);
	RTHOOK(13);
	RTLE;
	RTEE;
}

/* {EW_UNIX_OS}.wait_for_process_block */
EIF_INTEGER_32 F214_2402 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_BOOLEAN loc1 = (EIF_BOOLEAN) 0;
	
	
	RTEAA("wait_for_process_block", 213, Current, 1, 1, 2535);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) inline_F83_1021(arg1, (EIF_BOOLEAN) 1, (EIF_BOOLEAN *) &(loc1));
}

/* {EW_UNIX_OS}.send_signal */
void F214_2404 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("send_signal", 213, Current, 0, 2, 2537);
	RTHOOK(1);
	inline_F83_1020(arg2, arg1);
	RTHOOK(2);
	RTEE;
}

/* {EW_UNIX_OS}.terminate_hard */
void F214_2405 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("terminate_hard", 213, Current, 0, 1, 2538);
	RTGC;
	RTHOOK(1);
	ti4_1 = RTOUCB(EIF_INTEGER_32,187,F84_1034, (Current));
	F214_2404(Current, ti4_1, arg1);
	RTHOOK(2);
	RTLE;
	RTEE;
}

void EIF_Minit178 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
