/*
 * Code for class I18N_HOST_LOCALE_IMP
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "i11992.h"
#include <string.h>
#include <eif_langinfo.h>
#include <iconv.h>
#include <eif_eiffel.h>
#include "eif_dir.h"
#include "eif_langinfo.h"
#include <locale.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F2960_34046
static int inline_F2960_34046 (void)
{
	#if EIF_OS == EIF_OS_SUNOS
	return (EIF_BOOLEAN)1;
#else
	return (EIF_BOOLEAN)0;
#endif
	;
}
#define INLINE_F2960_34046
#endif
#ifndef INLINE_F224_3734
static EIF_INTEGER_32 inline_F224_3734 (void)
{
	return D_T_FMT;
	;
}
#define INLINE_F224_3734
#endif
#ifndef INLINE_F224_3735
static EIF_INTEGER_32 inline_F224_3735 (void)
{
	return D_FMT;
	;
}
#define INLINE_F224_3735
#endif
#ifndef INLINE_F224_3736
static EIF_INTEGER_32 inline_F224_3736 (void)
{
	return T_FMT;
	;
}
#define INLINE_F224_3736
#endif
#ifndef INLINE_F224_3732
static EIF_INTEGER_32 inline_F224_3732 (void)
{
	return AM_STR;
	;
}
#define INLINE_F224_3732
#endif
#ifndef INLINE_F224_3733
static EIF_INTEGER_32 inline_F224_3733 (void)
{
	return PM_STR;
	;
}
#define INLINE_F224_3733
#endif
#ifndef INLINE_F224_3738
static EIF_INTEGER_32 inline_F224_3738 (void)
{
	return CRNCYSTR;
	;
}
#define INLINE_F224_3738
#endif
#ifndef INLINE_F223_3689
static EIF_POINTER inline_F223_3689 (void)
{
	#if EIF_OS == EIF_OS_OPENBSD
	return locale_charset ();
#else
	return nl_langinfo (CODESET);
#endif
	;
}
#define INLINE_F223_3689
#endif
#ifndef INLINE_F223_3687
static EIF_POINTER inline_F223_3687 (EIF_INTEGER_32 arg1)
{
	char *dname;
				wchar_t *out = NULL;
				size_t insize, outsize = 0;

				dname = nl_langinfo(arg1);
				insize = strlen(dname) + 1;
				
				{
					iconv_t cd;
					size_t nconv, avail, alloc;
					char *res, *tres, *wrptr, *inptr;
					char **l_inptr = &inptr;

					alloc = avail = insize + insize/4;
					if (!(res = malloc(alloc))) {
					  perror("malloc");
					  return NULL;
					}

					wrptr = res;   /* duplicate pointers because they */
					inptr = dname; /* get modified by iconv */
					
					/*get charset used by current locale */
					#if EIF_OS == EIF_OS_OPENBSD
						char *charset = locale_charset ();
					#else
						char *charset = nl_langinfo (CODESET);
					#endif
					
					cd = iconv_open ("UTF-8", charset);
					if (cd == (iconv_t)(-1)) {
							perror("iconv_open");
							free(res);
							return NULL;
					}

					do {
							nconv = iconv (cd, l_inptr, &insize, &wrptr, &avail); /*convertions */
							if (nconv == (size_t)(-1)) {
									if (errno == E2BIG) { /* need more room for result */
											tres = realloc(res, alloc += 20);
											avail += 20;
											if (!tres) {
													perror("realloc");
													break;
											}
											wrptr = tres + (wrptr - res);
											res = tres;
									}
									else /* something wrong with input */
											break;
							}
					} while (insize);

					if (iconv_close(cd))
							perror("iconv_close");
				   
					out = (wchar_t*) res;
					outsize = wrptr - res; /* should be == to (alloc - avail + 1) */
					/* TODO: should possibly null-terminate the result */
				}
				return out;
	;
}
#define INLINE_F223_3687
#endif
#ifndef INLINE_F224_3701
static EIF_INTEGER_32 inline_F224_3701 (void)
{
	return DAY_1;
	;
}
#define INLINE_F224_3701
#endif
#ifndef INLINE_F224_3720
static EIF_INTEGER_32 inline_F224_3720 (void)
{
	return MON_1;
	;
}
#define INLINE_F224_3720
#endif
#ifndef INLINE_F224_3694
static EIF_INTEGER_32 inline_F224_3694 (void)
{
	return ABDAY_1;
	;
}
#define INLINE_F224_3694
#endif
#ifndef INLINE_F224_3708
static EIF_INTEGER_32 inline_F224_3708 (void)
{
	return ABMON_1;
	;
}
#define INLINE_F224_3708
#endif
#ifndef INLINE_F223_3693
static EIF_INTEGER_32 inline_F223_3693 (void)
{
	return LC_ALL;
	;
}
#define INLINE_F223_3693
#endif
#ifndef INLINE_F223_3692
static EIF_POINTER inline_F223_3692 (EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	return setlocale((int) arg1, (const char *) arg2);
	;
}
#define INLINE_F223_3692
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {I18N_HOST_LOCALE_IMP}.create_locale_info */
EIF_REFERENCE F2960_34010 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	if (EIF_TEST (inline_F2960_34046())) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		tr1 = F2960_34048(Current, tr1);
		F223_3685(Current, tr1);
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		F223_3685(Current, tr1);
	}
	Result = RTLNS(eif_new_type(228, 0x00).id, 228, _OBJSIZ_35_0_0_5_0_0_0_0_);
	F229_3857(RTCW(Result));
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.fill) */
		F2960_34018(Current, Result);
		F2960_34019(Current, Result);
		F2960_34020(Current, Result);
		F2960_34021(Current, Result);
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_LOCALE_INFO.set_id) */
		(void) RTCW(Result);
		RTAR(Result, arg1);
		*(EIF_REFERENCE *)(Result + _REFACS_34_) = (EIF_REFERENCE) arg1;
		/* END INLINED CODE */
	}
	;
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.is_available */
EIF_BOOLEAN F2960_34011 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLIU(3);
	
	RTGC;
	if (EIF_TEST (inline_F2960_34046())) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		tr1 = F2960_34048(Current, tr1);
		Result = F223_3688(Current, tr1);
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		Result = F223_3688(Current, tr1);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.available_locales */
EIF_REFERENCE F2960_34012 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(6);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc2);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,loc1);
	RTLIU(6);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1541,2927,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1541, _OBJSIZ_2_3_0_1_0_0_0_0_);
	}
	F1542_14910(RTCW(Result));
	loc2 = RTLNS(eif_new_type(786, 0x00).id, 786, _OBJSIZ_3_0_0_1_0_2_0_0_);
	tr1 = RTMS_EX_H("/usr/share/i18n/locales/",24,2077116975);
	F787_11061(RTCW(loc2), tr1);
	{
		/* INLINED CODE (DIRECTORY.exists) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(loc2);
		tr1 = F787_11100(loc2);
		tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
		tb1 = (EIF_BOOLEAN) EIF_TEST(eif_dir_exists((EIF_FILENAME) tp1));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = RTMS_EX_H("/usr/lib/locale",15,443040613);
		{
			/* INLINED CODE (DIRECTORY.make) */
			(void) RTCW(loc2);
			F787_11062(loc2, tr1);
			/* END INLINED CODE */
		}
		;
	}
	{
		/* INLINED CODE (DIRECTORY.exists) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(loc2);
		tr1 = F787_11100(loc2);
		tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
		tb1 = (EIF_BOOLEAN) EIF_TEST(eif_dir_exists((EIF_FILENAME) tp1));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if (tb1) {
		loc3 = F787_11080(RTCW(loc2));
		{
			/* INLINED CODE (ARRAYED_LIST.start) */
			(void) RTCW(loc3);
			*(EIF_INTEGER_32 *)(loc3 + O12515[Dtype(loc3)-1567]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			/* END INLINED CODE */
		}
		;
		for (;;) {
			{
				/* INLINED CODE (LIST.after) */
				tb1 = (EIF_BOOLEAN)  0;
				(void) RTCW(loc3);
				ti4_1 = *(EIF_INTEGER_32 *)(loc3 + O12515[Dtype(loc3)-1567]);
				ti4_2 = F1568_15158(loc3);
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) 1L)));
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			loc1 = RTLNS(eif_new_type(2927, 0x00).id, 2927, _OBJSIZ_6_0_0_0_0_0_0_0_);
			tr1 = F1568_15142(RTCW(loc3));
			F2928_33302(RTCW(loc1), tr1);
			tr1 = *(EIF_REFERENCE *)(RTCW(loc1) + _REFACS_1_);
			if (F223_3688(Current, tr1)) {
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R11984[Dtype(RTCW(Result))-1324])(Result, loc1);
			}
			{
				/* INLINED CODE (ARRAYED_LIST.forth) */
				(void) RTCW(loc3);
				(*(EIF_INTEGER_32 *)(loc3 + O12515[Dtype(loc3)-1567]))++;
				/* END INLINED CODE */
			}
			;
		}
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.default_locale_id */
EIF_REFERENCE F2960_34013 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTGC;
	tr1 = RTMS_EX_H("",0,0);
	F223_3685(Current, tr1);
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.current_locale_id) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2927, 0x00).id, 2927, _OBJSIZ_6_0_0_0_0_0_0_0_);
		tr2 = F2960_34016(Current);
		F2928_33302(RTCW(tr1), tr2);
		/* END INLINED CODE */
	}
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {I18N_HOST_LOCALE_IMP}.system_locale_id */
EIF_REFERENCE F2960_34014 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.default_locale_id) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = RTMS_EX_H("",0,0);
		F223_3685(Current, tr2);
		tr1 = F2960_34015(Current);
		/* END INLINED CODE */
	}
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {I18N_HOST_LOCALE_IMP}.current_locale_id */
EIF_REFERENCE F2960_34015 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	Result = RTLNS(eif_new_type(2927, 0x00).id, 2927, _OBJSIZ_6_0_0_0_0_0_0_0_);
	tr1 = F2960_34016(Current);
	F2928_33302(RTCW(Result), tr1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.locale_name */
EIF_REFERENCE F2960_34016 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_locale_name) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = RTOSCF(3691,F223_3691, (Current));
		tr1 = *(EIF_REFERENCE *)(RTCW(tr2));
		/* END INLINED CODE */
	}
	Result = F2245_21894(RTCV(tr1));
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.fill */
void F2960_34017 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	F2960_34018(Current, arg1);
	F2960_34019(Current, arg1);
	F2960_34020(Current, arg1);
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.fill_code_page_info) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = F2960_34042(Current);
		F225_3744(RTCW(arg1), tr1);
		F225_3745(RTCW(arg1), tr1);
		F225_3746(RTCW(arg1), tr1);
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_date_time_info */
void F2960_34018 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_date_time_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F224_3734();
		tr2 = F223_3686(Current, ti4_1);
		tr1 = F2960_34047(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2254_22223(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_date_time_format) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_3_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_long_date_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F224_3735();
		tr2 = F223_3686(Current, ti4_1);
		tr1 = F2960_34047(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2254_22223(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_long_date_format) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_4_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_long_time_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F224_3736();
		tr2 = F223_3686(Current, ti4_1);
		tr1 = F2960_34047(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2254_22223(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_long_time_format) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_6_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_am_suffix) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F224_3732();
		tr2 = F223_3686(Current, ti4_1);
		tr1 = F2960_34047(Current, tr2);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_am_suffix) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_8_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_pm_suffix) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F224_3733();
		tr2 = F223_3686(Current, ti4_1);
		tr1 = F2960_34047(Current, tr2);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_pm_suffix) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_9_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	tr1 = F2960_34027(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_day_names) */
		(void) RTCW(arg1);
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(arg1 + _REFACS_12_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F2960_34028(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_month_names) */
		(void) RTCW(arg1);
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(arg1 + _REFACS_13_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F2960_34029(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_abbreviated_day_names) */
		(void) RTCW(arg1);
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(arg1 + _REFACS_14_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F2960_34030(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_abbreviated_month_names) */
		(void) RTCW(arg1);
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(arg1 + _REFACS_15_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_numeric_info */
void F2960_34019 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_decimal_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->decimal_point);
		F2252_22135(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_decimal_separator) */
		(void) RTCW(arg1);
		tr3 = F2245_21894(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_16_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_group_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->thousands_sep);
		F2252_22135(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_group_separator) */
		(void) RTCW(arg1);
		tr3 = F2245_21894(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + _REFACS_17_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_grouping) */
		tr1 = (EIF_REFERENCE)  0;
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->grouping);
		tr1 = F2960_34045(Current, tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_grouping) */
		(void) RTCW(arg1);
		RTAR(arg1, tr2);
		*(EIF_REFERENCE *)(arg1 + _REFACS_21_) = (EIF_REFERENCE) tr2;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_currency_info */
void F2960_34020 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_symbol) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F224_3738();
		tr2 = F223_3686(Current, ti4_1);
		tr1 = F2960_34047(Current, tr2);
		F2254_22268(RTCW(tr1), ((EIF_INTEGER_32) 1L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_symbol) */
		(void) RTCW(arg1);
		tr3 = F2245_21894(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O3780[Dtype(arg1)-227]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F2960_34035(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_symbol_location) */
		(void) RTCW(arg1);
		*(EIF_INTEGER_32 *)(arg1 + O3781[Dtype(arg1)-227]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_decimal_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_decimal_point);
		F2252_22135(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_decimal_separator) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O3785[Dtype(arg1)-227]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F2960_34037(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_numbers_after_decimal_separator) */
		(void) RTCW(arg1);
		*(EIF_INTEGER_32 *)(arg1 + O3786[Dtype(arg1)-227]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_group_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_thousands_sep);
		F2252_22135(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_group_separator) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O3787[Dtype(arg1)-227]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_positive_sign) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->positive_sign);
		F2252_22135(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_positive_sign) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O3789[Dtype(arg1)-227]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_negative_sign) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->negative_sign);
		F2252_22135(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_negative_sign) */
		(void) RTCW(arg1);
		tr3 = F2245_21895(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O3790[Dtype(arg1)-227]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_grouping) */
		tr1 = (EIF_REFERENCE)  0;
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_grouping);
		tr1 = F2960_34045(Current, tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_grouping) */
		(void) RTCW(arg1);
		RTAR(arg1, tr2);
		*(EIF_REFERENCE *)(arg1 + O3791[Dtype(arg1)-227]) = (EIF_REFERENCE) tr2;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_int_currency_symbol) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->int_curr_symbol);
		F2252_22135(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_international_currency_symbol) */
		(void) RTCW(arg1);
		tr3 = F2245_21894(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(arg1 + O3792[Dtype(arg1)-227]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F2960_34044(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_international_currency_numbers_after_decimal_separator) */
		(void) RTCW(arg1);
		*(EIF_INTEGER_32 *)(arg1 + O3798[Dtype(arg1)-227]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_code_page_info */
void F2960_34021 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLR(5,arg1);
	RTLIU(6);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(897, 0x00).id, 897, _OBJSIZ_1_0_0_1_0_0_0_0_);
		tp1 = inline_F223_3689();
		F898_12882(RTCW(tr1), tp1);
		tr3 = *(EIF_REFERENCE *)(RTCW(tr1));
		tr2 = F2960_34047(Current, tr3);
		/* END INLINED CODE */
	}
	loc1 = tr2;
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_ansi_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		(void) RTCW(arg1);
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2245_21888(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(arg1) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(arg1) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_oem_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		(void) RTCW(arg1);
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2245_21888(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(arg1 + _REFACS_1_) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(arg1 + _REFACS_1_) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_mac_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		(void) RTCW(arg1);
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2245_21888(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(arg1 + _REFACS_2_) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(arg1 + _REFACS_2_) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.get_long_date_format */
EIF_REFERENCE F2960_34022 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F224_3735();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F223_3687(ti4_1);
		F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2960_34047(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2254_22223(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_long_time_format */
EIF_REFERENCE F2960_34023 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F224_3736();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F223_3687(ti4_1);
		F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2960_34047(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2254_22223(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_am_suffix */
EIF_REFERENCE F2960_34024 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F224_3732();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F223_3687(ti4_1);
		F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2960_34047(Current, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_pm_suffix */
EIF_REFERENCE F2960_34025 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F224_3733();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F223_3687(ti4_1);
		F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2960_34047(Current, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_date_time_format */
EIF_REFERENCE F2960_34026 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F224_3734();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F223_3687(ti4_1);
		F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2960_34047(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2254_22223(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_day_names */
EIF_REFERENCE F2960_34027 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc3);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 7L);
	{
		static EIF_TYPE_INDEX typarr0[] = {1603,2253,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1603, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1604_15328(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), loc2);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12632[Dtype(Result)-1603]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12631[Dtype(Result)-1603]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F224_3701();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) (ti4_2 + (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)) % loc2));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F223_3687(ti4_2);
			F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc3 = F2960_34047(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			ti4_2 = *(EIF_INTEGER_32 *)(Result + O12632[Dtype(Result)-1603]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc3;
			RTAR(tr1,loc3);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_month_names */
EIF_REFERENCE F2960_34028 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc2);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1603,2253,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1603, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1604_15328(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 12L));
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12632[Dtype(Result)-1603]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12631[Dtype(Result)-1603]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F224_3720();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_2 + loc1) - ((EIF_INTEGER_32) 1L));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F223_3687(ti4_2);
			F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc2 = F2960_34047(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			ti4_2 = *(EIF_INTEGER_32 *)(Result + O12632[Dtype(Result)-1603]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc2;
			RTAR(tr1,loc2);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_abbreviated_day_names */
EIF_REFERENCE F2960_34029 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc3);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 7L);
	{
		static EIF_TYPE_INDEX typarr0[] = {1603,2253,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1603, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1604_15328(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), loc2);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12632[Dtype(Result)-1603]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12631[Dtype(Result)-1603]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F224_3694();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) (ti4_2 + (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)) % loc2));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F223_3687(ti4_2);
			F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc3 = F2960_34047(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			ti4_2 = *(EIF_INTEGER_32 *)(Result + O12632[Dtype(Result)-1603]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc3;
			RTAR(tr1,loc3);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_abbreviated_month_names */
EIF_REFERENCE F2960_34030 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc2);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1603,2253,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1603, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1604_15328(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 12L));
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12632[Dtype(Result)-1603]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12631[Dtype(Result)-1603]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F224_3708();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_2 + loc1) - ((EIF_INTEGER_32) 1L));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F223_3687(ti4_2);
			F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc2 = F2960_34047(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			ti4_2 = *(EIF_INTEGER_32 *)(Result + O12632[Dtype(Result)-1603]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc2;
			RTAR(tr1,loc2);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_decimal_separator */
EIF_REFERENCE F2960_34031 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->decimal_point);
	F2252_22135(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_group_separator */
EIF_REFERENCE F2960_34032 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->thousands_sep);
	F2252_22135(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_grouping */
EIF_REFERENCE F2960_34033 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->grouping);
	Result = F2960_34045(Current, tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_symbol */
EIF_REFERENCE F2960_34034 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F224_3738();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F223_3687(ti4_1);
		F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2960_34047(Current, tr2);
	{
		/* INLINED CODE (STRING_32.remove_head) */
		(void) RTCW(Result);
		if ((EIF_BOOLEAN) (((EIF_INTEGER_32) 1L) > *(EIF_INTEGER_32 *)(Result+ _LNGOFF_1_1_0_2_))) {
			*(EIF_INTEGER_32 *)(Result+ _LNGOFF_1_1_0_2_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
			F2247_21933(Result);
		} else {
			F2254_22229(Result, (EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(Result+ _LNGOFF_1_1_0_2_) - ((EIF_INTEGER_32) 1L)));
		}
		/* END INLINED CODE */
	}
	;
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_symbol_location */
EIF_INTEGER_32 F2960_34035 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F224_3738();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(784, 0x00).id, 784, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F223_3687(ti4_1);
		F785_10961(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	loc1 = F2960_34047(Current, tr2);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(loc1);
		ti4_1 = *(EIF_INTEGER_32 *)(loc1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		{
			/* INLINED CODE (STRING_32.item) */
			tw1 = (EIF_CHARACTER_32)  0;
			(void) RTCW(loc1);
			tr1 = *(EIF_REFERENCE *)(loc1);
			tw1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tw1 = tw1;
		tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '-';
		tb1 = tw1 == tw2;
		if (tb1) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			{
				/* INLINED CODE (STRING_32.item) */
				tw1 = (EIF_CHARACTER_32)  0;
				(void) RTCW(loc1);
				tr1 = *(EIF_REFERENCE *)(loc1);
				tw1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) - ((EIF_INTEGER_32) 1L))))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tw1 = tw1;
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '+';
			tb1 = tw1 == tw2;
			if (tb1) {
				Result = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			} else {
				{
					/* INLINED CODE (STRING_32.item) */
					tw1 = (EIF_CHARACTER_32)  0;
					(void) RTCW(loc1);
					tr1 = *(EIF_REFERENCE *)(loc1);
					tw1 = 
						/* INLINED CODE (SPECIAL.item) */
						*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) - ((EIF_INTEGER_32) 1L))))
						/* END INLINED CODE */;
					/* END INLINED CODE */
				}
				tw1 = tw1;
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
				tb1 = tw1 == tw2;
				if (tb1) {
					RTLE;
					return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					RTLE;
					return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
				}
			}
		}
	} else {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_decimal_separator */
EIF_REFERENCE F2960_34036 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_decimal_point);
	F2252_22135(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_numbers_after_decimal_separator */
EIF_INTEGER_32 F2960_34037 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_NATURAL_32 tu4_1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tu4_1 = (EIF_NATURAL_32) (EIF_CHARACTER_8) (((struct lconv *)tp1)->frac_digits);
	Result = (EIF_INTEGER_32) tu4_1;
	if ((EIF_BOOLEAN)(Result == ((EIF_INTEGER_32) 255L))) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	}
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_group_separator */
EIF_REFERENCE F2960_34038 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_thousands_sep);
	F2252_22135(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_positive_sign */
EIF_REFERENCE F2960_34039 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->positive_sign);
	F2252_22135(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_negative_sign */
EIF_REFERENCE F2960_34040 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->negative_sign);
	F2252_22135(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_grouping */
EIF_REFERENCE F2960_34041 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_grouping);
	Result = F2960_34045(Current, tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_code_page */
EIF_REFERENCE F2960_34042 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(897, 0x00).id, 897, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tp1 = inline_F223_3689();
	F898_12882(RTCW(loc1), tp1);
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	Result = F2960_34047(Current, tr1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_int_currency_symbol */
EIF_REFERENCE F2960_34043 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->int_curr_symbol);
	F2252_22135(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_int_currency_numbers_after_decimal_separator */
EIF_INTEGER_32 F2960_34044 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_NATURAL_32 tu4_1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tu4_1 = (EIF_NATURAL_32) (EIF_CHARACTER_8) (((struct lconv *)tp1)->int_frac_digits);
	Result = (EIF_INTEGER_32) tu4_1;
	if ((EIF_BOOLEAN)(Result == ((EIF_INTEGER_32) 255L))) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	}
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.pointer_to_array */
EIF_REFERENCE F2960_34045 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_NATURAL_32 tu4_1;
	EIF_CHARACTER_32 tw1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,Result);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
	F2252_22135(RTCW(loc1), arg1);
	{
		static EIF_TYPE_INDEX typarr0[] = {1604,2060,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1604, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	F1605_15328(RTCW(Result), ((EIF_INTEGER_32) 0L), ((EIF_INTEGER_32) 1L), ti4_1);
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 > ti4_1)) break;
		{
			/* INLINED CODE (STRING_32.item) */
			tw1 = (EIF_CHARACTER_32)  0;
			(void) RTCW(loc1);
			tr1 = *(EIF_REFERENCE *)(loc1);
			tw1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc2 - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tw1 = tw1;
		tu4_1 = (EIF_NATURAL_32) tw1;
		loc3 = (EIF_INTEGER_32) tu4_1;
		if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 255L))) {
			loc2 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		} else {
			{
				/* INLINED CODE (ARRAY.put) */
				(void) RTCW(Result);
				tr1 = *(EIF_REFERENCE *)(Result);
				/* INLINED CODE (SPECIAL.put) */
				*((EIF_INTEGER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc2 - *(EIF_INTEGER_32 *)(Result+ _LNGOFF_1_1_0_1_)))) = loc3;
				/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			;
		}
		loc2++;
	}
	if ((EIF_BOOLEAN)(loc3 != ((EIF_INTEGER_32) 255L))) {
		F1605_15354(RTCW(Result), ((EIF_INTEGER_32) 0L), loc2);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.c_is_solaris */
EIF_BOOLEAN F2960_34046 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F2960_34046 ());
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.utf8_pointer_to_string */
EIF_REFERENCE F2960_34047 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(7);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,tr1);
	RTLR(3,Current);
	RTLR(4,tr2);
	RTLR(5,tr3);
	RTLR(6,Result);
	RTLIU(7);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(897, 0x00).id, 897, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tp1 = *(EIF_POINTER *)(RTCW(arg1)+ _PTROFF_0_1_0_1_0_0_);
	F898_12882(RTCW(loc1), tp1);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_0_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		{
			/* INLINED CODE (C_STRING.string) */
			tr1 = (EIF_REFERENCE)  0;
			(void) RTCW(loc1);
			tp1 = F898_12900(loc1);
			ti4_1 = (EIF_INTEGER_32) strlen((char*) tp1);
			tr1 = F898_12890(loc1, ((EIF_INTEGER_32) 1L), ti4_1);
			/* END INLINED CODE */
		}
		tr1 = tr1;
		{
			/* INLINED CODE (UNICODE_CONVERSION.utf8_to_utf32) */
			tr2 = (EIF_REFERENCE)  0;
			tr3 = RTLNS(eif_new_type(165, 0x00).id, 165, _OBJSIZ_0_0_0_0_0_0_0_0_);
			tr2 = F166_2927(RTCW(tr3), tr1);
			/* END INLINED CODE */
		}
		Result = tr2;
	} else {
		Result = RTLNS(eif_new_type(2253, 0x00).id, 2253, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2245_21835(RTCW(Result));
		RTLE;
		return (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.guess_proper_locale */
EIF_REFERENCE F2960_34048 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc8 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_32 tw1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(11);
	RTLR(0,arg1);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLR(3,loc5);
	RTLR(4,loc4);
	RTLR(5,loc8);
	RTLR(6,loc7);
	RTLR(7,Current);
	RTLR(8,loc6);
	RTLR(9,tr2);
	RTLR(10,Result);
	RTLIU(11);
	
	RTGC;
	tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '_';
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_CHARACTER_32)) R17036[Dtype(RTCW(arg1))-2248])(arg1, tw1);
	if (tb1) {
		loc1 = RTLNS(eif_new_type(897, 0x00).id, 897, _OBJSIZ_1_0_0_1_0_0_0_0_);
		F898_12878(RTCW(loc1), arg1);
		ti4_1 = inline_F223_3693();
		{
			/* INLINED CODE (C_STRING.item) */
			tp1 = (EIF_POINTER)  0;
			(void) RTCW(loc1);
			tr1 = *(EIF_REFERENCE *)(loc1);
			tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
			/* END INLINED CODE */
		}
		tp1 = tp1;
		loc2 = inline_F223_3692(ti4_1, tp1);
		if ((EIF_BOOLEAN)(loc2 == loc3)) {
			loc5 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17077[Dtype(RTCW(arg1))-2248])(arg1);
			loc1 = RTLNS(eif_new_type(897, 0x00).id, 897, _OBJSIZ_1_0_0_1_0_0_0_0_);
			tr1 = RTMS_EX_H("",0,0);
			F898_12878(RTCW(loc1), tr1);
			ti4_1 = inline_F223_3693();
			{
				/* INLINED CODE (C_STRING.item) */
				tp1 = (EIF_POINTER)  0;
				(void) RTCW(loc1);
				tr1 = *(EIF_REFERENCE *)(loc1);
				tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
				/* END INLINED CODE */
			}
			tp1 = tp1;
			loc2 = inline_F223_3692(ti4_1, tp1);
			if ((EIF_BOOLEAN)(loc2 != loc3)) {
				loc1 = RTLNS(eif_new_type(897, 0x00).id, 897, _OBJSIZ_1_0_0_1_0_0_0_0_);
				F898_12882(RTCW(loc1), loc2);
				{
					/* INLINED CODE (C_STRING.string) */
					tr1 = (EIF_REFERENCE)  0;
					(void) RTCW(loc1);
					tp1 = F898_12900(loc1);
					ti4_1 = (EIF_INTEGER_32) strlen((char*) tp1);
					tr1 = F898_12890(loc1, ((EIF_INTEGER_32) 1L), ti4_1);
					/* END INLINED CODE */
				}
				loc4 = tr1;
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17077[Dtype(RTCW(loc4))-2248])(loc4);
				tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R17060[Dtype(RTCW(tr1))-2248])(tr1, loc5);
				if (tb1) {
					loc8 = (EIF_REFERENCE) loc4;
				}
			}
			if ((EIF_BOOLEAN)(loc8 == NULL)) {
				loc7 = F2960_34012(Current);
				{
					/* INLINED CODE (LINKED_LIST.start) */
					(void) RTCW(loc7);
					if ((EIF_BOOLEAN)(*(EIF_REFERENCE *)(loc7) != NULL)) {
						tr1 = *(EIF_REFERENCE *)(loc7);
						RTAR(loc7, tr1);
						*(EIF_REFERENCE *)(loc7 + _REFACS_1_) = (EIF_REFERENCE) tr1;
						*(EIF_BOOLEAN *)(loc7 + O12401[Dtype(loc7)-1541]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
					} else {
						*(EIF_BOOLEAN *)(loc7 + O12401[Dtype(loc7)-1541]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					}
					*(EIF_BOOLEAN *)(loc7 + O12400[Dtype(loc7)-1541]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
					/* END INLINED CODE */
				}
				;
				for (;;) {
					tb1 = '\01';
					tb2 = *(EIF_BOOLEAN *)(RTCW(loc7) + O12401[Dtype(loc7)-1541]);
					if (!tb2) {
						tb1 = (EIF_BOOLEAN)(loc8 != NULL);
					}
					if (tb1) break;
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R11997[Dtype(RTCW(loc7))-1346])(loc7);
					loc6 = *(EIF_REFERENCE *)(RTCW(tr1) + _REFACS_1_);
					tb2 = F2252_22163(RTCW(loc6));
					if (tb2) {
						loc4 = F2245_21888(RTCW(loc6));
						tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17077[Dtype(RTCW(loc4))-2248])(loc4);
						tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R17060[Dtype(RTCW(tr1))-2248])(tr1, loc5);
						if (tb2) {
							loc8 = (EIF_REFERENCE) loc4;
						}
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R11974[Dtype(RTCW(loc7))-1324])(loc7);
				}
			}
		}
	}
	if ((EIF_BOOLEAN)(loc8 == NULL)) {
		tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17032[Dtype(RTCW(arg1))-2248])(arg1);
		if (tb2) {
			tr1 = F2245_21888(RTCW(arg1));
			RTLE;
			return (EIF_REFERENCE) tr1;
		} else {
			tr1 = RTLNS(eif_new_type(165, 0x00).id, 165, _OBJSIZ_0_0_0_0_0_0_0_0_);
			{
				/* INLINED CODE (UTF_CONVERTER.utf_32_string_to_utf_8_string_8) */
				tr2 = (EIF_REFERENCE)  0;
				(void) RTCW(tr1);
				tr2 = RTLNS(eif_new_type(2249, 0x00).id, 2249, _OBJSIZ_1_1_0_3_0_0_0_0_);
				ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17055[Dtype(RTCW(arg1))-2248])(arg1);
				F2248_21965(RTCW(tr2), ti4_1);
				F166_2914(tr1, arg1, tr2);
				/* END INLINED CODE */
			}
			Result = tr2;
		}
	} else {
		RTLE;
		return (EIF_REFERENCE) loc8;
	}
	RTLE;
	return Result;
}

void EIF_Minit1992 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
