note
	description:
		"[
		Precomputed values of number frequently used in DECIMAL class to 
        30000 precision digits.
		]"
	copyright: "Copyright (c) 2011, SEL, York University, Toronto and others."
	license: "MIT License"
	date: "$Date: 2012-06-21 00:11:54 +0000 (Thu, 21 Jun 2012) $"
	revision: "$Revision: 88953 $"

class
	DCM_PRECOMPUTED_VALUES

create 
	make

feature {NONE} --Initialization

	make
		do
		
		end

feature --Access
	ln10: STRING = "2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058498078280597511938544450099781311469159346662410718466923101075984383191912922307925037472986509290098803919417026544168163357275557031515961135648465461908970428197633658369837163289821744073660091621778505417792763677311450417821376601110107310423978325218948988175979217986663943195239368559164471182467532456309125287783309636042629821530408745609277607266413547875766162629265682987049579549139549180492090694385807900327630179415031178668620924085379498612649334793548717374516758095370882810674524401058924449764796860751202757241818749893959716431055188481952883307466993178146349300003212003277656541304726218839705967944579434683432183953044148448037013057536742621536755798147704580314136377932362915601281853364984669422614652064599420729171193706024449293580370077189810973625332245483669885055282859661928050984471751985036666808749704969822732202448233430971691111368135884186965493237149969419796878030088504089796185987565798948364452120436982164152929878117429733325886079159125109671875109292484750239305726654462762009230687915181358034777012955936462984123664970233551745861955647724618577173693684046765770478743197805738532718109338834963388130699455693993461010907456160333122479493604553618491233330637047517248712763791409243983318101647378233796922656376820717069358463945316169494117018419381194054164494661112747128197058177832938417422314099300229115023621921867233372683856882735333719251034129307056325444266114297653883018223840910261985828884335874559604530045483707890525784731662837019533922310475275649981192287427897137157132283196410034221242100821806795252766898581809561192083917607210809199234615169525990994737827806481280587927319938934534153201859697110214075422827962982370689417647406422257572124553925261793736524344405605953365915391603125244801493132345724538795243890368392364505078817313597112381453237015084134911223243909276817247496079557991513639828810582857405380006533716555530141963322419180876210182049194926514838926922937078986352706385027022697551249943004381827884731992196581431219760711108763412244664073779455588583919440809311024283085084746319069321981468643083555347651114650769097333395832575068277582831051803299481308483996817211366798801920377706868547950620358417219984374394106362343231481174552475640089192165491269082781506048171199070188629209822862716730477199015770285357910506284673372232400018795615022890843967414685656483176881389206840957969180335433913646786574590549488029854381988073595542704154087340145317392545367328193997645602559843243305615873500293280257230645327034811810847231164468047519194264144375548657693929296834286675851067319241918228522689913893119216944242303851706529337045121498383597940218271629133640253154959691311714663534422264568544683226289253198527399466669571860157929838504401537461528275128857545617541969976789089211724902376347878942402183376781397354658345556295079309046680515976409505248189475873099476612986320677356531111786061537481010815864277211113500176661091149696494183076946301388416026503178481192972380206808689623654396591512067607905008319523024347817883038778471028263055912430624394315691194617233215130478320894258513052642518211479848258424730967079501644395520063137114248500249765290151310380216416843468036623965040057852031727464634148889412770388318760666904172965971359908177369006347894595288976221997880798271398331815395541572978947016728750253235908278131635706663489567636634400113009800938783592130026295307123674302232399707337986684151718246888145657647721175116367797327505183074902665362406067789612931306854975874330548536937665630316711117871564571156402499783053492289780268464608192132840314804827498936970373280933145401019276483406059371514185798933564159483238353253287520100855555015928089183326808993683275161374389819736125706679627161789820168085761103706608215753270001344145799883900770905779094769333871859305574516372163922302788546884992191747753620135740007380802900346480128950506385687149679702782421339869036664769242138722104747932942674694063112638491014361807287766080410512512203857794290637730069124170742882066979861077774302450430789578007873940273257119728212361207957714181867478395175738044597888766309263535332561183535891639650303833404777193733442095669020535984663348283042430767205765885022263704399245813786912612910050862966339808643426856706538613996143539313531483614247934686121473700807141967542133230591398542242736296026835252707454330860376309325759906527931853695952152915790405269385849244062500718796054882446358568358413714733580707756729985326427735317760670765957691014899255065615965724284308760962751475401096713288805825291009414132370624302010898937948541901428716311211438780592832747736394221535425581125164164617665061633826060708786432495934451088742301059691162233864858109313925605573164788595221777415620114648944672391572247882432944846662113928463874193715350804510211018170040998675939589632761524137751011977989522830733147458719084125149128845320329292331889907799972401724198363495403071487492456079023987837044095908189182931318932267101779615883646066016098310338061418288332139895255915139242322429525610918912551474352545267536813785157099205423655668625119889469097891271437839883994404234836623253992113693237393384087357256422102227674072360194115308610349855598008431436298107955203128631532660207271975693753721028575367353104216556458025694603960404313069427014164857524792785136184205453163867281631759378424417717388698381203126982893906235029995046555574802126604990886895208354986807114405225574597018845999987451244974665697321228916979294225917554074302518422506957313727724662714125608114101554710203063484420740118595090777856920631848716983718742667040069571921733340732613951656672326480329303022421188067185119138574488850452631801426873701868174823202011163535031850208975299309933054826170382952855386281755632968663290011210779886921289244661329295417448133163224462493224407826572186888602202803446835097471499946590197305727983187629873155611744885012602366975787150787870810140242326057382998271167957775940139250524607966633255251045774231008341836904213434670150373525245838356143371692672183495388289218359751499688711343808120074364193799939646710986259399319148195651492560980637030630448483156653622926767447054252158852436425331334494111751193450823720142019368551826071657479995604224220373863948942382566342712928728229321371933658050193103288279879097922251654544086990681202072607645862728026643519108533691769369353560212633772746051218081581729300545505033898713185842257727243084979762893029412827008915920113315171697714103700306103623971794621822999949376728095144417951595380244313046020561305623405774440809435543562539610251806557916937912879789632022348607588753293592853852605418419130415182279636867054943203269837819503267751534625644637510226145993842871041651001086982320890071147035158794051261295950286447499446432602757180053078402418240005489949370709539478856774170483693024988900857190446195551864121301283311420169264368304770205943951221471895975165451685554194848303143408510932777786371507942785778250390193741844365203060887670598183598820852935292812133308207381640367330684551932633941469431981317241131960875461690877511182817522094183995392721239436436617720278877457153731271938984863459902796343934012227704935207493194341126536676243200568561146997235207021034466057653056905868926923324775179079597733404131178185670193996565545717754759328189684629785362524295633129686108307603155133332564127570834713871459980652297494460869269946464609614184996978920397987382885032071731979264727523098337096671280819001207766935705882861817815812551673491385905636950041631039957269233434554007420775114289094963707252676275134331440799539662646385953338158417387721448103619997290036860006189589227151080877887680109653132728970383651164763616245337418713523408511704067426091506202162207362868244635556704952884981933391300995638482463358675941130712452558556886569808336592090687945314787836754320194593272607793204853641636733444425114518077059880807989070279740212266267978426378637652297680090691556101948016024914255091395886423205210082797751801449825416163778941552444904378354179074659135860627947990894581991635752282689806096152994281469566042756581265421949517796584972463270602702975982699071046168751289335200931500276306011821377353850649498537050528236551662667240750416484267524703310312540153499715634682432552665805434540570456375305998661938429070133467937570418997892432954029962560178385770919735025933598794923197452860625376663314119693821289513736438582362373883661925958390943833902831314096702698215329920010671144622845226894328758962744557472550036445369732768621419958991235972013417747312058321980923585092170334490465082217797663679431204834061116285659611027939635246492518889371263839901417251962409864260561053450472040201533719616964952283040814694992185855352288301226079725168825821808894082905790283476196429635491705854527783750790411390637181488339324083060801151374561845705167563001798757561228258408222384544631720327780549038605149612591770322499545873959913611921223345086534901587995548677006724492683022739045557054808379300724596704283504267254074866282693281144705627875637603910740001455586982955030165809354838259223016800537770078899857770217150064922081476551798207285680798695654476905131303979018912173052605747623638027783554565891819089660985432602250548106950042972598669827000620813112784829539033184754310161496163244865080174992984236042416112083285177323600798521794331319581811456416884731505855415572147952040774260389560312162197782512242948299043090705235808914465250204831073981622565434531242570607837942057234197554585911603728897972884753423794866363536577071342872349714869596278396193380341220853033801293609977347509509226872800548940261206516939108116731100986798803922410469263464821877356288112935072838074854031568229601171254775955965371654656479801899701644510833953335267680672418994204488045803865148408007573307976867530518547524110507230870091211415199695602952048504551560968801135258921022724452100225724984272187717647528051249260959096957172491229906298212057891792213889212761327852098853408726297941771909830723969250831414869790107036131612844211573785004422385514052477121688290872720728503964827239354970879237179453212528071272861905700834114030914824343636084560205263367052556336244686505247560929150459654347787907790875767547344275726959249443214183682563133135267937621401313947558857630236626902984448025015562395578314037580830202221356621600116453243497866339511670614724853598528842360132807564802051686007014692573697178512782081057672187313281003283107218223399327547001013007666592899591248592311575942567243084407403181680891851519766320851300430161771878874633610239091983889970827403710031005799601305322082607180025256111828328430787267083566315614265040952357741793440327114840636701013668825667721411668626867849082659032171906822397810370893683133281172250522420609890550569627228743486737486428825449539240603742827673689750745917910003290333023269594759330360285183541631912707048455566005561268890051592114971511294132051449803128745581332395504262044873973617767973608071085418840299632758538565255949099518975654516685053499507265063375307249603945961347318300099611755423569041902870163923544089092532041155469325275976052881121984210082220644531958106859328669270885463494318964384915079613343641978084553924918199236307124891862433953818250940476790517513326617901033291593961270887234407001644785323818042558877159560788427425974765118164735626458847848979959199040737622699589245749717398852878134663856630995916376282646757529075926932481790557370040552801670379173182571213510494928574198269630164535690286183559543902320883063841755368712975910850478800401053084489622508568286632122160553522010486868130408237095682101959765232793470298732814534595092216509086062914215491003047919100772388258676270477830900162869918675492633383287137809319915386481380587466831695643827298219065296697678103665786962074859825282090274236993802428738816816351082393360605931550911710673461070804603182892754454057004349268761977647765880378416134131613456923413915001428329741051306844221277715184228535211495279395938121676033354062154987558328899745258030672785812679223753929178563717475588720328402683311200957981009248931535543400326317474349915367476591685975866326683842225438107633727605185660714811774566549986491383056401754288749915943124354967687724474720785893199150346327173335334677878329318795252380932912051343428296549904992203315010356807402308868946465527485292797375153103899486371773696156500986118313655793017367982121182843420425384542421903800313790348746271673390475278339811872867217368844539652774626786613591722837033867048860904199159708450485393491790162094846829927991844057981787161505963853936185810649711043776533327968500260781137907526302244307739389002009160708112280630705969602008543841458952553426898154392997638914877039580518297890569634747058787437288364902763154862604801497444998926662471266673649048780765281488269354535311444425671338545254521170291243538532337431934251385632413031239201100336908343404209547381268634685401810301878722778398521600210284886733121167573996309166394619422004298716992897246852982949650236820649897244156613104412843715365696767468734281920715398881946931988777852450723014701140367892949208232831376534890917828160845914476166454920666199133784007791748065851366649386401971775074327324564927813335238257524738436911352662800219940487883405093254028314389620515578297635916955167082760032902182533780282115108776477362657510831785405899678699837533828400748752457046203900401805615407869697206656598115737077069685249988443884391008311443959232839220018213426083755921955627721312014989997914006150441163505949213414207273196867035499811402631120345897976120551989196249271447107171174125796401950878379085761650811679107976251706165775313136833571465216572762073530428232857834073426619981700245012424485545652299392062248137512210702102580993477381356648951365989428908435982723841719068525538807604753773425679877699626869618226395351041475804727968718219327396267947497635454093985625870015022709201169321216677630576662626240853713601985761527911830955232122800161014787125863573155371881208006299384716484226983458864100521825237939207162235272679428773931026479215241284757477676862033783569186900655532013285836843242595179570742825672161377712697929987529061914894604929002828249662428250723599719628001836644146724455822086582943171980583687956183677487535673417910430847136106369711110643236893816963543420467109835920767369251701069294301586241693358421858334709074877806707752758021346409279507233751053940988972453692663249394295842276800478005584197356055900397313374923549119801360834504651504223929597642700441222135740812971293716911657560960118113418409413219423189838999573642011624362198895590147565287844182573945145587714961996923442039288833593294714050260863890969481310512954640106424499329069828488830067966366668924538915282556395935992563280770632521612066879264423374572540306218893159154708143041174481556949361933345274276278503388585696606946313185135387569686036472971483165785623774605726459497155195681437450919583119381850716070352013788150817175867183420494694907614183584683779006172844925167410764342956371412068989864669212283532033895681202785700598279592701773893834945258168688884563626663369902219259896509956839101783937852713594488443337705448984724442463287616494581691094955009510464514044911637524096962141363995153961522774517818611834180901438153100116211414448917919221521172024800919654152617272592492249014104888264882688034382414934193711400603808312822568596734172388651607527747624410509030885115437780933871961174967693013171680990657618808796184483509593642397265771863796205332528150113604255915293996958376187252862699428203314561154986405207888302266114540877598709249017961397549695762544823954801120788502893121733291359669835699081170259844347411408157867063103768188368340713236512920689388078714879121807809664258940853387111756459699521175295617258228648596672724899287515539338316642160488009291881186636222656819583210520363831954438448395763601027512289363081089201381323380641905634958639246156544402071425118133838306044271259251760457919870183601263685025533694001837089243640877080067210394168797085349600727629529816631082808808367210199959812860850821761014099256232240924979908012580287456889550370707254794495802723942374671989105106189188602366651641121917159234708464646297658324939049295601527798043326493162979117383789140067741555507683483375633214813134281299699723607482955957621735064641364626921849540430993923151129316636732076492991140858636996198480537414177900206019644130729584034704792029907031224212624819927889669021826269225083428663312568909199135769216590108432692721663261888656139759087072029637389758969430902138259681130965386345015916876619101561020886810341532692576506708820810983250455264569306304319921089528037668635475878295559992749256765519916660759078059789332021563273764132113870717610251032561393973599628979609746369534427420132623368741009514816123844810576662197070335506876507625253216250332157802340325287392184491724154875497498490554518840631658434793575523360247607242671292522542955113511481311108536164384232277047042615539172429067778918489864449893459822742981498183775584395011096879852805466237491291222840926217937123723872831554961536402813048023460200295676551803138216704631098798916066084954828691139523938156289460202311148893070134403299880815830617747056137678265270317931890815516588143177802185225544733620465721998693184258271516431154385276087524747014777914981680113099805182021079485827483189411763620502457419612342128329768279375266936113971070833147016843717980222236303495223193241584496418563757785991255904383057359479389700585996619693884194831209921646568193711990498548575482890325337860096233059993264808992706828556818320855631005464477257679580369505575949054259909020980961964203137689087074478920666695624179553305146463887931915712019367808093605241737373209136129357648427380876017144394078680825744598393132672756415184146473173562021171236413355148797111730133374812721524448995228485604075034312932686875315585988039391500444306422298274621423296434539075463821085887005303032196387092130585199361204563175445160494007842461275493005732729009761133617360031415649807890115716382799003963864830056612378211444359401057934879968140300181922461128885624612674897711765482594896432031572807707454966169915230973719788488827936544479385562870820064926740252039932553868859977417120791067977832064809775935871764580483348028076840769344098961008348079830953817658363978634852059093705236021087436183129983238975934872942541595893128146876885222119202498556682141819462483947821407298993534265587083079987214156387385481288116502400669964769187700250236532530578375001241535411192817407062782572888824254085967689279600946083626388098833002665853027818351358833143146290257515779048073260469085665065149051374551343910856067718057239100391220805416192873938993754474809967894751815465514980547369687143271152938679687383699377133231588257002523334472594273521268417651004930670394855989490175716305299172870250209019363987381034343043463989736256999800850093512067875132084299850032696459166364122422914202549689832719468864515390551630679573820298453042382463082163494885372318262613589824659766841397965176909220438388443711369240687069863942865115479418128012611668808798898521290019517800306237770434016752154781822343567270804749307978867033757336221184479479204432842141396447616220541343489216857931028768522709668434445978333178372821619758629133514784583635345769169419673063328954801667013987255271126980163879628200247532665561975798155903630264837611843287169826663151275202093653932181280382030513182112746023338924016142978545563781259530003395806967987921809358230530234695533037331545254211420537004054188328243666366823491665220146111076470314415143646103299191307378249435945780547358332300222618150280593128384459579418472077893225186040986780166263484302127724515461957795436380475563408395704565499263033975807443127597503510377657005102128167791364258745210779407801170480348233126834475528402717222088278172561593080011884757441815721376880840728323117317613787810338654901602056073439491652416329288630412486250989209290884990781966626162479597197559424337917456974657998901550197043333476636445604628108750863187863595709684790094756181360885347731518903736280236303502215673253407096730045007800128081669590758953595630295064786471281274748686412435357084449178342324856093865228539895462765112539542139358458462262320634383332262666775465802455989710599883796785943259027573282191867707681252298427616779449746215800597389289492230539657231641483191836810714276155672992881771165085519716487127731622815052096632622940610419079696233510365494100801578205992513919275500240423408851932015787113903804004314771750463299840606295220544377664359806442740613435062222958318674803459240146277432651248425137044112375953664477690768269715402824394604129543861921294679407182771397479828453766037111779198669958026551735620133012385563669218475634844438337871375105635727274013819824381886937210114830536885351042159199912725190387080530538868472031017738200923214446065772473231723296098331076820184089352414501497453660578610898931282307896500477131843980373092504789672055231697500685838588519276135633988322391691232334641278446682297383380151093857857129263639397311906541701463419303198684433651988156709615989257124108656837132074151348037749910461171587687084303908326415869568538932392852446615246616827422552147710021400499938922320618789406562710204676756613549685261210886151949320579188102984965933883053854569875781238090619798218665824267147644870357505451159780293658407835258031112847831455461309248458640489221459550788362959369131493385766491818812132652157291200806256185342857451824701128748128160379048408312629789180009540507310784606383998027435297611966144647878544644429363787912810188329580742419561483224229445319547864196827041603442061741927719120678304271490568447464703654346445837930510505071479563564481998497145071250766072439678495871680271640132555587815980807836717079150644165547370175117883407460827501699054716607606038749289475307604809162535381572013203758434515500198200693033181914083906938883273137772092771312380189570124046091272025179654675218108095779514415886135428879227018284251061446440328293820088269904152459678987802092939726892732906598109329825219478629566319154606683255751313404207063445579281545850285850180854677390032803362836367264891023000091523727575224655230961132448479317783737840651700429850947620249637983829845661825606846442976403342051284998213538988889681843443891035882007829957903518504514708475083898109496547046949642678443661354384981633667168623172303151698704703617674640460379232988368460086895022800301858915312802339792104912112071450723807035065120546177610054911968543063374096796011016983433719771362615502452843504256626508985185911933484814151148556170605980654719970923074011958741149390924293971200696901147315310750132177598279989825229530597789618315028138690267279553399097863224853583745724922570103012578148816385623811629057221657008319421090599027256068929982575597166998622995575574559455165104316957685936910882819032004373308380070273719093333139080009738631599217492941537378737751260185923755045456668470283503990330768519471894855312678588706937672309769187879344745148526303422242631307741523473443879536114016686487228505102784984753574748918746678939825257595145857597043594747576939266145738469641969984211506899153172432974531480726684199700689870910552417729992381860716867328902447192069366642135206219757378225995904823122586444848227190756889409862688892731766081792668192064653318871568175368147383973734965683385249734530386591533752412352026694310180249409208367425919242382973463297101807512738736871263953523721527954054356854522227333674046595149904322363878010270971602923414153984107734293280643142067344137289944659165454138701603277707783402880933960141901513896513728023458636123444890523217123071689824043150451059016220484526088480816306198863575950131182215781585771199660271217778202378739135308647203224448408514041750875260692975058181872033217009422108596046790729522407552350950766926937739572728671294478939477542293023847352715970653847514760510825047668733484845879974173227767522478891909581036926745081355796050006289483522763922965205478286377135997322082443242307649391754631983747275068495353669271551819368417743563081308220741414583964896460926291568696464879979899434305158735722842473072936391764116732770403514436058885705742356367072350150206360262708686488833003684111679727286252821418236636474792207754518402809880630947582032523518824761151195783509138251800628664367098803462266028617922229881603516739888272300121373507753386454874463609009219461688860384105746429055328275727481386904689056474514026798732767503313079589902005609563919018939680494298616040201607674247994409795204750400629431759276301128339512475644255113113008274089617738064929728661909171592709443052032215024095045047068785028876947384197659171459781024328895040535853537847514066750233559663636527466790401530591687806031436678157645955385053839925926515225456138440987871892354797826434798089903275846454224410855039623319583191809047067025928870842078845341110129428504220978639464024032148494099878646622409665240785791964070497090003294103949404248080522657937208425227297911224978028905692890858753732666496187679497675217454963056688720309249060168486912037042266522527453848552661166886715303391987347776794857384835488549963011971696869439963159774474956150472426837214416706826810155925918249288140444217252402336534501613370104425851485889857847084894476311399058590400275504624506741532033774198809482303306522519901505734220702440377837256323773473674311000375811977698102371390678401136669144433530262563060883207382000331361033264728994106209543807167375235866632942035917797240898100685703055332225576719163064858732353734315647928188150403405370236507307126496110567141189494729331331732401149917252279373677092501795205957977287374009794576885587623268938198987359722487045660239509815346750223980586668511850292372156060274567932191961928645696199987140244070990240488184584418031076578754991060828037535739290997523901685596829948479838340125380050371722049185764754759490896747237127762077064537316446765420263022147884228157736886411830994641901462961064005995771290392253123362642259166089033955237963212731033866075177858668251228341090521475412035513990991078852234935515189118391695596560408600391148717418254607371272929467336609773847570357698033165794731054718659939674065550202508074062415984440600484162621911396978895619332926954862885371183219056893438441665570364217671721566318793867488095707377315345281806091839159937108232706091761893280616139931559066486023545943694985807215829279606562190195931694821724886979414673016222314725587716232215271285015222468025051428106338219519890111463341083250555605530250750205311115768901679484362458740351023535473501946865820440924653685002126265009965832896014926516870000465207458892932480998289291042024621280662141041810783057512117084894728025068544772218838674937529538160512264310513495140274157224331046652000854232528243542637928078400123123963796235900980140738815610133696452622088905710317716807519487485026120774127025756568664680552858789369548428834844161546800365865583369875750253497895687292480380849824719754378699270721350715609223991629970742002625127432646202399335256160345616363416489469139466542419768054014897612118243296089270557531504725792079154246925230914556950981390571086977277218335737678378099829103731652111521189198684549849836257263687892297781434014344438187379997356668636027738668005991209466803811449521402742431683128625391473285300999420813035597944056020077962322204883420531985747719875941755561352819639012016527064520078000717111453623711983324219723745637921846349432059497516209395084319568304903186604400349815182522936299647540507417214004943466255004721735746216144832408385894873061550279099175098783088899857661770769764669996250695160123372954648399039775806834630083573795578497922067955637576658621301410153417547669888825059165891554559866302691093994547785305283119016264557773616822645066914851146238664825543623369470756448697693651777372965706106212574855608214317158124111816830946370907383252265128274415208537084294156303440406290204856657847245885406176045373938482732971648288474198524380153855412275603633069856604312925017703548519031704986505325822167744059505870712165532323958838826320554345315963129026894900322695585360883501053193446811602434316075566752128299376569318049710332023170763585119070095564540637107527402146254697371950080756345891404215442782534660330539318903533962124732742708366937376203531173696736145282021835273981658836"

	natural_e: STRING = "2.71828182845904523536028747135266249775724709369995957496696762772407663035354759457138217852516642742746639193200305992181741359662904357290033429526059563073813232862794349076323382988075319525101901157383418793070215408914993488416750924476146066808226480016847741185374234544243710753907774499206955170276183860626133138458300075204493382656029760673711320070932870912744374704723069697720931014169283681902551510865746377211125238978442505695369677078544996996794686445490598793163688923009879312773617821542499922957635148220826989519366803318252886939849646510582093923982948879332036250944311730123819706841614039701983767932068328237646480429531180232878250981945581530175671736133206981125099618188159304169035159888851934580727386673858942287922849989208680582574927961048419844436346324496848756023362482704197862320900216099023530436994184914631409343173814364054625315209618369088870701676839642437814059271456354906130310720851038375051011574770417189861068739696552126715468895703503540212340784981933432106817012100562788023519303322474501585390473041995777709350366041699732972508868769664035557071622684471625607988265178713419512466520103059212366771943252786753985589448969709640975459185695638023637016211204774272283648961342251644507818244235294863637214174023889344124796357437026375529444833799801612549227850925778256209262264832627793338656648162772516401910590049164499828931505660472580277863186415519565324425869829469593080191529872117255634754639644791014590409058629849679128740687050489585867174798546677575732056812884592054133405392200011378630094556068816674001698420558040336379537645203040243225661352783695117788386387443966253224985065499588623428189970773327617178392803494650143455889707194258639877275471096295374152111513683506275260232648472870392076431005958411661205452970302364725492966693811513732275364509888903136020572481765851180630364428123149655070475102544650117272115551948668508003685322818315219600373562527944951582841882947876108526398139559900673764829224437528718462457803619298197139914756448826260390338144182326251509748279877799643730899703888677822713836057729788241256119071766394650706330452795466185509666618566470971134447401607046262156807174818778443714369882185596709591025968620023537185887485696522000503117343920732113908032936344797273559552773490717837934216370120500545132638354400018632399149070547977805669785335804896690629511943247309958765523681285904138324116072260299833053537087613893963917795745401613722361878936526053815584158718692553860616477983402543512843961294603529133259427949043372990857315802909586313826832914771163963370924003168945863606064584592512699465572483918656420975268508230754425459937691704197778008536273094171016343490769642372229435236612557250881477922315197477806056967253801718077636034624592787784658506560507808442115296975218908740196609066518035165017925046195013665854366327125496399085491442000145747608193022120660243300964127048943903971771951806990869986066365832322787093765022601492910115171776359446020232493002804018677239102880978666056511832600436885088171572386698422422010249505518816948032210025154264946398128736776589276881635983124778865201411741109136011649950766290779436460058519419985601626479076153210387275571269925182756879893027617611461625493564959037980458381823233686120162437365698467037858533052758333379399075216606923805336988795651372855938834998947074161815501253970646481719467083481972144888987906765037959036696724949925452790337296361626589760394985767413973594410237443297093554779826296145914429364514286171585873397467918975712119561873857836447584484235555810500256114923915188930994634284139360803830916628188115037152849670597416256282360921680751501777253874025642534708790891372917228286115159156837252416307722544063378759310598267609442032619242853170187817729602354130606721360460003896610936470951414171857770141806064436368154644400533160877831431744408119494229755993140118886833148328027065538330046932901157441475631399972217038046170928945790962716622607407187499753592127560844147378233032703301682371936480021732857349359475643341299430248502357322145978432826414216848787216733670106150942434569844018733128101079451272237378861260581656680537143961278887325273738903928905068653241380627960259303877276977837928684093253658807339884572187460210053114833513238500478271693762180049047955979592905916554705057775143081751126989851884087185640260353055837378324229241856256442550226721559802740126179719280471396006891638286652770097527670697770364392602243728418408832518487704726384403795301669054659374616193238403638931313643271376888410268112198912752230562567562547017250863497653672886059667527408686274079128565769963137897530346606166698042182677245605306607738996242183408598820718646826232150802882863597468396543588566855037731312965879758105012149162076567699506597153447634703208532156036748286083786568030730626576334697742956346437167093971930608769634953288468336130388294310408002968738691170666661468000151211434422560238744743252507693870777751932999421372772112588436087158348356269616619805725266122067975406210620806498829184543953015299820925030054982570433905535701686531205264956148572492573862069174036952135337325316663454665885972866594511364413703313936721185695539521084584072443238355860631068069649248512326326995146035960372972531983684233639046321367101161928217111502828016044880588023820319814930963695967358327420249882456849412738605664913525267060462344505492275811517093149218795927180019409688669868370373022004753143381810927080300172059355305207007060722339994639905713115870996357773590271962850611465148375262095653467132900259943976631145459026858989791158370934193704411551219201171648805669459381311838437656206278463104903462939500294583411648241149697583260118007316994373935069662957124102732391387417549230718624545432220395527352952402459038057445028922468862853365422138157221311632881120521464898051800920247193917105553901139433166815158288436876069611025051710073927623855533862725535388309606716446623709226468096712540618695021431762116681400975952814939072226011126811531083873176173232352636058381731510345957365382235349929358228368510078108846343499835184044517042701893819942434100905753762577675711180900881641833192019626234162881665213747173254777277834887743665188287521566857195063719365653903894493664217640031215278702223664636357555035655769488865495002708539236171055021311474137441061344455441921013361729962856948991933691847294785807291560885103967819594298331864807560836795514966364489655929481878517840387733262470519450504198477420141839477312028158868457072905440575106012852580565947030468363445926525521370080687520095934536073162261187281739280746230946853678231060979215993600199462379934342106878134973469592464697525062469586169091785739765951993929939955675427146549104568607020990126068187049841780791739240719459963230602547079017745275131868099822847308607665368668555164677029113368275631072233467261137054907953658345386371962358563126183871567741187385277229225947433737856955384562468010139057278710165129666367644518724656537304024436841408144887329578473484900030194778880204603246608428753518483649591950828883232065221281041904480472479492913422849519700226013104300624107179715027934332634079959605314460532304885289729176598760166678119379323724538572096075822771784833616135826128962261181294559274627671377944875867536575448614076119311259585126557597345730153336426307679854433857617153334623252705720053039882894990342595662329757824887350292591668258944568946559926584547626945287805165017206747854178879822768065366506419109734345288783386217261562695826544782056729877564263253215942944180399432170000905426507630955884658951717091476074371368933194690909819045012903070995662266203031826493657336984195557769637876249188528656866076005660256054457113372868402055744160308370523122425872234388541231794813885500756893811249353863186352870837998456926199817945233640874295911807474534195514203517261842008455091708456823682008977394558426792142734775608796442792027083121501564063413416171664480698154837644915739001212170415478725919989438253649505147713793991472052195290793961376211072384942906163576045962312535060685376514231153496656837151166042207963944666211632551577290709784731562782775987881364919512574833287937715714590910648416426783099497236744201758622694021594079244805412553604313179926967391575424192966073123937635421392306178767539587114361040894099660894714183406983629936753626215452472984642137528910798843813060955526227208375186298370667872244301957937937860721072542772890717328548743743557819665117166183308811291202452040486822000723440350254482028342541878846536025915064452716577000445210977355858976226554849416217149895323834216001140629507184904277892585527430352213968356790180764060421383073087744601708426882722611771808426643336517800021719034492342642662922614560043373838683355553434530042648184739892156270860956506293404052649432442614456659212912256488935696550091543064261342526684725949143142393988454324863274618428466559853323122104662598901417121034460842716166190012571958707932175696985440133976220967494541854071184464339469901626983516078489245140589409463952678073545797003070511636825194877011897640028276484141605872061841852971891540196882532893091496653457535714273184820163846448324990378860690080727093276731275819665639411489617168329804551397295066876047409154204284299935410258291135022416907694316685742425225090269390348148564513030699251995904363840284292674125734224477655841778861717372654620854982944989467873509295816526320722589923687684570178230380965678831122893058091405726108658848458731016581511675333276748870148291674197015125597825727074064318086014281490241467804723275976842696339357735429301867394397163886117642090040686633988568416810038723892144831760701166845038872123643670433140911557332801829779887365909166596124020217785588548761761619893707943800566633648843650891448055710397652146960276625835990519870423001794655367885674302859746001437854832370687011900784994049309189191816493272597740300748796814848823429320230121280323274603922196875283405169069741942576146739781107154641862733690915849731850111839604825335187484389231772926135430249325628963713619772854566229244616444972845978677115741256703078718851093363444801496752406185365695320741705334867827548278154155619669110551014727990403868972204655508331707823948087859905019475631089841241446728218654599715966390156419417518209359326163168883801327587526014605076760983926257264111201352885913178482994756824725648855333572797722055435681263025357482165854140008053148206971372621497555760518904816223767904149267426000710459226953148351881374638871042735447676235779339939706323966049691453032738878745579059349377723201429548033450006952569809352828877837106705855677494813738586303857628230406940056653405848875270053088324591821834943180498341996399814587734358631159405704436835152853836094429559643606760902217418968835481316439974377641583652422346426195973904554506806952328507518687194490647677918867203064186307510535121498510512073138466487175475183829799901893177515506399810164664145921024068382946032085355540581471592732206775676692136640815059008069525406106285364082932766219319399338616238360691117677854482361293268581999652392754884274354144028845364555951247355461394031549520973970518962401579768326394506332304521926450496517354667756992957189896904709027302885449454166997919929480382549802859460290527631455803165140662291712234293758061439934849143621079935767373179489642524888137204355792875113858569733819760835244232404667780209483996399466848337747067254836188482730006483191638260221105552212467333231844630055044818499169966220877461402161570210296033185887273332987793525701823938612440268683395558706077581699543984695685406711744449324795195721594196458637361269155264575747869859642421765928968623835063704339398116713975447362286255068036826641355414480489977213731741191999700172939073033508690209225191244473932783761563218108428982077069741387070532661176836986477417871802027294129823108887968318808543673278068797716591116542244538066258617117294980382488799865040615639756299369628093581897614910171453435566595427570641944088338168411111662007597872441370823339178861147082286575310785366746950184621407364939173662549377830140743026684221503351177364718538723240404210379077502660201148149354822289166636407824501668153412135052785785393326061102498022730936367402135153864316930152674605360643517321547010914406508788236367642368311873909374642326090216463656275539768340194829327957506243996452725786244003759834220508089351290231224759706441056783618708771723335554654825989068612014101072224659040085537982352538851716235182565184822031252149507003783004112162121260527260599443204430562745229161288917668141606391312359753503903200775295873924124764518508091639114592960711563442043471335447209811784614510778723991406062902282766643092649005922498102910687594345338583303911787475759770659535709796400122240921990311582292596679131539915614380701292607801970225896629233681543124994122594600233994722281710566039318772268004938331489803385489094686851307892920642428191747958661999444111962087304980643850068526202584328420855823385669366498497208170461353761635840153428406741185875815465145982702286766718553093119233401912861706133648731831975608125694600894029530944291195902959685639230376899763274622839007354571445964141082292859222393328362101928229372435902830038844457013837716320565183519701001157220109569978904849644534346121292249647323561263219511557015658244276615993264631558066720531275969485380573642083849188870951760522878173394627476446568589009362661233111529108160415241002141959373497864316615567327027921095935430555797326605546779635520053783046195406369718429161685827341222171458858708142740902481854464217748769250933287856706746773812267528316535592452045780705413525769032535227389638474956462559403789249250076243868937764753101023237467337714745816255306980324990336764554303052745615129612145859444321507490514914539509810013887379263799648737283964168975551322759620118382486507469854920380976919326064376087432093856028156428497565493079097338541855835157894098140076918923890630905425348838968317629041202129491671958119357912031625143440965031328352167280213724159473440954983161383225054867081722214751384251667904454166173032008203309028954888085167972584958134071321805339888281393460498505323404725950972143314925866042485114058195797115641914588428330005256847768743059163904943068713431187961896374755033628209399493436903210319768981120555953694654247041733238953940460353253967583543953505167202616479613477909123279952649290451511483079233693821660107028726519381438448445326395173941101311525027504657493430637665418661289152644469262228843662994627324679587363835019371427864713980540382155134632237020715331348870831741465914924063594930209211220526103123906829413456967859585183934913823408842743124190991528708043328091329930789368671274139228900330699958759218152976124824091169515877899640903525773459382482320530555672380950222667904396142318529919891810655544124772045085102100715223523427925312669301082706339423217625700763231391593497099469332410139087791616512268044148097656189797350431513960669132583790337486208366954750832803187867077511775256639634792592197335779495554986552141933981702686399873883470102552620523123172152540625716367712700107609122815283265089843595689759610383721577268311707345522501941217015413187936518185020208773269061335921820007623272695032838273912438281981708711681089511878967467070733778695925655427133400523267060400043488434329027603604980278621607494696549892104744439278719345367017986739208038456337233119838558626380085163455971944419943446247611238446176157362420159350785208256006041015568898995017325543372980735616998611019084720966007083202805699170425901038769286583365577287586842504926903709342620280223998618034002113207421986429173836791762328264446457563303365567773748086441099691418277742534170109884358531893391759345115740238472929090154685591637926961968410006765983997449720472878818312002333832980305678654808714764645128242644782166442666167320960125647945148271256713266970673671446177956437523917429285039870225837340698523091904649672602434112703456111141498357839017934997137909136967064976371272484666132799082543054492955285949327938183416078270913266808656559211027337467001325834287152408356615221655749984312362782871066494015646701419437138238634547296069786933359731095371264994162826564637084905801515382053383265112895049385664687529211359322202656818564182608275387900024079158926460284908949222999661674377313477761341509652624483327093438984120569261451088578122491396169125342029181398986839013357958576244351940089439551805547465540000517662402028259448288338118863817495942848920135200909510078649418682560092739776675856425983785874977766695633501707485790272487013702642032839657563480108183561823721770822364231865915958836694873224117265044872683923284530109916775183768315998212632371238543573126812024451754018521326637405388029012497281808950215531006735981844304291052884593230647255904423559605519788393259303395729346630551604309237856772292935372084166931345752840118737468546916206489911647269094289829710656068018058078436004618662235628745913851859044162506632222495614487244138138497637971026760208455318241119639279410696194654264800067617276181156300636443211162248373791056236113588363345501022861705178904405704195778598333484633179219044946529230214692597565663899658937477287513933771055698024557574361905017724662145875923744186575300649980566883769642298255011950658378431252321353093712352439691496623101103282435700657814876772991609411539540633627524237129355499267134850315782388995675452879155784204831057493300601979582077395585228073070489509362355507698378819263571417793387502163443910141875767119389144162771096028594158097199134293132951459243736364564730350373745385034892861131416380947523017450887848856457412750033533034161380965600431058605483557739466250332300343415878146346021692350792161110131489482818953910289168163287093097131841398154276788180676286509780857182621170031400033773015815363341490932370347036375133545376345210503709954529420552320788174493709376770560093063536455109134816273782049856570556087842119640399723445564586076895155696868993848964391952252323097033010372772277108705649129661210614940727824420334140574414464599682369661188784116562903551178399440709617725671649197901681952345238074462998776648248737533130181427639105192346850819790017965199070504908652374428416527766114253515386651627813160909648028012344933724278669308948279134654439319652541548294945778757585994820991818245224493120777682508307682823350015970404191995605097053646964731424484538258881126027539095488526397086523390529418296918023571205453282318092703564917433719320806287313035896405708737799678451747405153174013848780828810060463889367116404777559854812639075047472950126094199903737212462016770305177903529527931687663050998374418598034988212393409198050551038215398276772913731380067153392401269545863764220650978108529076390797278413017645532475270737887640693664200121947457023582954813657818098679440202202808226379570067553935758080863189320758644442066446916493344676981808117165686652133896861735924509208014653125297779661371986959164518694323242464044016723819780207283944182645021831314833660193848919723178171543721921039466384737156302267018013435159304428538489418256788707212385205972638592249347636231221881137063075069182601096890692514171425142181534915321290777237485066354891708928507602343517682183550088296474106558148820492395337022705367056307503174997881870099892510201780156010422778362836443237297799299351609258845157720552328969783331264276712910939931037734259105923032776526676418748424410765644477670977903923249584163485277351719810646738371427429744689923204069325060628344689375430167878153206160090576934049061461766070943801109154432619290007452098959592011594123241022748454826054043618718363302689928586235821456438796952102352666733724344230915771832775658002119282703910423919664269111553335945696857828170203254955525288754644660746202947661160044355516047350442921279163587484735015902155221203882811680214138658651684645699648100156337412550984797301386562754601612792463597836614801638716027944054827101962907745436280926125675071817736417497632544367735036325800040429199069631173977878750815602273688249670776355598692849016287686996280537901818481488108339469000163807910759607455046889126867928123911488800367207297308013544313253477130941867171786075229813735391267728125939582205242899913716906856504215750567299912741771492796088315023586978161908949084877177225038608726183849479397574406649127605188781242336831254672783315131867589156683006792102159473368585912013953603016781104134444110309033887615204882969091046891676715553733466225455759752026247712427962259832784058335858976714742057240474397202328959037261486883880031741464902038435903585279931238710428459816089961019456916469838377182672646852648691729484141530046040042995850351641018990275293668674318349554474581241401907546816077709779205793838953781921288474099295370405469622265472788072486855080465710431238548733516530705707845842433355509582219128627972054554662670991319023703117796908927866231126613376711785129430593232816058265356238481641921447325437310020627384668123516910163592525882568064389463898808727352844064622081495138622752399389387349050826254724177817025820441298537604998278990200834983873629924981257423545684390230122617336658205467856711479730650770354756205674283001874730191973108811575167770050714320127263546019124608004516081086418355396699469369473222716707489728504641953929664347252547243576591929699490616701890614336169070561482809803632434541282299682759802266940456421813286245175496521472216208398245945766133427105649571935644315617745008283769357009954195418390291510331879339076142074670288679685949854397894573007689398900700739246974618128557646622654129132040522790712128206537750582800408971634671637090249067747363091369040026156464321595609108510924451624544201414426416601813859900174174082442453786101584333617772925806111591920084140918881912088582076270114836717607490469809144430572622111045833007893316981916039171506227929862827094462759150096832263450737254513668581724834984700808401638682097263713452054398022778663372932908299140106455897616974559784092114091676840202693702292317433344999869018415108889931651250900011637191149948520248215863962162949817530946230476048323993793910021425329964762351635690094450860580912024599046121186233182786144647277955232186359165518830579306577033314985100683571356243418818844057800288440181290313786537948696146304677269145529536901541670258380324778422724179945136535822609716525883567121335195468383353498015032693597981674632318476283063405883247312289512579442676398779467131210427633808726957386093146315391485487925140288850251897880760238389956156848503919958550292560541767676631453540584962967967813494201160033258744314387462483138502149804016819407956872192684626172874034809679319499656042991902818105976032632517464050164546062667655290106398687036682632990505777062663978684535843840576732982681634486467074399909175040188923192675575183540549560177329071272191345775249057715127733584233140083560809269622988941630472877800547437984985455628707299684073829372186238317665247160909671920072376588942261865504875526145578558987730087032347264183848310403948187436162244552861632876285411759464604970277244907992751464457929825498022586010017724378401677231668020041625472441794155478105541780367735533544670303264696194475608128319330956796855827719320312059416166939020496653521896728226719726400294933073847175447537619370178829763824872333618134994145416947365492548406337936743615410815934649604316035443547377288023610477431153307851599029777714996102746277697596124888794486098633494228528476513102779262797439819576175055913009933773682405109025837593451700153405222661440772370508900444966132958595360205560340094928209438629946188347909328941610988565949542131143356088102394237060871080264659132035601218759337916396664372828367523283916888653737513357948598601075693748896456571872925404485086244499478162738425172293439601372124062867836366758453319047439547406640152608719409157439552827739043038687727282620656631293874598753177499737992930432943717638018562800611416195639424143122543970991635651028483157654270379068371757648702300523881974987466368562926550582228877132217814404895380996810721430123946935309315240540812157054022744145218765419014283867442600118890417245705374707555505816328316872471102203537271661123048573404608792725016947010678311789270955272532221252243616733433663847565909497282218094186840742383515678688934211482039058242243242646436302014417879820221162484716574682911463154075637702227401358411090760784647800701827663362279781045463311312940448335701348695851652674595151876800333955224105481817678677721527982702501171958165776035497329237247320678536902575362339712168843908788792621882023055299371323971943330835362312488703864161943615065295512673342071985022597714086381220159808943635618085970100800816225574550391013219819790455200496185837777210480466355338066165170235950971332036315789456444878009456203697849734599020046068865727018658677578427585306457066171271949673710839506032675015324359090294915169737381108979347822976841001176579870981857251313722677497066092504818768355160037146386859189130117368052187432654260637007105953644250627604582523368805525211815664175534306811815482678441693152844084610875882143176416498356631275187281829486556585242068522218307553061183933269341644594153426517786533979805808281588063007499528975582046866125908536787386033184429055106897786984177356031181116775638725899115168032365470029879896289861810145964713079161443695646909095187885743988217305838849808095230775693588516160277195214889983586323231273089098615607773860069840352678267853872159209362558178898134162474864564332110431948214212997931881046363995414965394415013838687483848702246818293918603195986679623634893092830878407124004310227061375913680565188613134583079907050036075883272488678793240933800718641528533179435350734018911936385467300006604537837844724692888305469790001312489521004469490320588382949236139192843052491678330129801922551570503785218105529616236375236479626857516600665393641422730630016486526138918422435017974559936167940633035221118290715975388218397775528129815385701687022026202746786479166440307290184454979563998448368078519970882014077691992616749911483298218543827189462821653870648585886462216114103435703428788629790834188716062144300145332750297151046731560210000438695105837737797660034608876248616409386452521779352899475784962552439255986205214090523462508478304870464926883132894705538913572907069675995562985866695597216865060520728013421043557627791840217976266564845802615914071734770090394751680177099001293911378812485342559493128666534650337288463906499684606447419075243133239034049081952330443895590605478549546202632566768132624359250202495162756070809004364604214970256914885552650228103277621158422824332695286291376626754819935461181439133675797001412558701433194347640357253769143888996830882628446164255750340014289825576203863643841379065196129177773541836946762329829049812617176761915542925704384322399184822617443504701991712582146876831726460789596905699813532644359739651734733194847987580641379268854135525232757204573294772157068500169500469597583893735275386226649434564370716105115216171762375980509005532321548960628177943022686405795558457306005983764827033398594200985823514001795071045690191913590623041023367980809072401963126752689163621363510326480772329149508591512658121438233710729491480884723552863941959934556841563445779517270333742381299032601981605719711839506627582203218371360597180259408706155347131044822727168483955241059136059198124449784581108545112316681735348382537248253476367775817128672058651482853172735690698399351107634320913197803140316588973796283011784098064101750165110729329078321774875662893106503838060933728413992267333847782033020207005171889417064651462383667206327426443366121740117669149192355709056448030163422943018376552631084501725103075409426044096870662880662659005690824514076325991581644993614551724520570204430937223055502172222997062097492686097627874096264487720560430786348088857091434647932415362143031999656956107535704172072853342501713255588181132955040952178301394652164365942629607685705856985071571513172629289600725876015648405560886131654118359586287106654962825995351271932446357910465543891651509541873060710150344306095823022574559749442750676309263225299663382193952029279179732470945596910164029836830804263099104815675036235096549243025895752735214124451495424629722585101207078021101881067223479725793306531877134384667138075463834716354288549576109428418986017946587214444951988015508040425064521914849899204000073106723699446552460209087678823000643377256573850109698990581912909570798666994537650804079178524382220410705992788892677457520842875263779867303605612307107239225815047813791727312612348783340344738335736019732359466042737046352013271825924109060400976385858577169584195631095777485295798368447568031218748182028339418870763117316152898117564297113341814972180780404650776572044570828594174751149261793673799992201817893994333377311469119707378610419639864221660455889656832067013375057450388721113324367398402841886391476334916951140325834758415141703256901617849314557069041698580502177984976370147589148105432058549141006622017217197268789300121012674812702359408551626016894251114584996583155896604600915257978816703846259053832569205204257913789488275796032788775354668614418268277976512589535637614859944850497066384062661219571419110632460617741805772123816598724724322529690985336284407990300075945462815492355060864815579289619696170607152015898252997728035200026108888141765066362169059280215164291984840774461436178914151915179765378482826870187500303"

	e40: STRING = "235385266837019985.407899910749034804508871617254555467236651251189289163525816954336733998704767555618400768777381029584872497811502565300173963667931584290403822395982866289461756635517583644477759110319580837268257339707087701825997629174524209545944351635848608599270822247348216523065397979859913661222455683857726384571944242036739317191497857736052841664100188426970067507625646451769383175409075563466489206468023405272558360693109058912162782809690434782937237710590108745611818828573857166818874634644321432372768300190130276170594695956357346911870290046405854368780611582073929041221836570373640082277128159567161550209432947985794499869642155370538908040248620080914282466748986998206100754046541848406008813410342582305135846154386295587981208740967912483794451982632543997343476973569567934195435068909927346512346763302314612737925863453809517615626869037125427847757849833111207044937980138906743187879675728093231897281394173801735549889451341626241982952196727878156613266713070671493846992664104006428164377662240775330882712051694397941440454404321141823465824432204801988700779489902599968418498728411195357615226500321290189477225480557893795483668996332233666130108414933704580608852995607985333655210265278370575120960300852221484908898440542710202797408083563777336314962350561305454076988458363187736531562363546532649406684704510212066365656839777255194227674059764553353580414672022545032361786024898261423096954440659599516468709077059082370276834280098302098696496517687379171163517314733565654292012637067569572419820959562300903919106225263040539896643630889932695581700625845735280682987272213256499849814372534947501447696333185524136518811540766346414093735967984871916932375692447961475972549292426248667683883834677929340650785300637127406968427764327996136057511353560894604748831100216402602504966810543610999685059068621761665601643434332764220228769857105325343458871642459861982261477101158909288222449117655541516129094939308539126037053322761746832462586807215426010644706899063805880403886666414994326781884189523129854409358461316978791324028669298967158736022880116185765954982609987282455713754109847804495652753382852720344876973256598874693801271336094507355020046006371867892818754699527508268751277675602938228827113974402057305036105283908873947588018576134692225882114784705077489228255655878912363126695137296220054248948416135042553698341209082842439870169751259694209285030646960456622553997359624676938225440038433984128422545329150322299337432327286427929567578545520235321076052117280006934825315769448734894688700407466869038055166455899800863715194805031315383414537634443251074542233747989608177955297382638041446527460454030521925219729792165343438169006719777408059113090415399719702747759316738619778969899779847917554441344988539746367241403047581220604507315533952967665010510335823890108555856558172595472194796243911009348156243888833238345189788449117777108371643617164935174401303710674027077447533320187935329753133361895287898839309656110862747555537782205676071280117321846327136031540313932591187269042306494412808004344364047814041580820672548100524096728070966612671447950201546753936830786000634941297744453117041672639711208806654297729640552334452633231949145206103935343994436159257746231676916181927342343871692525414479334122769007379931184550097261167302779144221124388434092702473636383828530192899479938787629267929799018129726723668933634099028992222659835224955537452004478497302076051879423673138758821825019098258329965997288019159987263052348595218911520170180728758882619900137220773563247980454330185166348471823963516343038106033001430039323415636022828515342928960936883358005821201609092721359319955939650079790950764799013179689229764174037775728431755315649372865552596534954813462744544816916645719937930096385378734691584600753427769261952143689072650193722428451411017263972333018735009228738786849828092858723516875316239514843015274486483013701465813593247524682677334319889936576707927422795480642543198326505407965059149618105608204376401016779180992653767988048320227974597184405825861088002079037605531953322450666805373550350754376247813371002808152121508775823778260856015092276215117526341435407545851832150503356221822460321971598927266423818628808655423942629056668464251962964884188768927866286264870078185606530090041920504731540226317337671241935933156645507016403697783751403349784029391558283635391407473967989828686385158898058307029009894627047568002588003702604854325234197857471388646963512018961986954770550361061559084508520967108788530662170689128670214105456785924605935571397485145223933521253850881443398878752584762126765362576103286922363767337661473577710157812666933970617629489118540768917000798068229939110287451987223859798466281025742003194266009863908028767785032895600668892242427632618595160723745603254265956128561754819793548848871486099725538572935407337248658821687211638964150925654471504641632738683734969474527606400693202430008175253373915431622383727129777510291340075995644338375790050963275860243616662635079062247606032218113334311315116260120093969401614980217257644199954868540139748920899382497818837665260694865458349529575159684134334558820355469883856779524688531482254296106113307850881667509347005945351228901927602264696667725788184850585778834533905820279668938975754670585151969201647195109726718759153374135052536777677410428455936508553150778469686146260906576782406641691229994052772783140037389848126855555664385028277451032594317484203820759244024199741211930090443677629019915024758800744829667388777503429624970070873555593693145788672110380097010979775606164951982389246410783211051423521205938224447763548557864452710640919076456289720229677382215602286717086568071386491018722244118251576511822613381485802223122515482113818023843587694425375218170971840317641003169549195069295024463237393765513643377102947266581854072024651138821263157202389826721568342654363974149514934262413392076761680844606709517764036177599818985245044766487019812379562140707467954829325657578465169591653769091676880861423576404552813488095135562109354907000128767997900898033187815322985675022198389389747401632844702128406042964141785199577381990418903105084196015380072752372914188419482050781959190255088226941117936215899776140054993615055606791466535730541859881709896333302991785569177964096162639579430605178663267509366357837899326363797324568489198461464116776616782018214870979277209236528407106458071351750422224529615669949045062695442071020758734852455884156786160224738808260793677589809084206639664052603291253364478226102886230115342986587988587336952249779835108044214736470046192755785336705526216913431576008911489107386441434150772284776943768274004256108507784669064622160779654160087770100763588812274739512922908001704583360724759530182714938234202728193017472332648620879477411882333567516776700974762189716113617368651045099164813721998595359878746992702802208470804392817303012469415631766683076595126305970078275157293274072195096197283825947475650444236163413520190849890055797974704489717311245297176306611481230348493689852068008639325753493645073487318903764497648214755466284815743704842890448610013657466833830459051515856854791698592928158331696806028234309574002682903285092622756713981022784908621048819725470705479864910072921745946101281723351842593839749427513300015007593883004115393350540815336227435347989786052557109690980480706752298893018597218230768760721346612259990495493975655107438547690488937857872666651491243967736620734296370640479840473795977267173241841991629691495564428904008186088992497896543947817135322324309147882965663585799453524214599034642025981896607912688687699954754055196388672493257158705166505962079060485366497905705526297615562996415379500000495548199470358238806361785718213281274953728390025872103803011669137497029923306591660651750731045853598504933163885973578253840214761985216066369075758199479484322763148869219512258094628803929639751395599237994680074531410086800286581418217022291640647415748462794164539865809281014876684217559836603222864388591766558757493998876576920937003518653259411376579686466257468810052308484147686153793537157495475464688209817213608491114380235696305882562023602604040788997247182626995158550649766105150547078840807343803254080781494861148947262920129247407833253003497754820813229518219213129208627746171638107863595967929373415869063465708392423493864978526291811385709387964852053734245478181449505299281407171685780601579893477397534543209695283637044251180881147422583671817180215965177438227517464513144887111949427695914027063212436830007644150494789522057071948397567789644680532539220897616144523251895054709403053164727349947894589478088304274382621230061909914899732791424425954770717292459621222719468860559110454931725631239350472670286268190780571626949300729103850214105803715445034630041831453074310760814094219254556977012842065120085932362487621902201620651847198885156165602586488332183251927066246124197973923566590170086038943589706449515725997747117967055125073697516850677125589119423932161158407701059380447053985731454511607447983585138690753161194298826153131133722199426534578694981147805949392617676526523470335383025080539349316343472328109126492333043907986075318705521017743987278523177093895950183310477848366912850740813824046859281292181131204651009203339912666998395405390467994814587748387823317998187477857010600906428670606760897781149473116126762667103150407879441083495596935320262952929398280868806104738908180519839798561993214177563011034587268661682306350031850269246611933473588883286278507541426343272925073523180514503196969139333446836730701894178994228222120076934901875998962482291261360572988311922605939764059280803816521534570429423194461321827373397330224653488081715758548422984202897367297222571805797118480380163561314959229172425027265609431981134951390614721601556360727816483868820390504519586624725366124577059093571854625324943567230415417961136813963375544794650482561532841074145078264848986683572656373572007439910739863776237242145703052212527727005675202321136574604403105349471019462446205665389613565544059941605619846805910499063456966797507170827650414179441393403400992027849983052669725300595761034506217867516979917038341125507425179142449885047584142690458335600625610599294886617088635137059883308230240634734440176075656075768985835156412882511882770668303816110414067950308306255379451722662905922055294136476227730419881800965243657474266491241248105654985707986290444932825587693244603541853090125375284505523111686402753939259243830234566484312031444075423383634291341740694876337643210134674225126524117220557444271206104413323086310513876591134686485399172513268129332178727342863617242268322293458281010039579913192251925577375823041561431255964635467210997225678730997034248823487913977289950634149626553332303018692577632832250233008483938945802644203205542456043173879963891497231202879836599072253044394844470114386769371515985091300296312197226672997473424652244089714642938858295432457649792888361144968529193825888279763697895255092175097517360040317963048112121470857863338687074847681075216122683113386199906349303185256808384390373217398511938627752171010489844399858455633185489478114825852179950348590761121102239856717096737163234472878452026209609706127031571880985056735501410079200389595151396842033176048755682632194270459431246390953560857299212725043480035123414529450101681604154134077125830837990817008180680120864231870377326160077591630825635993811106776163802429313353106919216905893483602578218611868244369628524710622880129368752752811112131629388339052245578626609035893473950735045382861614336089802515828774107937611981155832775696460884444799246342508985122356651705775504201192071443109957215169803776975399716767226802379108297863815573144151760540560905721447754208571238445685408135998552968002145720927936501233805096302492508519860335760854017060041922403887773895070555641399048216138957878809128162928080950445387034517589416822193179294433686729455909488118495908830422012778027146359938019856739307124949307788214495964585378225254000844673044699248358269446871552127517883090145267830159721204225408637191597145808026777157412672491522619603613114199768509097474099019289486268517224099406170181197796259547447773008533341379008670636268318732453504845204534857493311855662155870904591557016486327033906829394682447047100833930146159092381159602654295143239808452734492500011440800070272461420460528177024238997413394847770703967469560361909384842472126053275512315150901836439302869687412791150600554471203974997978451592347600928752588164965817280493212341562779111167837339915629104071584501000774892696356070626519907261331622360193378602474004418921604737224204003068155588991006671136326771023107845497423776595591359995871673456160090034741466741295658356359922555116087499771192337945537342601543651143228904444103280976058719279873602969153208111480865541257042839196073112844440482039838484702749189124014261566660307881112261453521236361854582312855249169288912426678507405965254537542196905919393116357420499905134944465603541079278738529003830028792759750324218331187287385393550692681898877721079431458952594559549683153004189960748123630657910959730784409240509259646199216500397985018159101648383540133379524151836531650950332675270566687871547606311336148252502598210852191227605518914505468936060683206745289174264193567177786704174245622643669776593196610238155199595748921677432042214927628747781599645149178311908458172677447350926835298003560107556721309845325741826352086795462242451898284237343973642904690239442409988782525350671910778190761908825999728851716834597620725663741542818265289716397916341396829180558685977186607344635530403555210995167581492607829152688507579045765795616667225033581450883513623860685467496461525748874139317720777505456005393003812449227191382477102793149368870873279458268706708232075389460320353009405960063649158654009083514197378808983431517119205752681537315497280823918651938156972912037619393934097949367287498394963620795815672349598736041613481952434706938058040486630382452851158006579014493333270737126437527681465462098317086820047581372937098244843556654112726995163645115361490335720792067810723998944314760171134474445410387074172906980685825310030172270076542795365066263773475052516200429852295291400705543893910568076540350180537982547729375024445211476029464729547449375489547485464909850762556364413888560792819751953892310302248347859300437244708698362509752508710210112515049406698834145429297517387262226111186221788322984259157948850586185119829116283838691166136236229801889546252377138050151542668822406583934874027137725323068178718194017158331107869018071354691922045416839580780561872140141047448447973903384434099336011598294171530185080213035099865850704752285247808472193635802731139895873422253547673799520938952365642326507273532427165066699237885825535279032378935759594909391275389264386083720998992620790735646630003087349243038968458872453952908046152861626702843653977159433198504593982733502194156439238255031739208746527213939784150033393443113688858068632893295279568577116958933936473090895016470375475935713790590364263569011539656952461903337488554090574830603061974827817435019301016892204512003324977193483936553836541512320033720260465584395953534569302108751665022744258475593615449934416199597575761873253440753288229659235409322740962682903557049091872962383744938454659412141443017635506197955714482879205674011011120592328226013886580331301075433079664174271884673203948205353217115884478735111899614218636213718309237969898828147599944665685322198548619744867354823695446133769934170822361423826364586287442368087143032462420422921407817790482362618068797367393926616808667145630030511282806641001179658535795977507854621024140339464454760125839627702595327732372164690073392139486086376166833335508851945909251163102716570366694728906058748962659310780623841559846338438384289893349635828746864309291126169420899872502187891572420201939418698615921639690662045443586480853930102268629151733297919334352061579017049623648159763109646981223070994749464910166472313438822588186959949040513955389391142236678597569584979954277298536361661688194818926879536409456472552555816701815778738209510539527819207954223028426938525025829083646069001818388341626195039635529668689657030234407646011561069847586366575515134758183824838993675488979832862164034639646538341972115282757677518185083084406169406283789599953928609558210635290656759200494480279094415730196263509289145602915933533515007906987636878885304244157181724701386745440054679897257192627867529028447881911204854652356027826693797907198088242252774830349971318029740601981990524045675327169233607572126913399818578601734763942464530250816750048113198462484884974858734036017319158653582585636649446757909745713798132081505429118226518036379318211590415537894657177316966688419230165507910486034006195017680225943675236131633968852810568075094762054953255521881665767807180133001993473851235068798839254005126033057771405733516264879374200359859878355599856669868192191750250528213706575001772233752527785574396672878815933459656067790706180527286827080106297929412119320772916652751295133586357747158236043828069830156157785257597925336983598972618504535803449360501245411253196931432662117409515891766416016010699531556278063230158657219150722108142271431983512015203582724725219819395894579749509699568366652502466773630564765009788999682895182126713628573642032546224876030134244154159541905714349714347220334228799215133588284863642247285110781886714585015334188560472334044307466268181894568829130594591339651095646203196728577106455357262545043830629268033877833051389720966423338984836104424998415540561063042540630710263680681370463262978201232682906431487087055413029345433853209115678704212974134785065113905920106609791339045315661680372534170547597517505163581710055933541575089111838795134010571616830252376880336987077251369743098564029858352336425822427668844505433641652850964576820446710703769456036270174296198158388454402776573217860624862301269905309758908475864764348751459825646717612300284065821147625750653441620764223872523692183704937754541380196460085130337739913460087165534522997543958243042341171491634935483669356306485057697651390399130605540716596026325709294762677830554803543783659922908279790558110436701901426409174106224683047776426300838799198116889213509414760819103579070983377578937852649031449300643355471426634351642775917487035280749124442444864040911289191292699016133433565929590953822660816064266909290189858301139789571817439760171508306196506593346096749272651353482702345921326484993587598622115842004924198718721213778061694685991104521596491868310166603913584603285862899573715555621025780034274666912042781011950053718200466574244818792119030390933881645120194745424702258180188592385386483471123803067420477661497931019943913565575560957953348779849572763671872697110352728688272706861465567300236113998304446835964383156963980907051350831583274688063530010570751732038498162830927763485371840328648634819957322193243684155804478927393516833396173132452290198039246567512281117794220221089898423869702194038949083596268400792208270567154623841230200214788150159821820872695509156677347940150348774198936640417348923284936060633751320891385879701896546648039735687573980134847233604627384762244159692845832249835969245667382506451109329427177650870838378091694842715098684346871380519535909565124408748499165624760780268177809698546214476807340406855445377357173573136031450517178683188159438745413027675337897311385652308251546605584194536026755417269032093291860604907430255860240762380823521737775163388369930441676710861564860899492805407620104929480381553642423237651641820852846887993127644171759283606668444262202588269272339373052277316619320034906759074679720080087670795947140053458438865818897344794423742690277367059873207993647323755378420685934227297764535063626582356047496776776800922362091926637605231684537854239771351884448099825139101754528115478805507798573460569294413828646476169231986390616278030812478206579115212112296657513041863333581838317564086104507194273246075897647002416069837511279999374573673855030083552681089560551952790456594963065149439574921167475502502524263783566134088658909396571111512193576987076532954235288507350336547238086848675853014930779703207106734619551260938495585282876412454528029259332440625187736369658332090426071485284272559589471054539499609487051776094427393012190974760309677763321784661570769947635553327811846194296135146349316293557867920257316551119193442930448445287650301693582608222505535314434597382147096985720097975862168378317001331009560195038350697224917698862776773578308416505062081771309673945017293687248760076440732328425256361214312358272407894174150379024557576565578097292194292295762679315517287161125993428917777113646282751168906351156830726551711240925978605920314370981907392994682215665481526373170813832974375435922967967158042184608380573755588075848378873854714004699071184447550006447549937844815576008111865913984880452464772502334687864199611251787940155638266497452804273383475322640121469556534502300446829275632701001954277888069291023306361541345501837832377601499815752898832499556727472598940886844156048357744700844533656236558859999473042984214368011631397029050670261272137688474819177746939022289050186822136056628267477413896249664175303472474298369184746960711770914422924078151561123805722509931618614992576221736227027870793639276797358890036601355625871046219252919508082358348580268227684823185492655054321884856684508354300449131660012242914441505719080506928691217713453999834226510412916142188916451920643793374531987727035185951664394071617694853591491497508091444805413561682373989441421862352069659467665888821944601816703407568816354527438299197533166454659008617489433286967725884574775313253445687066026992706307755273899611189946505773845517141897962529610471588274043687462070226694937781253345530901562126651776432067807370014909914721855510518085030261768986325663308531462053721130669688005459856541271827733298286077018048663781159958492227421554456112316628062606873450121638806952227063557111285344131569209807229111345161386021826851231353486598815527498676784096943633412746880450442860395389764107036491986764423961915641406654300483417260200888992427228637948014293053972266274935745451409775575297860848643540257900996493048200655094110806924744656795990696359352427116566412087396815524079734802661384881737153370757306445419129071135920082776850411356922715640839716999100099057092430018969308708944931796595652677799905868916356844479373820690449380311517170845595881364613724621240380509609944320689995898902003012195968925546641037869362821282672352524965385676969251995232860133196771131935599718781530932448417197004828498519401137895832680679855498165174616802534378222590201890781902676833515985214829705046794390826767292839137594172461398492187931281304264483145954715042000379743576939784818208917382674362902879102799247165724057889639876654822594541382311700307806405619734131544091422606776863859586684932901802427271103987316314972858560514302923887075469915991668207124560561581110711483578132278076664698168163608085101976372534495391958688727310849012067606298880612814159540718550823162199146652324106141757941802738052940649300235472481955719926174600056355271548628085917819391379858627482135520548919482648483492395299832948044973828457805379624735447611100132029842525064776275855946147766333732896369746959788030981073865913303559240568754899554870989201362425074174860173060353529759284146394836448324499776258835470624586254007400684075316295905582593680372755923804527750674301012815888354266752696546244373376346036249297861916733956196991231362171956825611889625612809786627665140743462691490311443586139253982854766643119937000906426518031068481330524674231486911466480452066093246924960375277342582654859813623378616637149706034459493917722178036030857796617407633924949698930797406842463665729927369254983788419014441478063349937087680414287306095001213392507908824893578805997657104950483333572078507515255849396896313356453435636476181063135387923433266560996064021918601682234829560398678561809012115507147644877518362485829273609078657633502734978794082578072862789754604775289357480295254359210732086650592712068684349140344397489937547647638604340575615421476347353955890762013266809575792254628185318412562507679261186972497366268059626518220859756983208825452322264431965589326290602641152652414444706050571016140240732116166875747245597377838535409923969203551237389742381058415481427440506664387219192401924275534031861837144902870435246268662079633170914844521831603425580306927894106356414145023897870882014295067473931765597332558024455070394835544022556652467879780859019896494544261934859762355702507602786932202261860457791031551569731511870286001590492590970106255053983677145348821013734606628396699327512372935737843719697159466824740965621082456792587513629033147067386246422638181926736272538675783554089337702034141932253338780227699806363416753875308736891086262199010872234440583631724689129592578090749579914021486341717902036394512278744329158702917365971960782966574502791196814184134471643493262740855420493064104182805954006030071060241470242491526160542077638842124933106539582232474030874505783410803255665400810065516437729579479760535760978913558753069037552206485198183643579251868636526709183793949978089948137558867262140120408510157140752668319137482151968964645780256974508961749348631955092648481872288245608134515100738667200500787343080346015125283902233704925200809822064014007301628691199766153642757178665563640203323561833248205031363872668154097367332935985286869483998908842716671233366561797828684043438839805654662441928429176124799128988963920925775099044300929679899907616676735550921823228705916087159404627551698418099457056032835456260229554970477136519427740208154126980487300830537142392861017311549149516970625401416909915643042164385198729543169140435690036486388064552319028316697131688801687656008812399421171708056593304089350858458235961416929888987718774285818819086701332065987492465357024770310092442881690781791659587437334222122749841592662246352624184774662853889005441829442844398143178736855174291866494715702032754863204215731432830574667096427472625558865479306696869299027757150844038198966821108301563458754705935002734311898184652507805285268580818407824497639206890112939239594850236011348987013579195519198802848581853852165863553936789136381237758860058338328175171052742484521721065960697828098312899313185229853544983967873035875944752887844631842993716518703213606244471200968955652785840847863708958491535562064809796971733896131016851027880491037084547173289595633228936436957957060048660354512611851690289033300340532391240833620250937367532101214451579103419559429203884088176520928799707652060985419511855832049475235568521526858201902280945773378690745212297827787372231932948668197388981971602705745848184088022134457089233329360203093695409671615680226054198935895727069002056711456051664294640432548364850312067825837453178566702768982430226614448610146994064193602015279008875779175453805461184783854835446603763991643021822450137708252945866367090262550995626874549477097111375599332996466408956566216531559677746423294742099920810361772437741826741777953367401929191251147960985001381268086635174423056008470151798304109996726149676062351071198043421367130198871262691370845188043699192640865494563389088412585914208310356080779704909758950326509258759541473963996536121707377230443933196996139520594511299344417715091108120819784786724256673045727499356017583956228955192680879395284898023872998439880915603247336044286725265067285471008429254181966835193605253389649635103792146817839166623251639730370576907469336307831105323311661607743295706835368300092898930451750688075563427043548612474493938558966784372377706540616047719306071277583587770074269620291336092221235977345662450325855621124891524273915220557443913295766152325330731874852697954731857500733623664534628505188682266234987048308396357323205315316064996643360669758771850337216293303420154216738708887105545829832609262435041683506616270519594247996018487948823472955566443302618441849385786122000676357360344808275348990341010850908787980822329217315605533424852828999516209164902409134254696249935648590311089010140932450907905652907821165311279120398283440598996588936881894850361538623132312716815952044015931715636648514641812737819318209453847787642816874914944673405092708462904780845530320519642300629351985754441522397980463405891689292778738732608693349363426388002216026507251857143327189715468254764646301225226360622545612511667302028886700232272132560954446903299459443909222741088464660816568373631766371314007687827036094122227599426069480217172991028287717723171439124354544452450728713045612758530940414464984420383456571319897417487613950152981197164726895882098632748117788094619255033530122155937062807271117129855899982770081642326272851007518194561825792983039516061959143653059025368332567300708590949252617294491888847057569378563497230529510773538171550697686572641905698403902947274235207872255391749755101440783941433681078741755220576665440126017138597939917387584783750994835449236998037363820747836751415301211130147285345283636000314832368464197711503276227870200338091903191724010648896250565295278453559516566717417757512852209094494537722923626994068014752175973174406343324908833238507046449737114862637501517174766477826717891103229392165071788753805581625799971464927515750117546049705357409363423665877884663742351351016664571000592459245679990782998506766014622454771623203814734576306629529579313392175692806349320955829806253655546306064674785045834077025859899715148645678176593639487267560019571200194295125728574942500773092130887247317298049391784891928920766922184832674974983379897961276005099047823037493879408"
  
	e10: STRING = "22026.4657948067165169579006452842443663535126185567810742354263552252028185707925751991209681645258954515555010924578366524232916065228951662224801377289728734855778378472751954806100958814170558886579273172361684011926980351702649250411017575025567647626961075438179319608340444049342366824553576149468286190424314651323895560313192292627681016044951975037741672048065260563212034788487984428025303007369135012700544838328520342210814386196169653196601451049830818993785087795491545253019918906056352126211501546927069353601228055579025752207093837393591648098361813489352167192947526780338928170667946028601807794076958318914898240228298296676400351749532780926028455646411302203285127633144305683002321251064733971746553869086738704067939593824690354224844270025688130875361905012463687230315467388986754831213952177065957206538795525383963775549618632853597931691370562958994830583475461677691513004996893815880617830545147948135298462341990296370716383440998248973078024256189043730765905808805040354519171331504115177739391958346683683404470692382615458660385369611650309726041881670326740039486831183759978230908839927541620726838323235189506391111173147673241830307231300992544355092252822437896417511329367399411508357826571327877244715156391599627854060881303647107564622092302417932851106353732212299138618778376916769729559431394565356328530496186625213141459987052876019885875123313944845359651657487114553456747862111440520260390786944814517837481725947473530284315668690939669953709946920553428637292466191928483937971719270365048495785476465324043088686110110474430970934164167646938053210539295688397800284435063104888508809530215413321087336212939504273043403352529503760082260687541473035525440680785559837739572632939530166700250220889897776123046468301220729172126405190472320904298215219890514719180958083085665912801317673115096355549993627250110013337742007394192395894900612671490977258927353782287546235216452924032280615002603965533809796456829795592582914366703928522278742724147112085928344889488771877604575467836723588638261629718308882206236818012749188690297413131851819703536974192863073260798736906192362946484852374611328044148278513945210556100185890505562214464458744513324145541453649016003755424738782916228019496735030573826552256420074903202229780520484656731128607207847900381223113850108607508585110774974159587917935672269624619870940257394917637454361049413488965305416281182887632153055814311462804707989503430434579681236357530491579205286281469492711531327030159542604331955707965126928827628857434133326024763680441978029522399097962695445774373621837538324687603668404167385178124639322582395720731783394390355219740169283946377304386958563106594751994692435588824009871755499299261718939506326030328017536277129521403736989538619595578188629301279415841678052200302063520882441638736688934169915850451329998352798019667678569386584468446539587970975877722105946183116577265283902694817865451933195306135083048328340613859436518111269645239524899555324575596240817621744629716719542763356776150921212931717424122945947622038879878280068048779373779032543828386298227650322514046394970355423736802114934336476605920033405041363877533277829683481843449525818150026711858244743697710502409166985824438281185940349045799982970159097643425402827420765600474697757766329897925023951525711817894660599316845187497375214254164036018212611748178082018574838972862753116718556555837550727350269958717209695182431895080763976926554688197902038659022870682742777913650379731089195637731983457499615919646570403425305067905098291443622352525514150817143789644277504540853539767836643452211904849165369622029793029467779702216670117349696635771134077618373189682296590367093366734357986064423320677375664029356252508485946651022790707343056059756952215598542060737423014172948193840361494142429552597516540460763017449368600859745980089277572998131635175215989003472502098683201337959815463278452450149690524952036101071595174916856906036059313484319548428442198451454226728857073036292757713635884486238955368368882935000528212605523748449630228035210655664211253147867009805583056779345941215258509418445006407789050990375898451925623893772057006154757952098137053337526433121743834949692406589409790222343213832788053246067589257833377165539915740124902544872587329007323747874712763113215597418298627562259304350412831660421534139468733136578734273657142390280777598513107716135384357923564780968318477475639133042536187591060167983341642542305547747080008045919901276854801433729052525094601476268910310478692609046467009360665085598865168693543602701543481941887885211441932025914728202088163321784438717572559550230791237036756120641237923173936700349095311959559737431299745480842403352145124669698432647912105536691996309809210947610683215378839439258289392346502066246552096975293448656280997321366057966964095537324730575116521392759754634055905328252354710161419835450446972183729047082660536400636330458393261504358159764687139868836493759408707638834390735339089486946795208196586200497861626706395405514159460000196295456779598468195783049797704868361651416727088298295606572479492191573158309476324656482591622587103739319499008609394420067019894329270096860510938763848865183811798408243798213374364667413551898542730426471457185359250961683128443916164327570941442649616514123230549269071741452396035299193108843576869515786591395021018697478257399618937366715107968129646124774122595281554748393514705398789939801783093915296659264817345315164696385494276260535969917933861521730054007623137466890990764136232562086984127595240715631474905438773030865885398728769409261841241518398027963058000176617352768351883287540694761954781776156330945507016681046607379691516062769669189782544816529258594753213341285748987769147073852754551484377360035216319724553761244978847731302938793102913112768510588208494816375190013017033782213698041328896515626387269157644144531871721063386038484954459760211881729598970806450930772045419766280694547261550401905111563264450416094733084829317620199718467434951423590857723179337632604764726405692828035697352938404254064603332405346467812322012597685920967239744809680498968743593120070578169314265597569864564236042637261893730117763448023570449322305048995393038538192494264407208759297783121251111952312669647329578099326534794088333683039682470346081022743825023645155728684194717002629980454697759868365149645145755850438486038797636558607731270848780263031683786408382189626998315686432418119672529132008993482478395970516805612706585898169043565442154308090344647153038621817425224903658200802971754359523164412866438721677816191987637138142762620925901559850896750022083845829789925311548220316229831761793441970734809880119863530422429463956168964659555370510280988832599202445062160800665554835483041073751113423451755492325826083598868665278195353999077096966152691783500440229765786939588258385359492472022188014516315769726241149685347496636156084086604423645196990678510628279117442110738135159430325578545706340978167657019640116718810591811480742347109817109793555197458528208095249655321608757851544293301695613386054381297902860936923369532189992957266590464050604776983927482304444586233913419989454006339704638891718052570512726547501944670019749228066309850521095270883533254696496241105646001868419088691846617888025028708307694200753736087051238010815535688979689202261815430148747856387740233936029647440402285833370075094202668821329170617922254115639249249283201880646719127856806574115100559298094630155534591790170737389015696459022967727028198094737740275374407672976616268998027675413852545710660253305440575808104765671016151085257768201252881164656094080600636239120083532363696499325371633697315311332549059231677194302088129897829987493396623288947429697303397198703095792341613016397704015800864128353251934692095133949884703842811395950352191629213699033017473235579213889678496843768895379285691554544985981912203969239639530159414180325771893467709540933928778325667394287392764509558012718489615006601143798897064894040315905531669792078797079167634382806671721291457033364114100370059430882927569399147893388163370963074683988219913606731018943290702113206041139603933411892840800069588056624509431564980482989989369209899347306008754183800475241843590607041785669381261644445089360776050422136401596233895297520806662326893809849382654603244075928934268159563419835033259646456830988873202734255410457031149568797443321126943079292436707083157183675798875067536008512840474291496361211865275967459138966602356293767378326800877522798787929027057891916363109675315105883590299905890092107752495092328850442492737442144771301682077436654032267703634827712612438913293425711586263638213329846411401121264695169290439017944134264397803150034025464867316866700585319794181449073788193017395068268303823199045902563900551925954593780367268822277550202670419138860109282371258302753736822165942266701808463976973447173778326658223581627347251049422546724227573049099086218523632743032976058791561285875583603377487228315392395309658174290548768206244087650641699776105643052473774325894984218573983612901929581143373624404210521197201752575480278504943031483272326166991496403275766176482868754733650952959431146283228745000648593379144332906701905575115429821963624559872451771334420184606169372664791460814706446011940739710166021156005792086017697757643817649572172139769107728215916249127142507117108006524079944568799496492827048684466966318775196869355294716004927734348191875795529077007892147784542829019469402690504535493437911553950007523680977476836087833211388793613292501383096160022443550827882545399977926525634019695839940751913840254299593576804500371414296344248847425896370532231966191875085931312861743423580593601366196245923641149284222326845311434156296915927566740889380643651759814538762380853512403415881341772881138941911179960576945256430101359430096557970091363336599387300390186248712376028449992590085688647635229942640849990681958470364584535143642133022889039269032702436396369305357090517728377074776812086751661911175733397214604880418151450139809254966218051341943347831881072667969072950988391040008903824403976664761673011263233340123016253413116196950575325378142325153953796817169525476041332083203108220215991003802873724625586230784455290594812011636356142875329625198285595245589151319274665012494048604156660643584076620666009171097930579075270714293278576259242606886950687322184206825000300373750167027863586057558230475753798156883832765556049311760210069361539314505795887314154385382084864101871734623347697137681598526702351931128509897773035245069566613388679476623731714555168848305312299463501185607437880705665962581412734403264645811893338975454537440974732414513362727227008862510606412781900103706719862306627051139824620256857624366014457490487468293951046249398985855050625798183731811571511599005517210324495835658777299539430034857652956557506627759799102735186698936933335364157629769120618100951418564533526162491348815345485403318256863440871436314290272182508837083087987480935588092160483905538015801928473279080626915774808011025346426575111057573016731035592252473132004330294151617715317051652425954900098020235492552366312869015966323047914649705663303389698579647883289678366819822227426105916419870003944986212251826937979296089735426494994935962063738223336964134827691051826380014803284309853171705650601780456318061625547333114484488715761601719833303786882946087076124680527027170705558201771790017978079591483773740554889331055688040107130485446454621007732261260761406228604982339146670524734680862209342954223433220866449850453259072509752642973927741416793876193193003837058688481986051976829829957513948522371980023023402506211532167445330588015967456397279183327541453230800108582449201040646381279668649976206429906075232747869290631557776573811593439213221693562179896266644638531658196714041211895633497693275904235772205528413629643627569394569889941381291992369122902071285434776389117807103978362553024960640442453009352258431742719042646269054846191062508907800239400811920719755381836607701451370460251163345156595454782992422934864561067642130607522956645992140352680415053149271183017923986829061016270115209483662600272806826621627769988683902201721235244290285812249134432303964791745027916074906452240912881172198750323429924792558208177710404308164293207045465903677764695315399001033085026609531100604558818703216094817918349372368832621094622031158776141768107741056787063524494761404231187165112505787473763384925288063794167218251639466716413728886674166411210307986846792954446675086110265516577189799495011012001858338984705480807042630632061692407576767443109472365974987495985488981916594269779852996290555133733922196412742002272215755439434708789698349481677137971468473263149291400283189098606563510449505467244111215257231725126215162246015188042335011763171201202742393233508664213765684681112099343952043894950754604989174470906966794663810864333583617254667144733642359353980506844199103578012761428625077097938130981972982408516603701746685162275230139464153545660784714062131259603044964217459239165334878169618805052083115233994526222722009529345559134463223631797006059772189336719403255430209219375893963622368243179187878588401687597758441832832721029028436674850259046046179280605575149850550910382585794585376570209315186771783774268886225062826885792495079912720510786196514479807871821944765467194889330113560804870371289408099276455335312722674422594769250994373557425125104869678681830694454066063035028319723950034766104677782336068320341343966629782330593525308837068566491689058325696302064886873272841266093974367223229392603579461962707435877530581570456195204496444610022021448467136777776739866336354056525058983711367207740087375793450613382407079472954667187550027025837024150935372545733101852912238653122746209579753309114079408545421069755814004925967516869652324991428480127860293985287130271418332546263914852581537997247913114111426081661385078318537190127019767178185713548834886943712460388757821534583367061773446432681857000629730498862103069323618601967060305284816003809429667273678085819403253281789978829897033065426805749169024880375645695567435965384534589036041597682620013274447223914623323099939252447956246299682812564765705501444193692387410562297576105584570361131966881917546361411673651233056461068136899095861030713478565630975973806815429865870813743933830569485755233762748777217010583461309255100336137298873025117776436279325542543224566267968968667322937269324423468916759003054967836200092871719405605534136424426496651691931650233461026141318090344349280422599645369402208452461475343069245353914371717935835194329203668584432498967043420882189403279119091866905022745931493336077804409035771712793560978525251781030505958232003356917555298790897641307380925558806061338783875724333538090829964988403646886104177192998879523381842797045612545903272372341680674361857340964133290893931093162092382172131411913290489945308639428051807990680870430548495867092816387184161070884895186543299791242073736072103855252251905147544037592716017547557539770912641513270158239290643235515111379939035254901588493493032460112206284551193219122485182586397086218331855308443356129714679701842007271758754614639357807671093895883881637373980004813550944979333102824161573367522452022009185630115917366431714746414956488022438161694609223049085856759161638410124628642520788462848308933460325166242342277102513898029945534379093942833048840136441128115155085199021334055536569133803683059149452343522078720551888543870125115499831323303576908856765197529311313694480157121170275576425961290749946470071974233673624290276207742944389783722477164637222938345924525977245218368948754486689902730235042796034318313614174813656826778125780373768627844248604562934695662171201421057736930893179327580161017535665493669123457307546135511078825308259311770016990949261876364990428091747821171716625027893553827524520016335120629528498812829131322328351330098285153074926269672816126664610467960821747149360014720931068488574436812241977829040854571153350297879470723526692056100971632385614880284842430019468885004415302982017631218154700583025028217572708669369603981020920130669348641819840703497182053919749503374625696274997387493502659085804605921422289161201002098242837738389385796319047169884593089579289077496847132869738838160210608718990465340589106691913025792864113085164674583685144848126359747125985021351233533947146706492968189188411373376028013842792065288021230927104329378017073128210987084240541101917368162986051936404372164135129412821801149945947576781099889399472547978992774098425991405288915161356580245028451458498166001224718051871490411982648954136342886915213880590892589148885934895317849435066834700139520116918597423060523881710966539415455043179645822402168945675206809656828508099647291094498312734370454825032111973662861824509244884703085878058518590148130995184309788235518254837754422637282121272443358160561416513232615790783600991960492760325438074736090425895847323590155674551217556266849503267351705793548876741122972324593745680577059137230991991684098812620131714907728094080862550187024543688503016739235202894260195396630145532714882314289488409779515266568694353454890584488244579851015020516531608454217180573523336253231829538717002923799298164641551963067476312201815883767582230397201435342611394581319237604808246133339562834459920617624095583544989156223584045493549427831549253000166413206527776032442031835336421117611892706942799407000410931270777818568507597896494832981507487824786166212818750621351010141040171691790205038273192993169506510294151316101109318083742927639538308969423479158640602286136839538311684940303739294391107828965030134048886751531365955253595265489083603769380828730421738121416551318453863466734020662020120624415786118656569126412453738321356376184235304715574439699803124304425703674033594146524767726943717732068065137468095739336184909449217218345815074316014998003520540004723402360949677253807601912551361798753367672508601537349742950352373955932182222453639173066340488699678329466521028953556690180468829351545751317038196048433751726482754909722100829305180027753575844949998621446606154317509891517504907048563245903281390975381931036943273407377836081520070394801379660506044416808622818545808597593550151271981997239493665379611987114173333939205887726386266439779235656150458798695352215722703478551378249219796620268781642520529655226162856671287972340840336979311304280289063178953578234462303521409000677517012302144320347565064652005325972281092441305818304918393223069762644814325398822667858684872563192411006592896235853294492512759213703525921227715848590639018182005117213788492665041928585119023812084403641403443883290102293226882992687296051500714517731646669066572578310534896934864789166074149441647971267417725279050687432684830189394660448368153582281707360890642490156347136907963378593687686688217384256801776309575636544214587659531058259486618149679030491389965895015754008795813492625650021667071427191290179368831152477382055691391872130119463156747117693272803204791055533501351163541877855013176293475185961500459740837912601200622532622145801678556056251279081976863374744020341968754947080364873504662883492706312747928896480908601558796067184066567113692907026989646607580976228100915071117650530838829508720647362877418021411374380686494954195813973996007862962837107688118520677701346750857174736881494612929249430251291491055597875131850509200932764356354782163809844068133237418669379426194421199343582049880464777434039239952188221657168141415731693227059608135006528858933451524134154157119118840889685107472680024159851386713617636524251262188533812444547357723539276176148784473679831186303146653242293914098608715025548248921039128776788667845585549320375011427231102304482073226652904080622604767733307722403685938349866287735935306609758491746284595358127254418979801826174857437012171769004108511799424573458316277583304819618577271809975020722225334378094604056975593733158849316732828714346441208916495171095725811875179530617123196065702374405330741409137325733951045660638249406829369221721555138765399666178924417394139749552472235010281017321348061074249317720336827732516550900086091662040574223828150091129788883380739956587947735156366717734342812150263977246341280591761797503437163706912253627513784775549612741259220912586520191990055067578303552497348292403543183674314926187154148037901434354241653314548198008024835125405006622870808699466460488496924093124764854425555001257361021023809345854351126739367321606009884805854283237522339389113440926665290988845819603780690080546253051503001406208391871908034473547276730544706569511238607139047216583221144564129216772317237538856041236935607114315974742263240782712531337851285177704496782922312494469864812307355566925992497850853196024377931438567065545935368039624548686603860098984749355782979804828091267259356583280113795856232417314197378218915347776357765169147139177106222132194295965919368748306655214254509885623429902984225563654359336183380303998137010172838165575514319725073972134729311924581866250767504903004439184851687660194451389855092978306154060068501501311635899763509472918139286195900607745132591931021115681753771316209275989408932054996764974612572965809218931403416625267094606899352117272195288833139948923611852664057422657872749079323603790960377539648386864055988054017755752823771426865367569840998474896918038739861302891564922198253697937019288214723393695243335123577971539451886286617600276267837592084569569600857505699797949435580929695335897944390811813764364222810117906971004661550226330214671091536841466883873812259344869971746900228560171500477800382233342722840641545727372366522253662510898175780719709419182764809541698098395630061703239663672155224350265143113549773792056884652678759709731284115737983534398615744145802220386562708914484685243962298420726365987601188304510703047501435120093751518624013682837364105344354598088492706720633988489864334499625832399800414077132546165120996657858239148304721196134834235004720690133660543691078833948122365358712540602423174482419383142327571986618646609931355461628717320273351388678345248139185975678768366480936695815990429723536808395261987540708093577486902217714656566572962232542200495477056845509763771813216003885509395032479550052663752226341932383317228734863329623866444141885951055087615904855815956461126312367403760959707375964521866683355169745236809978984012961466987892642698088282041651297922014349563136546967648574408059903648020757976121600999684902627865802571974846477067127095529313239289798420712809048449145173712547848122856515256110106066020809085913609724131579708053371884980964742092450377433877346549326861419646551263397071224820582476963413821811631021903237501282735218978509624868932085619596294416326744197657711479522416118372269369456448282120863618682219477635081767790288069513865835130983051944793502124590398710744258344251032629095122074079966841734438493754683529856557009174616908840294025863663388615552154993487296769994900801960458179315640011266175626234972889630317619269955416337916163030859048849334636488634707264131745678126205976444314174651414282817521176242065891828539941823452039610605036505756145479517326636677567996607989016699647973597219949288012007758840401426685796310941439729741102842825446577120741270564969746315296028319304456300070267348669324184271165391986584401787485245431753918752943981837537542678897222335377777779970221897033730777132982581612870876667530150283174371123551319819750018784415139132640674427846785860911166603954819284211357357256701787095120448867097266551251650124902160399811120821115546944825122198437521157054865457223133405871664170442769779710967132049165027773174732083386958338917918806849607199890209363547169322276835640587363677640765281952735553076982504167077396940374659057174839067775153899761588464280827106825019209379098018736399291824801636802363105119868590926652623133217653133096724049418959796068317974187093304034527883645442159145547487847110834932051579536487206482816450222820901361667132288465965823473945942067853433946982268863651657106305980283166543216260534951496302241134086559586677021378438592240984608051425359324505223122986400047232450020765276963413486373214453326715459978460621966508622777058921088535333151177693447529089517914911650984362701499253946272020625780218618186733106507365492331197797942995022885688287612428544062715800036423654347542285720565279277483733709887635235586465590457209090391997436060107968597918360706932005881444513514943996630688065211294468618259023348108287022304316260290885878191066229301342439648489292918488840745214745397834122108369367578659538981206646537147322299813588575539825010815560393533574224061790609663901956680779569441014240807456118664379663882797155542160917167221373773655969127328719927061284008113990693135613677860157647034765965634862148997016203291271227343356048315618484290255119685947987593613324254563872771211624232348235170967432382857102208956994968544200153443987828344928511546647281947093597229658268862095946099393846966198023019775237212141360707439350970852679016916196034790701355581273242576135901905469947778763891917104072595545360232989709350586167898734046432689181627958858495452864561320441483008573065484936330554264625726312461550381818746781085960849810536311655961981154119215475057500694060584938663430222165561303417297759216620393447169613850588775411004735565557143100723930616886202399147587853597132596197979196123832118741227726846296596928354332054883668213808219364828362841475260588141354929635335003179789742190505182483231739954974196473414593741366474268251653503683680364758734709630715018976187915412432724501664713885407356672455062409582875246709169402177722631834547365936514645209760534314141406231976437739261080255292974654042864721661696031421158201383364518255158801295921363034935734469028657303685697146218617482167552437012074329488262376507174375105289236644061894468597198251803060932449122341085062180112820596722899410076319621912179385736720034649594879389347248820980470782346090690457728461688740263061370012974201416569676267783626716711841757291192136067598704810443242794459958390430180244680554111954312090581374599816748400978849744072993421323940031715449397680206178216432900733099867525068285354720153036439972063591688290368346877964764731374165789367102169746788715765183305769484722413759458204489801022887115487390913108526321086195701246529837201169679679506470032620827565775465952274576372155213432713083416134203889290000585062198471974993299718609727033027051944661054398442179822847874964177162047623167539147782868472323637934387789293512980706749339237876734285710052752987213069237593889324640597840905350856599425184095984407016932360229344323505264316217780105006317451431144379725974350402970365183543944079152237328986835849279623251489813367279006732535128375468620064482736758563607157677538805241336941940079395964628769868825183784572456837939329551009346773990006660236040574782548295630729313856892911209450806872402149067897717720952091801634579480535827166025268260217153636963816246243475630874083867471020476484796281034069041044047054969718852235337222823555902908561753562303738487560731223076682798084526560233449844136534779198639814485795684260056956350664151704426554355766961267072224206777924538904799618827717895104826553021524455641159362682683185871696846776246725809369020781754279810869894372836510193528696577516998083217858886462241458543840409269382880646935882282129827673591908221621094311335558005341458481413946561489456525628874286595861082390822903098956144896193231927659500329977318993014256908467460578001716033932173969616419173289862968918071734423006359707182418026720696261406319001221333939571764635896420507488534739808020578687171989504035913386808200749396764013389614792933138373802061372101443906117651265834919243387593669612934620407961020702799895274393504122602498923374523599218976298779447906172734849487368255503554128982044028849839620309627332557659885703279873377251033141718502684062708966465347634149180272885966070288704205248433822832784283022671940012929204136140064795063908591664008134420195532690457238033683494877700686752145923106681913349184512403329655369625126054179919378505876985935944317601444061071351092863921849504780904810925785359453162332389010061863903546659244111801043181615343175462539603130129031629982574784297211191464099194700449138419712855040969287117298298717667190341223690278522709099337853702794527385611762117361975979633493661210279875655086969483214174575369439415750808573986171170328094357650690575370554525428664296714786214156311073543925092677990926600463380983015101775147379066722725812454443018216930230049946816258980865362760143696680316068211330623211327470036635818136654490707557504498669867230956386617944231006419245827361457048623098909342398155205556606725113568063766767881795446846758486929368128999881730821220075707234590071384738695461563677193794327160964205638653578198468723210736622702573034445174769642599229994813118366534145483963840185523113106731470976510277009765196290296041925196655576611349942603069468472341804908424779193349756962265628396809982656587818467178147892740182147687200146478212487817025714306661483990698544772347401038318960760150663846533870544109033925016520230090561683163158192642021560837928802556917308862744142427628986632041185768690791231529458474136832058538801192491346073481997835848596154363311001354674264087751396586680669411978529452610421650910931763574876170734987743237647555900047895092527246520137415950596509059558325544908803582139541880518564064940245625338115846689757766918938373144512606742737509740391946211685059887356546075265200862905696674157474390475394010400821940787268316259797687372840244342547383848927621150647624447312014469424523679859824161509779379325170779046973"
   
    log2: STRING = "0.301029995663981195213738894724493026768189881462108541310427461127108189274424509486927252118186172040684477191430995379094767881133523505999692333704695575064502964254193402661819734311602943501183902898178582617154439531861929046353884699520239310849612462540400263312594621478845847318282672683982326196542793507631317548350927138964946917785768918050790007599548087815459714585031964877626122492290829118190951498997171619860477676500067820517912557328628668342000402920509837084572224895494297562149707244659708613689609221909482761214391496528235167826492314804027746243244163311538738259303883039380633216130239051880582131915685461692905301505131926985378488418718320065753569468392971742132010905896890850585624640987218396876648539856235161277302638927878260849836681030308431415560813943617674548856663424538123733932422469594349060212044504296827460688478546115684768410643797950046596991774565754086401846407945652954434107740829399974540073721701680194889055485691069400375411689963415759297218064430381028152033923880856331986854539873935485606578428968489826139442608466327829526028766212762304341922026289121120836126005583686254899999092794878431974744338886862911771315741314322282416907299585472526615701683786532484377248450149423107098105754764423911116694691455465315821308754571485915526406466945939738727466262648155637313532726933795969680246236373580370170278652787138236826674951982888462336755746230644779336477698037147068313325888187313121386474029603878418357067784098967293223092283636409020167703716182733692845408721808014477176262550695347616088679696249376657532044344868795328929392535511146831725226726902757448067802376817553483740570438218122322533316789620797559903229305975967472086664842304173923792599862534979783093955793905853103797525214306877880559061734489219110902602582677330757355925788842287779292103675340786349085530479489195412741918499599847200289651248252290074764446323588420890650395495995855849103511504849272182404980745441559971498947788737868250072879592234300982294231924966949141757391254082349655397653341386972420309417367538419661786709957833897027278700463997487224093475301726282776037837004173822886358937792496986238232587518046329823253854659034188442660722774644793627247990376912933346554600009355169558242485853202891805973612538480182323344238210359767882413103921664132636490923692956109730629584223001270161789239083304966085658078167369231856383258483946220865233022880717918719236248933318301507731107074568912179691465936726313589320801125976235437730408406869123712855981276022342800437948287640512505691330382612640301053054427352245875538942628240351420297781857455215238445695936344703460370007508830173546384743853762640381345410143839715861887851093305552261243889568585931454598178939878809581309770329441845499753967558468852151992898007843947785274994069368329626033764696951428191654710113484828098115990389170163226019800333588334384534738283702567802318386186513050622079614064961651719744198336260525124943546233347420786821851691959100954536779410781592036097393661637424911997463758140738895912781566752279536433155440442054017977576457454804516935869855771349896259999633871246348491666200655261244312925027309770576156436333148097939758638210163915387628139622167865270162185187232932745519908435996437019222985016309531671360020749592282091692654940646201564851645483915819878452213233045056612963857397493749427336112774151384240100062956295219150126142172376508747523934926870995431099140733984637964862354120587705258215700194012108826505386242094623987613563221915139541374517386591685150964415311957587865649866210023889369310878094345050852846623438217734345788902939813335503517477700871082129235684867862053953572027654554179053787253050271070106217071508891052688795990391053027890086881968417400355049080185236334653415084259867877863129549425260202977706717763322634859620820882927474045637277970147275563878819078440097645687000845788370026681301192320619633387821584604073344926350365105119110140301109878273705784727905131674836672326194611958326125453233154008216946710860270177414996769399824937594474661341514194093755039582584375305564892766710189565161903898722287241251512082739423109883814811013770037358918508887427877953428744159237616459503335965854425500322849676606943922620136543003030720373294107425316651615007141209980181027137449715257216072493664638835810301427278066267594333468726037445374366027827223141730345130835730920936261614205483821814633306531509127841447673837870218098850771321600704036724956472898158003335275146984205802276357811939531033476301414456747863735724558097773493754865693987197797731531333706147686258181186209000920696305834429865046078746002911627890660715963454006273751004336893789488122044741136926669595088139507034637785395542142907637051517710239720845595466448946524786296401704029207492705869071942743824693057906493758875018375070388445723442717624078976911694115201235871080505551173598596152162965940514954252891569595536484135172687134874356334208008576039590172338575468820615327463993954935116107510192765672113643725485650625461146322225688061532472008414585238223889078583776524890717311134165051214787647073097048911619761709385830250330584958110112150456513196976412554791860129354783539440118254783713333228605440535685549249024543470837116009140064564101019680294233821790308616468999434504527852450823931139223846521232619055184592441811131489308854060103258598030512733820070510911523050479237710952973219002802576400405913769197811640621743186862498821347599241565706642026132382720780603954773405089725692600703199349991816236971403363698124897374242665447305968672741439040746088244051558648673000580154400656954955542115282834744506048706944799752897173945141899455937980702968577426236468645489733653710209716560178423135731327609505108266296719711006190106432074439050502604359229305466993564773258838152113767288133378078672655455724818904044245967107680236938808231518385462406798520574537658914262546522765436197514462963906185748079460515188139874385425379757784929663809843732214090760086811043366770012398577497373659698668475362728165855030349322828565234991156898571158662529883017399117392093772217019572857943685622884229320139434103737984173334633145786394640974775447260490141532628518252979384319066990148951999414191082317214622806302028523577059500950197770809654825225909028265119484832918045621616797647628696331765895105177860070878391675062100391782233412079026460047004456079074733545906392149214846433028560878990795370880538441043513416462833173422275883558394615974640143962019498571349817691644799441281371428183851494083602628763996149179228124355369292615851544729298962569097993798712979147728620465086931586713185822327360380306522082284867020866113581186932539733613272355820122360408365575064389743288707808620230407449812319121588078822509839643877163857760913033627991771609230826948512494267667529322506094827595008696857078628962554044745270720868605969294237225518817785789709666244215726662406177372925795506557836692286311384554490617897892043814460119591660488495424533752767834289694029887063622608914678057388096088179203154082819885510426327961909735579465374779220547090799260199686080530428243057816073041083425780798647205073463631475337008506978470152575249535359856351515053450836013219702976527403119493366511381775862512628388038277721495189426477849999634253057800639754419296395162852420066564833422309119206637048283468092921134330993172298395190341673568670539090319648376325542927552643405927692972844414513073455526569463695221884232374619255046049286813634810773418214326346534064846773748881323681783081040144308666751052183343036242753328951660299858242950625206768045634177217076620581908216153318218849347428648204162103619197305930306073236213061973365646828229697126267303059738032227543997865960682981868315753031625638968802710628060574023900377753301294303090048694989889026378282741109288593835584038065721079726809289148234234820637542483693201967945696899503400244721196893973548134197233741674351979768848173025102467240895207671365546177715697125933497494189721050037397690673509543398891417940693348596763137720414336110873877844289308303791894437076425635489655085719499798527798613891675187773959759251192291355184471409866417186299364268238065606848091100273032188026661416498317118219829154783533681772627510904246074297162303133946425269655981973297472241195256460001999338665288136272893811362070808524618548339179720714505545133387918882364035655670288434062836072785337846042264832559614495254334095560062921956917108636767912891317950800057280548970114223031370846056122922526829918088800186449338473220066146542293651363225368188307218535080229228395642267273263296998599242280608714183053561283970138567799394794878239555730647291628861313256725066439364913795480435064639752787624222520092459660142717675518545176464031339652111017883849086072795680454817361597544836026315895885152005815302642138270223177221874606515239896227240548849891470674197928168337960234455458891752198805002211683825729613125414208084445403537177046022230077267688385632084022682711221635012650896863298464156846106772473800001549391440029322368321866103204880552868195044575774294211716271152663897585155780010410899361627501076195403811604019555661783477545124007992314074878818185129047724279121424853402021795700864695822501289491171622950671151440319096638961323708983519997813494623760751046710116763177563180837141985245382983421513864614560965108868732150494296387006173969745638010303437971982373133766585519706313167491795196303137356461936916447783484355797505820788907962127223192501215071214154722130777391387730584329456236492828312907315723868818133436792306578809241416681085486870939324934294615246511266168740684241592758155125911552410393519494006445195695347226895814333447505751245855975295701712313504663728547694618263801594141124245602432497572383143985049304194999488342193673711663814949648570882879110654604992722868407145023371881057207664082249799186545137864014975750834252496749404467933734232412381924459328351342027548265655614981517814145093696042725787912812044471372165280752425515729380363131462256977471555613412125960400456939533665719819260834169910271012574559997042032147780309257949184930015578022660882376377961399448469563543542566442608211985354008212826166878906530521030147755615810985006150955736664354979545168168430249023906678994206083132684960607446483926310386922370187851048875282342410305415326266038870023388889986355593262401398096921160677128255283194136414813531181268799702517833340812192276297896628427141882156130679356742340876565302609952850869863092037033071943559640964567998603093016555851956334424855437262471022639939251385759084735731977479460550949853874273172558845688332314207523645214088313018412595824305808227578349041362223570413078951056391253576715225560319294641881892208393563602967823892701031621162588852198165969862889325403686085437956974420009876350367471026416825099382356026823004690577742748759169871653892792621890040199051633675340018190063022946594469761189997321175619234438339451410256284590777981410171546777855831876498267843416917285023784046640072872326620050509671961284885700412768664298562047012317127944319058882292635894110833539316070402921691782507682519990943116344198350758268591409635896461194951842727838379440691852689737286808978421544391762603697365770662605065456247640911776983505493487387102922286115116733966759553169855453885730822095524621114526165072518419100774518977688416980833329453578283813675166410349951466870029384155959525911065566042059765109138314856433583131447419594725071073180437039539543276698153046295643390601031812532255722120077120774821102072828336192889221918137969352120904198402475468990335896096928676215438997140353670561134985869887467829183780392644901219553774901817283476811696360085734413670713159382432373716514005433584382441320257269775936072876664199176081786933145796959695739626431915478260592539651366679616664521812104132966107353798998268486506294364904506441233193789992252995248118434346044716347799556857873008420610237290613524197350428081429762864849736504073550991363192627793426786467308402728974257552991572406449971853622814001557510834992620963313513003404236380817110410491396538944557858776705484431989969914452472451967282862584067967511098277988612052024142441580461908820690145629748267185328631081284442766264652500781331008097094365189803209990767158537330560269568777339748992820627630565615150061939584261204162248282959592000406713283683877877387471224686482333044207163658723850004236875142391091529896139200363466631727427278486627335593508469156665141510203234081788428301990492948810762420023850371384445459975665868923706414822133743586754400656165369616721404483312878354878569840790339623188846860769148661871602905492527901983114540210895069730811007993511078725855464264959972549396615232491954219710468138831013025848515803295439563869748935574679371936151892363275270726127404940161918903890192713039911723815491117125635126235749722488486822129901775171060959778988327593741381101725587440249635331723434799091250301881767719713115762790121189064164245545755900915672111637943596804869738472379021874727074425587732278747736044238924407673474871567919942721321173312216999188086682796062727573982140496705519062175640370599536976128837300463306232904528563457259495999799881215304264885191195040249069938285568141621181338753638429012480939642262480465014056848787760420477467668827083733602106582774148465421211331708974299921043000771203651901320502081071567403258568403602432875719454400046378375814107042764715252722401332799130435121956957480920323635538148998650599353613576109718853074172936436452859732343438834548145966644338080554535471887602786434578743375440324634125382589830323115852219918144381481152773074119961669128624453308648639846628302529740616297176444953976029701136419421930039586897875019585048365484602280793075792947882869874197521351215143017496405121589156720744547409650667679561249548847188038467461679924437100981350389436656840794293041321279237286330542270252675790659743507798450750596994284984806880969663912358868572396693687066145885959294350026749836074302285442762206839229572016017832003062626276366568984452054330272020077149334759575270035023607761189845043155589855114710345774712565781931828985618236751440627597363859491262281421135964743334307832687419644597926380590399115805985253299051214431536628990707121699582267796090891310081848336976686795924534877277337537851907772985735954042862594721382645710237210795828048601187029335511010523008678622751166200139246965611882982842906262495061889369633117959244134054407885467957022537680086990051187827422888095963603250248658783600833100332921963280966774698060136473367190512075059007202164773124852895905571437449146066563029554910345580912581267652695192871771616872309801118662103967535405306515045441386708826583803307283479010527951630162917986088618705077666479506515359419981597262708487249294748944729784542310832858550430315780782698356705488495658923130544181581917759916593513221522978568104921134341641058924404248122934994896076660031975889094722857448761747653512457504378928270363773536492495343552655702807321634306947508383275082369684610023682859347878590036490977809820389246529656288275409776465695409284225320024574174305016955101189961823719671237063525889089655232494445646228930489197747164889794884525208382989664339124765513335464944491591526233271793947907175983324438806825059559655322499384229313704746186834394832457190406301781482208154221094479514058598958253122686208540426557926153958249439816949496760142473580623973782196484340659182426741402078432360391337291376964464763971475856188556661240050092469976659914640503781713982515393751129215293919882198876604482680343179745061004082403019402597931647430745155679230730608359155638372235344868676045240310350351182971483557992768093314478883380680727271493464205540269230736392987710157718036227358034675678685651595708171363841778386348880510165793360577814147250945771519490691970218376319750966427543470982862340902019700128046454062148997481811446729873128068447676894861059224423827696735290721453306139118404491434632719141049734446515803682625665819325408251361357465743994938857938550620017045929315092139661173770754631866497158703726155106609230464429367688414140641932484297518142668455614694136517112030580901520946010367399709571228249388077756652441454516701151097757159995155552337176640995979200869725655783306287832062348831719122610745961203953656974359976959286376078054303820305872961494747853417359705768675280597097082299636957480585244773000955517572825767941707561958359046459665601383299286851915644545785748495397235821687562287122121225107264042194991053536413070558755813829957884046132439004587805437127367434218726274082620020944601009823185355261698518314873786790219610708755133135290779203168401291194122668995998122640290298448532992844695747566564965681888233070360314551440415897233713898365340915951384132824146624379381511241664738903125688549136474216438362492968541827338376299823649520055557495490609147087004817659116980597259944481168329025353394934685496063374145881468289357538583144379620249922266845965196507939887194284199714339356270245917396412662133261593957207199351174062726404819614407944415371924066596560695968117416968974944174495912723563026456366603799984533726328840535455754314355830626693420128343183017919779600820477772538735540733372729657402546812657484382866121008570078716346814934541117355426638876383968640245417626415266144844852435149990440716458751721220132344973670342630506256179417423816081958680216962763762974619756116771809968830659559593357413514237694443261277086103646790344792738402466721321046502432617032422978448224437055400343458491832494645556453404585894315779160489965836917495000151651695704348551716338707002464159472042733627198586371408503409916662133614968490858181365701928873846023661452245476485301455189725821008624616875110935987654332679782080148235688357750805745028392878358467742062427622002399070057944764776861501163022910536961629794889959216165933209534638707167944798894861488566732427993863873660393967691439653045749544440521832110754180864317382699243744334759657320213251117357600827053683086923565038340965570064004765679593949045792137491636528953365034300084636084757023494573999572705012945632966228658634760782157866938812316514414720905413768207276181814003588684651575048945042419753822186167248103749290186272835797786489287685202142759588380417589432892047426264568188397434934279056869324526305854286438807052710566135128395725059253901852703704129207315451145621475688203969403838414474264001712663852632626668725303478865406466548516899439737175187807976086164226759569694187845344116947429138977628402124313284392309193686511563098826091003889605146071033689927489727107264305632345705680658994506204313797288003228866382258922467432877390697600032083809333550360096063210560067647502330880881852740219798465236172418349985687493526209694941788258010412479103813254252158321825800555430772033818868946066707097726639715549262246962979702417352451919338438739716698172640199426592561734553900253940498194581569306832695932848045624338170752642618543709201677274508084634145773754954609109104013922408356894475837641121091976018920326202849315571358771467331570363733336939895911524605539788734079489312005115765786218387042733342374773467763200533567706004841872994510702352096756303396605516750755668395111054196148420486500647294547991211556670478830056037562136266417958490752847020867234925092145002827081618139459112532503033302388137919602033235177722184415017231407412519707036649529360733426019492116122074955683013867796510782998399695680248043913456957709588168254864516289375009575364856335131412041693662366656267616340704587327132122995725792964984178041649810644635586346806903996680533219108214637679208535466720344541394356878603713899820420815958975640121033356278102539282745899701682005745709867543095035209862036579708544217113163380614950725877916934498224989514740463900790738192329339624764826069520390478589853438135215284186887927647220868869758242346795134201941976679405817570366128792638049652654352810765463229325559022964279664903708400062958840641864253208569196950987508200219440780398035336766627206572893382922671911353065833184054508332999179672176834915991045165480169975814132479164027296638089397269749962384202653144077484781918536689782470610276966343721473278625608929303209662857154264840427718997562884083924714136661522132202542461909996963277571166692225829177545275322682912796640724093954414682620490786694269890719261861753188654728999396269252241532814323602689079246365679209939987130547404870924384214648923695677247848299021669532531693221953323320745435666041826659719787349356927106452432318221229834610555087811717286435005229626355471221642867494756213732860361920767496364790388720345558200232525691329956803577310104884142081231512470604323234286767949931570811539257247048695142005418928660683306128867211368287423423666579245986736602190003292097977164296198688308427578390057227228515428943919692824153718098084020288727762959496542726102646612649417313387651514762057887769168298253618012873609879870868940545849987792106017323933842150626977041507839928888441277860563481955345779882078966602835665214739789104147519532630171128736686079391834765855276750199228384011282134629504513982458238796551835298626396373521398501842517823730906189245804491970897054399716184389865309342245996576453377306833026081578063256973233751414574999771024279038749034415098333438666471410319006878028034232666479733733420307812486332141802903415111771812557130815411022077551977542084086438650724371997780842169272988000776112238796465159247075699668023523693604161515974411784845183677023332210394004781713873262834854366012343890809154748241105862997646109672029345624883837149850382693882607302302658258433050386632190134269077450658053973021201527053291320993814804499169351018192815132650756718236801899174429975345489447762872350842085520543571713744149870755333159632768246729519874798492093920391159658302554340621318034184085508771906525132398503782675962348900803719054436968272385832550656949313720934855687226536074844659792767664362632443321402544836003393721456594696091073444184191869433829636035806435251380878210158118084433358342174741405557623299110977870495722603565933828327429344622571469027864048136136229027630656038756038666912987593539783787102856069535902763801747286237325160778318193346914077529405933980624917656799913461447932856326156789463728692711474768621764893629143666335685463878467279378576815176563036075522528071408039881842175184881463851234780372688614530279927689158853141815204428137053670743251215955025026525741137470677867173287466329358445154659546106974922904291878204000768140073854084708584798632323736270847968975124209384736393028128627466067458992959695146228455984864723459733982225790407083946788122303369758842540373763836150221419987453287286835887315318629654864884689020683155410804110810162348413232503181217941224891509001949519545259226409098606312790176584621398716753465394649023953614392902496215395845868022581704539180303384004576028523953226039969279471661416690169881759827236880157970466931810096792229927829042556580672645584098822290684305499816715194748443618396552843229742368032533712296478111571531189321855239946835783877952478961234908260738567594936452652401748986884001619560326062590717426111217539110870891424049932785653308006906249254702149258336855857842609352392876335275686186314498431495443649836215369689568854892007328128577894082253397095278856281909879069607522978559219432334286910340842964305131412149993307311891650908037560856136807799307422227989207375895933127281110405805636870244530491116842475902423940849232669206748982678552617689125485936913472575186629267878651331468957616524276085298551305111535557704926418132170381887252943864452471172864419119263036112115603328732832239398261370831337887323499313701319365919350740093569202126440179317893715760377399096925596182985333876119533287393804565154423108295194816144115885870213076345341843206543569540346832103932550723163342284796386412870564412063492023444871187034338142607857491093752549281566584387666525116385163064544784206156062153484367823671606142316045292168675346311850229314237101487704239400989253369262664768799538243467438348501528328613187898920273696615722176614583205751791716970172908260892936718072294118367039509623539144693049916522007541853042253917495705432375291653819375571216517144459437757699937638892881062943108346573881129226965550084157357674829538100297968145106165987714345063417582024595257033360966514927299453756858363795481964476800533142172965397489860279266200865370649777824026571072754381624425729605904702621246280817795731028360247568410100794939329016935742297485262817391561801383012988312177572110201702531499890227336777791427271976201323128031765849713085564422850808694527843516336537917052148550404464723051937934530737630136242768965066259649860609218844711693128566992905679320116422833038648705363181988214599244458589551830429090697093230910819702696269651288334538270668615106005727748013156256799808128064874707727016056322431891537544902198837005921214285264691079100766924035574630782051812482320702930788019682576709099682289203098869002789301907111400742118663664503523606301218745241852910324044566283120799395008230935273970292287639528438583949665622343487649262544352353862222356498248506758620760475374267454914822315102049381185571548085153045539682461474849632958815442458475059282807935654211078794224656750840653459978287869680628079585698543515195420591747670739658594845520912004719813446346347896884448568352014283944406904258320932516724528787677619696628302166463062429998416482024850637022874282323312477158493003881655216120208191106799637033810499993545456928055580473744896399008720498739430523340050979560385834245985420324222553051308394947117534316863175998564017461848296739009836848706373235413527371775952854690973052894293143440269936794335820676702247365994098382711198275811821637399090835381570222047795595934689382989970773390791259628214896627658192438085296682052344539066806427558784940977111615668784618555028494342621872951886057293229183564915188254454670166454766533458507950882185857208069928055692355382558685963589663451592216873836330547477749807700520217874942257079816351169453998782013777728595280274020399337309315081324623581637312849678598743392483913563863017219859887435661957152539861757704598096424860888162572207860289646772433816879655722468784185896885850553046291361317309056988588108607251409634719648462728229246599724965782009922936342337079818184113442812960233671004168032189876649120156998326605347281528757061071104532228880418637095775344671536412996676946681827703680979369335105493460804981127230700035535311260827862532046848001318904292476103381150100539801077114974148605993625423969926088590130994544662691475973514984091256436460461180170418221956807594324750153572312506040392685176403819637457307731630379232870985864299148332101275062984327697939203332957434245337287561176104754551392972055919179836866973431018725766326987871343005558219703243731206950947660902078681256792851482632392438141373551019751176826124772783346905788550601744644165216418785808022199994385789711574348585169130521980727891043740838829838155183476505621486700364943596215565654124915870058061960864273109898642164833668433107596902998740776130768209340115815331242062287926113463180174890190458764505129977149264602895152743621971704181099065444087680256820883737831634490723413603980580018839130891133735786372089538782625175179657728166743455107640541395514934200018201657938653911344145295847501634964635420883157761387261701398311959502900947132573445112570103207641095770746697889057567893037445910322440272536976361496945028256631022625587849209649270772954121946524566856896737856099809045999092076213991617617256075963186970758432954566352528828850658606804482248849146376373137429171981750330849270533247912014640939970515706557819492790235365190167728464452524165046989578031134239939936857952756907940243790210505787247264758426739598234974841614804189340822259443133890681995223274900661232541993722246012713108190737963720310358002255412532822594056719336098234852426229236321074174049941124431528273896262520540051171074069386969474168885574942775871826214759749701069407101712889169419510066863691539431970185105924150098124999041982098614839778470054335293297660674945963564555214318506636579796994758683606817117172193938461894642677484684106105162989115991396579702890309518887499934502629866013737256169576069469910214856091734518302851678670036287223404353193212756014517977952356087014193578376567498551867514607531249577334641319683894117381015491738668341615812738765030465639335154468270474119451444748902993720550658288175692800089579967255524499355381542961642512150556704709455560543309659126723116551017752221007440361585555264780748377942705359360732262169777334825770343605757568158272263273758336733029573219932286175779819779958783090919004592704064723392585446060956688127659583423012749154005096555266154085948850770527130033354496452365970626227106648389593767310124508458740571753847791151858515082652341815090438130160800332388833698748393764228431438251224116358592769269876745257800826447010279617997401438246109683001240554797763931010571238533525040271933099507192757149052661765626415185248255379485251852963402322814083831552463533686041739675520087081291325448562125215922037591754901768784517628487115886018856889354470397304988450231945913548620582165419420005714770939159744612646180228572129562838690375506499482768071003719443354201962419978480378996834982008087787480452837270641603477609758038100302694217037420756049916627944385165813766407407304526503661707577041571543993059664"

 Pi: STRING = "3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648566923460348610454326648213393607260249141273724587006606315588174881520920962829254091715364367892590360011330530548820466521384146951941511609433057270365759591953092186117381932611793105118548074462379962749567351885752724891227938183011949129833673362440656643086021394946395224737190702179860943702770539217176293176752384674818467669405132000568127145263560827785771342757789609173637178721468440901224953430146549585371050792279689258923542019956112129021960864034418159813629774771309960518707211349999998372978049951059731732816096318595024459455346908302642522308253344685035261931188171010003137838752886587533208381420617177669147303598253490428755468731159562863882353787593751957781857780532171226806613001927876611195909216420198938095257201065485863278865936153381827968230301952035301852968995773622599413891249721775283479131515574857242454150695950829533116861727855889075098381754637464939319255060400927701671139009848824012858361603563707660104710181942955596198946767837449448255379774726847104047534646208046684259069491293313677028989152104752162056966024058038150193511253382430035587640247496473263914199272604269922796782354781636009341721641219924586315030286182974555706749838505494588586926995690927210797509302955321165344987202755960236480665499119881834797753566369807426542527862551818417574672890977772793800081647060016145249192173217214772350141441973568548161361157352552133475741849468438523323907394143334547762416862518983569485562099219222184272550254256887671790494601653466804988627232791786085784383827967976681454100953883786360950680064225125205117392984896084128488626945604241965285022210661186306744278622039194945047123713786960956364371917287467764657573962413890865832645995813390478027590099465764078951269468398352595709825822620522489407726719478268482601476990902640136394437455305068203496252451749399651431429809190659250937221696461515709858387410597885959772975498930161753928468138268683868942774155991855925245953959431049972524680845987273644695848653836736222626099124608051243884390451244136549762780797715691435997700129616089441694868555848406353422072225828488648158456028506016842739452267467678895252138522549954666727823986456596116354886230577456498035593634568174324112515076069479451096596094025228879710893145669136867228748940560101503308617928680920874760917824938589009714909675985261365549781893129784821682998948722658804857564014270477555132379641451523746234364542858444795265867821051141354735739523113427166102135969536231442952484937187110145765403590279934403742007310578539062198387447808478489683321445713868751943506430218453191048481005370614680674919278191197939952061419663428754440643745123718192179998391015919561814675142691239748940907186494231961567945208095146550225231603881930142093762137855956638937787083039069792077346722182562599661501421503068038447734549202605414665925201497442850732518666002132434088190710486331734649651453905796268561005508106658796998163574736384052571459102897064140110971206280439039759515677157700420337869936007230558763176359421873125147120532928191826186125867321579198414848829164470609575270695722091756711672291098169091528017350671274858322287183520935396572512108357915136988209144421006751033467110314126711136990865851639831501970165151168517143765761835155650884909989859982387345528331635507647918535893226185489632132933089857064204675259070915481416549859461637180270981994309924488957571282890592323326097299712084433573265489382391193259746366730583604142813883032038249037589852437441702913276561809377344403070746921120191302033038019762110110044929321516084244485963766983895228684783123552658213144957685726243344189303968642624341077322697802807318915441101044682325271620105265227211166039666557309254711055785376346682065310989652691862056476931257058635662018558100729360659876486117910453348850346113657686753249441668039626579787718556084552965412665408530614344431858676975145661406800700237877659134401712749470420562230538994561314071127000407854733269939081454664645880797270826683063432858785698305235808933065757406795457163775254202114955761581400250126228594130216471550979259230990796547376125517656751357517829666454779174501129961489030463994713296210734043751895735961458901938971311179042978285647503203198691514028708085990480109412147221317947647772622414254854540332157185306142288137585043063321751829798662237172159160771669254748738986654949450114654062843366393790039769265672146385306736096571209180763832716641627488880078692560290228472104031721186082041900042296617119637792133757511495950156604963186294726547364252308177036751590673502350728354056704038674351362222477158915049530984448933309634087807693259939780541934144737744184263129860809988868741326047215695162396586457302163159819319516735381297416772947867242292465436680098067692823828068996400482435403701416314965897940924323789690706977942236250822168895738379862300159377647165122893578601588161755782973523344604281512627203734314653197777416031990665541876397929334419521541341899485444734567383162499341913181480927777103863877343177207545654532207770921201905166096280490926360197598828161332316663652861932668633606273567630354477628035045077723554710585954870279081435624014517180624643626794561275318134078330336254232783944975382437205835311477119926063813346776879695970309833913077109870408591337464144282277263465947047458784778720192771528073176790770715721344473060570073349243693113835049316312840425121925651798069411352801314701304781643788518529092854520116583934196562134914341595625865865570552690496520985803385072242648293972858478316305777756068887644624824685792603953527734803048029005876075825104747091643961362676044925627420420832085661190625454337213153595845068772460290161876679524061634252257719542916299193064553779914037340432875262888963995879475729174642635745525407909145135711136941091193932519107602082520261879853188770584297259167781314969900901921169717372784768472686084900337702424291651300500516832336435038951702989392233451722013812806965011784408745196012122859937162313017114448464090389064495444006198690754851602632750529834918740786680881833851022833450850486082503930213321971551843063545500766828294930413776552793975175461395398468339363830474611996653858153842056853386218672523340283087112328278921250771262946322956398989893582116745627010218356462201349671518819097303811980049734072396103685406643193950979019069963955245300545058068550195673022921913933918568034490398205955100226353536192041994745538593810234395544959778377902374216172711172364343543947822181852862408514006660443325888569867054315470696574745855033232334210730154594051655379068662733379958511562578432298827372319898757141595781119635833005940873068121602876496286744604774649159950549737425626901049037781986835938146574126804925648798556145372347867330390468838343634655379498641927056387293174872332083760112302991136793862708943879936201629515413371424892830722012690147546684765357616477379467520049075715552781965362132392640616013635815590742202020318727760527721900556148425551879253034351398442532234157623361064250639049750086562710953591946589751413103482276930624743536325691607815478181152843667957061108615331504452127473924544945423682886061340841486377670096120715124914043027253860764823634143346235189757664521641376796903149501910857598442391986291642193994907236234646844117394032659184044378051333894525742399508296591228508555821572503107125701266830240292952522011872676756220415420516184163484756516999811614101002996078386909291603028840026910414079288621507842451670908700069928212066041837180653556725253256753286129104248776182582976515795984703562226293486003415872298053498965022629174878820273420922224533985626476691490556284250391275771028402799806636582548892648802545661017296702664076559042909945681506526530537182941270336931378517860904070866711496558343434769338578171138645587367812301458768712660348913909562009939361031029161615288138437909904231747336394804575931493140529763475748119356709110137751721008031559024853090669203767192203322909433467685142214477379393751703443661991040337511173547191855046449026365512816228824462575916333039107225383742182140883508657391771509682887478265699599574490661758344137522397096834080053559849175417381883999446974867626551658276584835884531427756879002909517028352971634456212964043523117600665101241200659755851276178583829204197484423608007193045761893234922927965019875187212726750798125547095890455635792122103334669749923563025494780249011419521238281530911407907386025152274299581807247162591668545133312394804947079119153267343028244186041426363954800044800267049624820179289647669758318327131425170296923488962766844032326092752496035799646925650493681836090032380929345958897069536534940603402166544375589004563288225054525564056448246515187547119621844396582533754388569094113031509526179378002974120766514793942590298969594699556576121865619673378623625612521632086286922210327488921865436480229678070576561514463204692790682120738837781423356282360896320806822246801224826117718589638140918390367367222088832151375560037279839400415297002878307667094447456013455641725437090697939612257142989467154357846878861444581231459357198492252847160504922124247014121478057345510500801908699603302763478708108175450119307141223390866393833952942578690507643100638351983438934159613185434754649556978103829309716465143840700707360411237359984345225161050702705623526601276484830840761183013052793205427462865403603674532865105706587488225698157936789766974220575059683440869735020141020672358502007245225632651341055924019027421624843914035998953539459094407046912091409387001264560016237428802109276457931065792295524988727584610126483699989225695968815920560010165525637568"	
note
	copyright: "Copyright (c) 2011, SEL, York University, Toronto and others."
	license: "MIT license"
	details: "[
			Originally developed by Jonathan Ostroff and Moksh Khurana. 
			Revised by Jonathan Ostroff, Manu Stapf, Moksh Khurana and Alex Fevga.
		]"

end
