#include "sentence.hpp"
#include "eda_unlabeled_edge_feature_extractor.hpp"

namespace maeda {

namespace {
const std::string BOS("BOS");
const std::string EOS("EOS");

std::string MapLength(const int len) {
  if (len < 0)
    return "-1";
  else if (len == 0)
    return "0";
  else if (len <= 1)
    return "1";
  else if (len <= 2)
    return "2";
  else if (len <= 4)
    return "4";
  else if (len <= 8)
    return "8";
  else if (len <= 16)
    return "16";
  else if (len <= 32)
    return "32";
  else
    return "33+";
}
} // namespace


std::string EdaUnlabeledEdgeFeatureExtractor::name() const {
  return "EdaUnlabeledEdgeFeatureExtractor";
}


void EdaUnlabeledEdgeFeatureExtractor::Extract(
    const Sentence &sentence,
    const int source,
    const int target,
    std::string *feature_string) const {
  const int length = int(sentence.rows.size());

  // surface forms
  const std::string &w = sentence.rows[source].form;
  const std::string &wr1 = source+1 < length ? sentence.rows[source+1].form : EOS;
  const std::string &wr2 = source+2 < length ? sentence.rows[source+2].form : EOS;
  const std::string &wr3 = source+3 < length ? sentence.rows[source+3].form : EOS;
  //  const std::string &wl1 = source-1 >= 0 ? sentence.rows[source-1].form : BOS;
  //  const std::string &wl2 = source-2 >= 0 ? sentence.rows[source-2].form : EOS;
  //  const std::string &wl3 = source-3 >= 0 ? sentence.rows[source-3].form : EOS;
  const std::string &wl1 = source-1 >= 1 ? sentence.rows[source-1].form : BOS;
  const std::string &wl2 = source-2 >= 1 ? sentence.rows[source-2].form : EOS;
  const std::string &wl3 = source-3 >= 1 ? sentence.rows[source-3].form : EOS;

  const std::string &h = sentence.rows[target].form;
  const std::string &hr1 = target+1 < length ? sentence.rows[target+1].form : EOS;
  const std::string &hr2 = target+2 < length ? sentence.rows[target+2].form : EOS;
  const std::string &hr3 = target+3 < length ? sentence.rows[target+3].form : EOS;
  //  const std::string &hl1 = target-1 >= 0 ? sentence.rows[target-1].form : BOS;
  //  const std::string &hl2 = target-2 >= 0 ? sentence.rows[target-2].form : EOS;
  //  const std::string &hl3 = target-3 >= 0 ? sentence.rows[target-3].form : EOS;
  const std::string &hl1 = target-1 >= 1 ? sentence.rows[target-1].form : BOS;
  const std::string &hl2 = target-2 >= 1 ? sentence.rows[target-2].form : EOS;
  const std::string &hl3 = target-3 >= 1 ? sentence.rows[target-3].form : EOS;

  // POSTAG
  const std::string &wp = sentence.rows[source].postag;
  const std::string &wrp1 = source+1 < length ? sentence.rows[source+1].postag : EOS;
  //  const std::string &wlp1 = source-1 >= 0     ? sentence.rows[source-1].postag : BOS;
  const std::string &wlp1 = source-1 >= 1     ? sentence.rows[source-1].postag : BOS;
  const std::string &hp = sentence.rows[target].postag;
  const std::string &hrp1 = target+ 1 < length ? sentence.rows[target+1].postag : EOS;
  //  const std::string &hlp1 = target- 1 >= 0     ? sentence.rows[target-1].postag : BOS;
  const std::string &hlp1 = target- 1 >= 1     ? sentence.rows[target-1].postag : BOS;
  // clusters
  const std::string &wc = sentence.rows[source].cluster;
  const std::string &hc = sentence.rows[target].cluster;
  // distance
  const std::string &dist = MapLength(abs(target - source));

  // add feature strings
  *feature_string  = "dist_" + dist + " ";
  *feature_string += "w_" + w + " ";
  *feature_string += "wr1_" + wr1 + " ";
  *feature_string += "wr2_" + wr2 + " ";
  *feature_string += "wr3_" + wr3 + " ";
  *feature_string += "wl1_" + wl1 + " ";
  *feature_string += "wl2_" + wl2 + " ";
  *feature_string += "wl3_" + wl3 + " ";
  *feature_string += "h_" + h + " ";
  *feature_string += "hr1_" + hr1 + " ";
  *feature_string += "hr2_" + hr2 + " ";
  *feature_string += "hr3_" + hr3 + " ";
  *feature_string += "hl1_" + hl1 + " ";
  *feature_string += "hl2_" + hl2 + " ";
  *feature_string += "hl3_" + hl3 + " ";
  *feature_string += "w_dist_" + w + "_" + dist + " ";
  *feature_string += "w_h_" + w + "_" + h + " ";
  *feature_string += "w_hr1_" + w + "_" + hr1 + " ";
  *feature_string += "w_hr2_" + w + "_" + hr2 + " ";
  *feature_string += "w_hl1_" + w + "_" + hl1 + " ";
  *feature_string += "w_hl2_" + w + "_" + hl2 + " ";
  *feature_string += "wr1_h_" + wr1 + "_" + h + " ";
  *feature_string += "wr1_hr1_" + wr1 + "_" + hr1 + " ";
  *feature_string += "wr1_hr2_" + wr1 + "_" + hr2 + " ";
  *feature_string += "wr1_hl1_" + wr1 + "_" + hl1 + " ";
  *feature_string += "wr1_hl2_" + wr1 + "_" + hl2 + " ";
  *feature_string += "wl1_h_" + wl1 + "_" + h + " ";
  *feature_string += "wl1_hr1_" + wl1 + "_" + hr1 + " ";
  *feature_string += "wl1_hr2_" + wl1 + "_" + hr2 + " ";
  *feature_string += "wl1_hl1_" + wl1 + "_" + hl1 + " ";
  *feature_string += "wl1_hl2_" + wl1 + "_" + hl2 + " ";

  *feature_string += "wc_hc_" + wc + "_" + hc + " ";
  *feature_string += "w_hc_" + w + "_" + hc + " "; 
  *feature_string += "wc_h_" + wc + "_" + h + " ";

  *feature_string += "wp_hp_" + wp + "_" + hp + " ";
  *feature_string += "w_hp_" + w + "_" + hp + " ";
  *feature_string += "wp_h_" + wp + "_" + h + " ";

  *feature_string += "wp_wc_hp_hc_" + wp + "_" + wc + "_" + hp + "_" + hc + " ";  // *****
    // new features
  *feature_string += "wrp1_hp_" + wrp1 + "_" + hp + " ";
  *feature_string += "wlp1_hp_" + wlp1 + "_" + hp + " ";
  *feature_string += "wp_hrp1_" + wp + "_" + hrp1 + " ";
  *feature_string += "wp_hlp1_" + wp + "_" + hlp1 + " ";

  *feature_string += "w_hrp1_" + w + "_" + hrp1 + " ";
  *feature_string += "w_hlp1_" + w + "_" + hlp1 + " ";
}


} // maeda
