#include <map>
#include <set>
#include <vector>
#include <iostream>

typedef std::vector<std::pair<int, int> > EdgeList;

void ChuLiuEdmonds(const size_t num_vertices,
                   std::vector<std::vector<double> >&score_matrix,
                   std::vector<int> &current_vertices,
                   EdgeList *final_edges) {
  std::vector<int> front(num_vertices, -1);

  // Find the best path
  for (size_t i = 0; i < num_vertices; i++) {
    if (0 < current_vertices[i]) {
      double max_score = -1.0;
      for (size_t j = 0; j < num_vertices; j++) {
        if (0 < current_vertices[j]) {
          if (-1 <= score_matrix[j][i] && max_score < score_matrix[j][i]) {
            max_score = score_matrix[j][i];
            front[i] = j;
          }
        }
      }
    }
  }

  std::map<int, int> cycle;
  {
    std::set<int> checked_vertices;
    for (size_t i = 0; i < num_vertices && cycle.empty(); i++) {
      if (0 < current_vertices[i] &&
          checked_vertices.find(i) == checked_vertices.end()) {
        std::set<int> maybe_cycle_vertices;
        for(int l = int(i); ; l = front[l]) {
          if (maybe_cycle_vertices.find(l) != maybe_cycle_vertices.end()) {
            // Cycle found
            for(int l1 = front[l]; ; l1 = front[l1]) {
              cycle[front[l1]] = l1;
              if (l1 == l) { break; }
            }
            break;
          } else if (front[l] == -1 || 
                     checked_vertices.find(l) != checked_vertices.end()) {
            break;
          } else {
            checked_vertices.insert(l);
            maybe_cycle_vertices.insert(l);
          }
        }
      }
    }
  }

  if (cycle.empty()) {
    // cycleʤä -> 
    // std::cerr << "DONE" << std::endl;
    for (size_t i = 0; i < num_vertices; i++) {
      if (0 < current_vertices[i]) {
        if (front[i] != -1) {
          final_edges->push_back(std::pair<int, int>(front[i], i));
          // std::cerr << front[i] << " -> " << i << std::endl;
        }
      }
    }
    // std::cerr << std::endl;
  } else {
    double cycle_weight = 0.0;
    int cycle_representing_vertex = cycle.begin()->first;
    std::map<int, int> real_departure_vertices;
    std::map<int, int> real_arrival_vertices;

    // std::cerr << "graph" << std::endl;
    // for (size_t i = 0; i < num_vertices; i++) {
    //   if (0 < current_vertices[i]) {
    //     if (front[i] != -1) {
    //       std::cerr << "  " << front[i] << " -> " <<  i << std::endl;
    //     }
    //   }
    // }
    // std::cerr << std::endl;
    // std::cerr << "    cycle: " << cycle_representing_vertex << std::endl;
    // for (std::map<int, int>::const_iterator i = cycle.begin();
    //      i != cycle.end(); i++) {
    //   std::cerr << "      "
    //             << i->first << " -> " << i->second << std::endl;
    // }
    // std::cerr << std::endl;


    // cycleνŤߤ׻
    for (std::map<int, int>::const_iterator i = cycle.begin();
         i != cycle.end(); i++) {
      cycle_weight += score_matrix[i->first][i->second];
    }

    for (size_t i = 0; i < num_vertices; i++) {
      if (0 < current_vertices[i] && cycle.find(i) == cycle.end()) {
        double max_departure_score = -1;
        double max_arrival_score   = -1;
        int real_departure_vertex = int(num_vertices);
        int real_arrival_vertex   = int(num_vertices);
        for (std::map<int, int>::const_iterator itr = cycle.begin();
             itr != cycle.end(); ++itr) {
          int j = itr->first;

          double departure_score = score_matrix[j][i];
          if (-1 < departure_score &&
              max_departure_score <= departure_score) {
            max_departure_score = departure_score;
            real_departure_vertex = j;
          }

          double in_score = score_matrix[i][j];
          if (-1 < in_score) {
            double arrival_score =
              cycle_weight + in_score - score_matrix[front[j]][j];
            if (max_arrival_score < arrival_score) {
              max_arrival_score = arrival_score;
              real_arrival_vertex = j;
            }
          }
        }

        if (-1 < max_departure_score) {
          score_matrix[cycle_representing_vertex][i] = max_departure_score;
          real_departure_vertices[i] = real_departure_vertex;
        }
        if (-1 < max_arrival_score) {
          score_matrix[i][cycle_representing_vertex] = max_arrival_score;
          real_arrival_vertices[i] = real_arrival_vertex;
        }
      }
    }

    for (std::map<int, int>::const_iterator i = cycle.begin();
         i != cycle.end(); i++) {
      if (i->first != cycle_representing_vertex) {
        current_vertices[i->first] = 0;
      }
    }

    // for (size_t j = 0; j < num_vertices; j++) {
    //   if (0 < current_vertices[j]) {
    //     for (size_t i = 0; i < num_vertices; i++) {
    //       if (0 < current_vertices[i]) {
    //         std::cout << "s(" << j << " -> " << i << ") = "
    //                   << score_matrix[j][i] << std::endl;
    //       }
    //     }
    //   }
    // }
    // std::cout << std::endl;

    EdgeList edges;
    ChuLiuEdmonds(num_vertices, score_matrix, current_vertices, &edges);

    if (edges.size() == 0) {
      // cycle󤵤ưΤߤΥդˤʤäƤ
      double min_score = 0;
      int min_score_edge_front = -1;
      for (std::map<int, int>::const_iterator i = cycle.begin();
           i != cycle.end(); i++) {
        double score = score_matrix[i->first][i->second];
        if (min_score_edge_front == -1 || score < min_score) {
          min_score = score;
          min_score_edge_front = i->first;
        }
      }
      for (std::map<int, int>::const_iterator i = cycle.begin();
           i != cycle.end(); i++) {
        if (i->first != min_score_edge_front) {
          final_edges->push_back(std::pair<int, int>(i->first, i->second));
          //std::cerr << i->first << " => " << i->second << std::endl;
        }
      }
    } else {
      std::set<int> rear_list;
      for (EdgeList::const_iterator it = edges.begin(); it != edges.end();
           ++it) {
        int front = it->first, rear = it->second;
        if (front == cycle_representing_vertex) {
          front = real_departure_vertices[rear];
        }
        if (rear == cycle_representing_vertex) {
          rear = real_arrival_vertices[front];
        }
        final_edges->push_back(std::pair<int, int>(front, rear));
        rear_list.insert(rear);
      }

      for (std::map<int, int>::const_iterator i = cycle.begin();
           i != cycle.end(); i++) {
        if (rear_list.find(i->second) == rear_list.end()) {
          final_edges->push_back(std::pair<int, int>(i->first, i->second));
          // std::cerr << i->first << " => " << i->second << std::endl;
        }
      }
    }
    // std::cerr << std::endl;
  }
}
