#ifndef PARSER_LEARNER_INTERFACE_HPP_
#define PARSER_LEARNER_INTERFACE_HPP_

#include <map>
#include <vector>
#include <cstdlib>
#include <iostream>
#include <algorithm>
#include "string_indexer.hpp"

namespace maeda {

// 
struct Feature;

struct FeatureNode;

// ҤȤޤȤˤ
class FeatureVector;

typedef std::vector<FeatureVector> FeatureVectorList;

// νŤ
typedef std::vector<double> WeightMap;

class ParserLearnerInterface;


struct Feature {
  // λ̾
  FeatureID id;
  // λ
  double value;

  Feature(const FeatureID feature_id, const double &feature_value)
    : id(feature_id), value(feature_value) {}
};


class FeatureVector : public std::vector<Feature> {
public:
  // for debug
  void _show() const {
    for (size_t i = 0; i < this->size(); i++) {
      std::cerr << (*this)[i].id << " " << (*this)[i].value << std::endl;
    }
    std::cerr << std::endl;
  }

  void _show(const StringIndexer &string_indexer) const {
    for (size_t i = 0; i < this->size(); i++) {
      std::cerr << string_indexer.GetStr( (*this)[i].id )
                << " " << (*this)[i].value << std::endl;
    }
    std::cerr << std::endl;
  }

  // FeatureФơ
  // ŤߴؿνͤvalueȤݤ碌¤Ȥ
  double Product(const WeightMap &weight) const {
    const int size = int(weight.size());
    double sum = 0.0;
    for (std::vector<Feature>::const_iterator it = this->begin();
         it != this->end(); ++it) {
      if (0 <= it->id && it->id < size) {
        sum += it->value * weight[it->id];
      } else {
        std::cerr << "Error: invalid feature id: " << it->id << std::endl;
        std::exit(1);
      }
    }
    return sum;
  }
};


class ParserLearnerInterface {
public:

  virtual void Learn( 
    const std::vector<FeatureVectorList > *feature_vector_list_list,
    const std::vector<int> *real_target_list,
    WeightMap *weight) = 0;

protected:
  ParserLearnerInterface() {}
  virtual ~ParserLearnerInterface() {}
};


} // maeda


#endif // PARSER_LEARNER_INTERFACE_HPP_
