#ifndef MODEL_HPP_
#define MODEL_HPP_

#include <vector>
#include "liblinear-1.91/linear.h"
#include "string_indexer.hpp"
#include "unlabeled_edge_feature_extractor_interface.hpp"
#include "edge_label_feature_extractor_interface.hpp"
#include "parser_learner_interface.hpp"

namespace maeda {

typedef std::basic_string<FeatureID> IDString;


class EdgeLabelModel {
public:
  EdgeLabelModel();
  EdgeLabelModel(
      const EdgeLabelFeatureExtractorInterface* const extractor);

  bool Train(const std::vector<Sentence> &sentence_list);

  void Save(const std::string &filename) const;

  void Load(const std::string &filename);

  void LabelEdges(Sentence *sentence);

private:
  std::vector<std::string> feature_string_list_;

  std::vector<std::string> gold_standard_label_list_;

  const EdgeLabelFeatureExtractorInterface *extractor_;

  StringIndexer feature_indexer_;

  StringIndexer label_indexer_;

  struct model* model_;
};


class UnlabeledParseModel {
 public:
   UnlabeledParseModel();
   UnlabeledParseModel(
       const UnlabeledEdgeFeatureExtractorInterface* const extractor,
       const bool &left_to_right);

  bool Train(const std::vector<Sentence> &sentence_list,
             ParserLearnerInterface *learner,
             const int cutoff);

  void Save(const std::string &filename) const;

  void Load(const std::string &filename);

  void ParseSentenceWithMST(const bool &named_entity_p,
                            Sentence *sentence) const;

  void SaveFeatureVectors(const std::string &filename) const;

 private:
  // feature extractor
  const UnlabeledEdgeFeatureExtractorInterface *extractor_;

  bool left_to_right_;

   // feature string <-> id
  StringIndexer feature_indexer_;
  // feature weights
  WeightMap weight_;
};


class LabeledParseModel; // to be written later...


} // maeda

 #endif // MODEL_HPP_
