#ifndef LBFGS_HPP_PARSER_LEARNER_HPP_
#define LBFGS_HPP_PARSER_LEARNER_HPP_

#include <vector>
#include "parser_learner_interface.hpp"
#include "LBFGS.hpp"

namespace maeda {

// LBFGSȤᡢ餫Ƥ
class LBFGS_HPP_Learner;

// weight_map_training
class LBFGS_HPP_ParserLearner : public ParserLearnerInterface {
public:
  LBFGS_HPP_ParserLearner(const double &C);

  void Learn(
    const std::vector<FeatureVectorList > *feature_vector_list_list,
    const std::vector<int> *gold_standard_index_list,
    WeightMap *weight_map);

  // LBFGS.hppɬ
  double operator()(const std::vector<double> &x, std::vector<double> &grad);
private:
  double C_;

  const std::vector<FeatureVectorList>* feature_vector_list_list_;

  const std::vector<int>* gold_standard_index_list_;

  WeightMap *weight_;

  WeightMap weight_by_training_data_;

  LBFGS<LBFGS_HPP_ParserLearner, double> *solver_;

  void ShowStatistics() const;
};


} // maeda


#endif // LBFGS_HPP_PARSER_LEARNER_HPP_
