#include "yaccgenvisitor1.h"
#include "ast.h"
#include "strutils.h"

#include <assert.h>

using std::vector;
using std::string;
using std::set;

yaccgenvisitor1::yaccgenvisitor1(const char* yaccFilename, const char* astFilename)
	: m_out(yaccFilename)
	, m_yaccFilename(yaccFilename)
	, m_astFilename(astFilename)
{
	m_out << "%{\n";
	m_out << "#include \"" << astFilename << "\"\n";
	m_out << "%}\n";
}

yaccgenvisitor1::~yaccgenvisitor1()
{
	for (set<string>::const_iterator i = m_tokenset.begin();
		  i != m_tokenset.end();
		  ++i)
	{
		m_out << "%token " << *i << "\n";
	}
	m_out << "\n";
	m_out << "%union {\n";
	for (vector<string>::const_iterator i = m_rules.begin();
		  i != m_rules.end();
		  ++i)
	{
		if (endsWithList(*i))
			m_out << "\t" << "std::list<" << getListType(*i) << "*>* p" <<
				*i << ";\n";
		else if (!beginsWithStr(*i))
			m_out << "\t" << *i << "* p" << *i << ";\n";
	}
	m_out << "	std::string* pstring;\n";
	m_out << "}\n\n";

	for (vector<string>::const_iterator i = m_rules.begin();
		  i != m_rules.end();
		  ++i)
	{
		if (!beginsWithStr(*i))
			m_out << "%type <p" << *i << "> " << *i << "\n";
	}
	m_out << "%type <pstring> ";
	for (vector<string>::const_iterator i = m_rules.begin();
		  i != m_rules.end();
		  ++i)
	{
		if (beginsWithStr(*i))
			m_out << *i << " ";
	}
	for (set<string>::const_iterator i = m_tokenset.begin();
		  i != m_tokenset.end();
		  ++i)
	{
		m_out << *i << " ";
	}
	m_out << "\n\n%%\n\n";
}

void yaccgenvisitor1::visit_lhs_IDENT_SEPARATOR(const lhs_IDENT_SEPARATOR *plhs_IDENT_SEPARATOR)
{
	m_rulename = *plhs_IDENT_SEPARATOR->m_IDENT;
	m_rules.push_back(m_rulename);
}

void yaccgenvisitor1::visit_grammar_grammar_production(const grammar_grammar_production *pgrammar_grammar_production)
{
	if (pgrammar_grammar_production->m_grammar.get() == 0) // start of the AST
	{
	}
	else
	{
		pgrammar_grammar_production->m_grammar->accept(this);
	}
	pgrammar_grammar_production->m_production->accept(this);

}

void yaccgenvisitor1::visit_grammar_grammar_COMMENT(const grammar_grammar_COMMENT *pgrammar_grammar_COMMENT)
{
	return;
}

void yaccgenvisitor1::visit_expression_base_OPT(const expression_base_OPT *pexpression_base_OPT)
{
	// not yet implemented
	assert(0);
	pexpression_base_OPT->m_base->accept(this);
}

void yaccgenvisitor1::visit_production_lhs_expressionListList_TERMINATOR(const production_lhs_expressionListList_TERMINATOR *pproduction_lhs_expressionListList_TERMINATOR)
{
	pproduction_lhs_expressionListList_TERMINATOR->m_lhs->accept(this);
	if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList.get() != 0)
	{
		vector<vector<expression*>*>::const_iterator i = pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin();
		if (endsWithList(m_rulename))
		{
			if (*i)
			{
				vector<expression*>::const_iterator j = (*i)->begin();
				if (j != (*i)->end())
				{
					(*j)->accept(this); // fills out m_ident
					if (beginsWithStr(m_ident))
						addListType(m_rulename, "std::string");
					else
						addListType(m_rulename, m_ident);
				}
			}
		}
		for (; i != pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->end();
			  ++i)
		{
			if (*i)
			{
				for (vector<expression*>::const_iterator j = (*i)->begin();
					  j != (*i)->end();
					  ++j)
				{
					(*j)->accept(this);
				}
			}
		}
	}
}

void yaccgenvisitor1::visit_expression_base_PLUS(const expression_base_PLUS *pexpression_base_PLUS)
{
	// not yet implemented
	assert(0);
	pexpression_base_PLUS->m_base->accept(this);
}

void yaccgenvisitor1::visit_expression_base(const expression_base *pexpression_base)
{
	pexpression_base->m_base->accept(this);
}

void yaccgenvisitor1::visit_base_LITERAL(const base_LITERAL *pbase_LITERAL)
{
	m_literal = *pbase_LITERAL->m_LITERAL;
}

void yaccgenvisitor1::visit_expression_base_STAR(const expression_base_STAR *pexpression_base_STAR)
{
	// not yet implemented
	assert(0);
	pexpression_base_STAR->m_base->accept(this);
}

void yaccgenvisitor1::visit_base_LPAREN_expressionList_RPAREN(const base_LPAREN_expressionList_RPAREN *pbase_LPAREN_expressionList_RPAREN)
{
	// not yet implemented
	assert(0);
	if (pbase_LPAREN_expressionList_RPAREN->m_expressionList.get() != 0)
	{
		for (vector<expression*>::const_iterator i = pbase_LPAREN_expressionList_RPAREN->m_expressionList->begin();
			  i != pbase_LPAREN_expressionList_RPAREN->m_expressionList->end();
			  ++i)
		{
			(*i)->accept(this);
		}
	}
}

void yaccgenvisitor1::visit_expression_COMMENT(const expression_COMMENT *pexpression_COMMENT)
{
	// not yet implemented
	assert(0);
	(void)pexpression_COMMENT->m_COMMENT;
}

void yaccgenvisitor1::visit_alternation_expression_OR_expression(const alternation_expression_OR_expression *palternation_expression_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_expression_OR_expression->m_expression1->accept(this);
	palternation_expression_OR_expression->m_expression2->accept(this);
}

void yaccgenvisitor1::visit_base_IDENT(const base_IDENT *pbase_IDENT)
{
	m_ident = *pbase_IDENT->m_IDENT;
	if (isAllCaps(m_ident))
	{
		m_tokenset.insert(m_ident);
	}
}

void yaccgenvisitor1::visit_base_LPAREN_alternation_RPAREN(const base_LPAREN_alternation_RPAREN *pbase_LPAREN_alternation_RPAREN)
{
	// not yet implemented
	assert(0);
	pbase_LPAREN_alternation_RPAREN->m_alternation->accept(this);
}

void yaccgenvisitor1::visit_alternation_alternation_OR_expression(const alternation_alternation_OR_expression *palternation_alternation_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_alternation_OR_expression->m_alternation->accept(this);
	palternation_alternation_OR_expression->m_expression->accept(this);
}


