#ifndef VISITOR_H_
#define VISITOR_H_

class grammar_grammar_production;
class grammar_grammar_COMMENT;
class production_lhs_expressionListList_TERMINATOR;
class lhs_IDENT_SEPARATOR;
class expression;
class expression_base;
class expression_base_OPT;
class expression_base_STAR;
class expression_base_PLUS;
class expression_COMMENT;
class base_LITERAL;
class base_IDENT;
class base_LPAREN_expressionList_RPAREN;
class base_LPAREN_alternation_RPAREN;
class alternation_expression_OR_expression;
class alternation_alternation_OR_expression;

class visitor
{
	public:
		virtual ~visitor() {}

		virtual void visit_grammar_grammar_production(
				const grammar_grammar_production* pgrammar_grammar_production ) = 0;

		virtual void visit_grammar_grammar_COMMENT(
				const grammar_grammar_COMMENT* pgrammar_grammar_COMMENT ) = 0;

		virtual void visit_production_lhs_expressionListList_TERMINATOR(
				const production_lhs_expressionListList_TERMINATOR*
				pproduction_lhs_expressionListList_TERMINATOR ) = 0;

		virtual void visit_lhs_IDENT_SEPARATOR(
				const lhs_IDENT_SEPARATOR* plhs_IDENT_SEPARATOR ) = 0;

		virtual void visit_expression_base(
				const expression_base* pexpression_base ) = 0;

		virtual void visit_expression_base_OPT(
				const expression_base_OPT* pexpression_base_OPT ) = 0;

		virtual void visit_expression_base_STAR(
				const expression_base_STAR* pexpression_base_STAR ) = 0;

		virtual void visit_expression_base_PLUS(
				const expression_base_PLUS* pexpression_base_PLUS ) = 0;

		virtual void visit_expression_COMMENT(
				const expression_COMMENT* pexpression_COMMENT ) = 0;

		virtual void visit_base_LITERAL(
				const base_LITERAL* pbase_LITERAL ) = 0;

		virtual void visit_base_IDENT(
				const base_IDENT* pbase_IDENT ) = 0;

		virtual void visit_base_LPAREN_expressionList_RPAREN(
				const base_LPAREN_expressionList_RPAREN*
				pbase_LPAREN_expressionList_RPAREN ) = 0;

		virtual void visit_base_LPAREN_alternation_RPAREN(
				const base_LPAREN_alternation_RPAREN*
				pbase_LPAREN_alternation_RPAREN ) = 0;

		virtual void visit_alternation_expression_OR_expression(
				const alternation_expression_OR_expression*
				palternation_expression_OR_expression ) = 0;

		virtual void visit_alternation_alternation_OR_expression(
				const alternation_alternation_OR_expression*
				palternation_alternation_OR_expression ) = 0;



};


#endif

