#include "traversalcppgenvisitor.h"
#include "visitor.h"
#include "ast.h"
#include "strutils.h"

#include <assert.h>

using std::vector;
using std::string;


traversalcppgenvisitor::traversalcppgenvisitor(const char* filename, const char* traversalhppFilename, const char* astFilename)
	: m_out(filename)
{
	m_out << "#include \"" << traversalhppFilename << "\"\n";
	m_out << "#include \"" << astFilename << "\"\n\n";
}

traversalcppgenvisitor::~traversalcppgenvisitor()
{
}

void traversalcppgenvisitor::visit_lhs_IDENT_SEPARATOR(const lhs_IDENT_SEPARATOR *plhs_IDENT_SEPARATOR)
{
	m_rulename = *plhs_IDENT_SEPARATOR->m_IDENT;
}

void traversalcppgenvisitor::visit_grammar_grammar_production(const grammar_grammar_production *pgrammar_grammar_production)
{
	if (pgrammar_grammar_production->m_grammar.get() != 0)
	{
		pgrammar_grammar_production->m_grammar->accept(this);
	}
	pgrammar_grammar_production->m_production->accept(this);

}

void traversalcppgenvisitor::visit_grammar_grammar_COMMENT(const grammar_grammar_COMMENT *pgrammar_grammar_COMMENT)
{
	return;
}

void traversalcppgenvisitor::visit_expression_base_OPT(const expression_base_OPT *pexpression_base_OPT)
{
	// not yet implemented
	assert(0);
	pexpression_base_OPT->m_base->accept(this);
}

void traversalcppgenvisitor::visit_production_lhs_expressionListList_TERMINATOR(const production_lhs_expressionListList_TERMINATOR *pproduction_lhs_expressionListList_TERMINATOR)
{
	pproduction_lhs_expressionListList_TERMINATOR->m_lhs->accept(this);

	// m_rulename has already been set
	if (!isSpecialRule(m_rulename))
	{
		if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList.get() != 0)
		{
			if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->size() > 1)
			{
				for (vector<vector<expression*>*>::const_iterator i = pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin();
					  i != pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->end();
					  ++i)
				{
					if (*i)
					{
						write_traversal(i);
					}
				}
			}
			else
			{
				vector<vector<expression*>*>::const_iterator i = pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin();
				write_traversal_simple(i);
				/*
				string classname = m_rulename;
				m_out << "void traversalvisitor::visit_" << classname << "(\n";
				m_out << "\tconst " << classname << "* p" << classname << "\n";
				m_out << "\t)\n";
				m_out << "{\n";
				m_out << "}\n\n";
				*/
			}
		}
	}
	if (endsWithList(m_rulename))
	{
		if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList.get() != 0)
		{
			if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->size() > 1)
			{
				vector<vector<expression*>*>::const_iterator i =  pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin();
				if ((*i)->size() > 0 && *(*i)->begin())
				{
					(*(*i)->begin())->accept(this); // fills out m_ident
					if (beginsWithStr(m_ident))
						addListType(m_rulename, "std::string");
					else
						addListType(m_rulename, m_ident);
				}
			}
		}
	}

}

void traversalcppgenvisitor::write_traversal(vector<vector<expression*>*>::const_iterator rule)
{
	// first build up the classname and gather the idents
	string classname = m_rulename;
	vector<string> idents;
	for (vector<expression*>::const_iterator j = (*rule)->begin();
		  j != (*rule)->end();
		  ++j)
	{
		m_literal.erase();
		m_ident.erase();
		(*j)->accept(this);
		if (m_ident.length() > 0)
		{
			classname += "_" + m_ident;
			idents.push_back(m_ident);
		}
	}
	if ((*rule)->size() == 0)
	{
		classname += "_empty";
	}

	write_traversal_common(classname, idents);

}

void traversalcppgenvisitor::write_traversal_simple(vector<vector<expression*>*>::const_iterator rule)
{
	// first build up the classname and gather the idents
	string classname = m_rulename;
	vector<string> idents;
	for (vector<expression*>::const_iterator j = (*rule)->begin();
		  j != (*rule)->end();
		  ++j)
	{
		m_literal.erase();
		m_ident.erase();
		(*j)->accept(this);
		if (m_ident.length() > 0)
		{
			idents.push_back(m_ident);
		}
	}

	write_traversal_common(classname, idents);
}

void traversalcppgenvisitor::write_traversal_common(const std::string& classname, const std::vector<std::string>& idents)
{
	m_out << "void Processor::visit_" << classname << "(\n";
	m_out << "\tconst " << classname << "* p" << classname << "\n";
	m_out << "\t)\n";
	m_out << "{\n";
	bool unusedParameter = true;
	for (vector<string>::const_iterator i = idents.begin();
			i != idents.end();
			++i)
	{
		if (beginsWithStr(*i))
		{
		}
		else if (endsWithList(*i))
		{
			unusedParameter = false;
			if (beginsWithOpt(*i))
			{
				m_out << "\tif (p" << classname << "->m_p" << *i <<
					i - idents.begin() + 1 << ")\n";
				m_out << "\t{\n";
				m_out << "\t\tfor (std::list<" << getListType(*i)
					<< "*>::const_iterator i = p" << classname
					<< "->m_p" << *i << i - idents.begin() + 1 << "->begin();\n";
				m_out << "\t\t\ti != p" << classname << "->m_p" << 
					*i << i - idents.begin() + 1 << "->end();\n";
				m_out << "\t\t\t++i )\n";

				if (beginsWithOpt(getListType(*i)))
				{
					m_out << "\t\t{\n";
					m_out << "\t\t\tif (*i)\n";
					m_out << "\t\t\t\t(*i)->accept(this);\n";
					m_out << "\t\t}\n";
				}
				else
				{
					m_out << "\t\t\t(*i)->accept(this);\n";
				}
				m_out << "\t}\n";
			}
			else
			{
				m_out << "\tfor (std::list<" << getListType(*i)
					<< "*>::const_iterator i = p" << classname
					<< "->m_p" << *i << i - idents.begin() + 1 << "->begin();\n";

				bool isString = getListType(*i) == "std::string";

				m_out << "\t\ti != p" << classname << "->m_p" 
					<< *i << i - idents.begin() + 1 << "->end();\n";
				m_out << "\t\t++i )\n";

				m_out << "\t{\n";
				if (beginsWithOpt(getListType(*i)))
				{
					m_out << "\t\tif (*i)\n";
					m_out << "\t\t{\n";
					if (!isString)
					{
						m_out << "\t\t\t(*i)->accept(this);\n";
					}
					m_out << "\t\t}\n";
				}
				else
				{
					if (!isString)
					{
						m_out << "\t\t(*i)->accept(this);\n";
					}
				}
				m_out << "\t}\n";

			}
		}
		else if (isAllCaps(*i))
		{
		}
		else
		{
			unusedParameter = false;
			if (beginsWithOpt(*i))
			{
				m_out << "\tif (p" << classname << "->m_p" << *i <<
					i - idents.begin() + 1 << ")\n";
					
				m_out << "\t\tp" << classname << "->m_p" << *i <<
					i - idents.begin() + 1 << "->accept(this);\n";
			}
			else
			{
				m_out << "\tp" << classname << "->m_p" << *i <<
					i - idents.begin() + 1 << "->accept(this);\n";
			}
		}

	}
	if (unusedParameter)
	{
		m_out << "\t(void)p" << classname << ";\n";
	}

	m_out << "}\n\n";

}

void traversalcppgenvisitor::visit_expression_base_PLUS(const expression_base_PLUS *pexpression_base_PLUS)
{
	// not yet implemented
	assert(0);
	pexpression_base_PLUS->m_base->accept(this);
}

void traversalcppgenvisitor::visit_expression_base(const expression_base *pexpression_base)
{
	pexpression_base->m_base->accept(this);
}

void traversalcppgenvisitor::visit_base_LITERAL(const base_LITERAL *pbase_LITERAL)
{
	m_literal = *pbase_LITERAL->m_LITERAL;
}

void traversalcppgenvisitor::visit_expression_base_STAR(const expression_base_STAR *pexpression_base_STAR)
{
	// not yet implemented
	assert(0);
	pexpression_base_STAR->m_base->accept(this);
}

void traversalcppgenvisitor::visit_base_LPAREN_expressionList_RPAREN(const base_LPAREN_expressionList_RPAREN *pbase_LPAREN_expressionList_RPAREN)
{
	// not yet implemented
	assert(0);
	if (pbase_LPAREN_expressionList_RPAREN->m_expressionList.get() != 0)
	{
		for (vector<expression*>::const_iterator i = pbase_LPAREN_expressionList_RPAREN->m_expressionList->begin();
			  i != pbase_LPAREN_expressionList_RPAREN->m_expressionList->end();
			  ++i)
		{
			(*i)->accept(this);
		}
	}
}

void traversalcppgenvisitor::visit_expression_COMMENT(const expression_COMMENT *pexpression_COMMENT)
{
	// not yet implemented
	assert(0);
	(void)pexpression_COMMENT->m_COMMENT;
}

void traversalcppgenvisitor::visit_alternation_expression_OR_expression(const alternation_expression_OR_expression *palternation_expression_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_expression_OR_expression->m_expression1->accept(this);
	palternation_expression_OR_expression->m_expression2->accept(this);
}

void traversalcppgenvisitor::visit_base_IDENT(const base_IDENT *pbase_IDENT)
{
	m_ident = *pbase_IDENT->m_IDENT;
}

void traversalcppgenvisitor::visit_base_LPAREN_alternation_RPAREN(const base_LPAREN_alternation_RPAREN *pbase_LPAREN_alternation_RPAREN)
{
	// not yet implemented
	assert(0);
	pbase_LPAREN_alternation_RPAREN->m_alternation->accept(this);
}

void traversalcppgenvisitor::visit_alternation_alternation_OR_expression(const alternation_alternation_OR_expression *palternation_alternation_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_alternation_OR_expression->m_alternation->accept(this);
	palternation_alternation_OR_expression->m_expression->accept(this);
}


