%{
#include "test2ast.h"
%}
%token COMMENT
%token IDENT
%token LITERAL
%token LPAREN
%token OPT
%token OR
%token PLUS
%token RPAREN
%token SEPARATOR
%token STAR
%token TERMINATOR

%union {
	grammar* pgrammar;
	production* pproduction;
	lhs* plhs;
	std::list<expressionList*>* pexpressionListList;
	std::list<*>* pexpressionList;
	expression* pexpression;
	base* pbase;
	alternation* palternation;
	std::string* pstring;
}

%type <pgrammar> grammar
%type <pproduction> production
%type <plhs> lhs
%type <pexpressionListList> expressionListList
%type <pexpressionList> expressionList
%type <pexpression> expression
%type <pbase> base
%type <palternation> alternation
%type <pstring> COMMENT IDENT LITERAL LPAREN OPT OR PLUS RPAREN SEPARATOR STAR TERMINATOR 

%%



grammar:
	production 
	  { $$ = new grammar_production($1) }
	| grammar production 
	  { $$ = new grammar_grammar_production($1, $2) }
	| grammar COMMENT 
	  { $$ = new grammar_grammar_COMMENT($1, $2) }


production:
	lhs expressionListList TERMINATOR 
	  { $$ = new production($1, $2, $3) }


lhs:
	IDENT SEPARATOR 
	  { $$ = new lhs($1, $2) }


expressionListList:
	expressionList 
	  { $$ = new std::list<expressionList*>(1, $1) }
	| expressionListList OR expressionList 
	  { $1->push_back($3); delete $2; $$ = $1; }


expressionList:
	/* EMPTY */
	  { $$ = new std::list<*>() }
	| expressionList expression 
	  { $1->push_back($2); $$ = $1; }


expression:
	base 
	  { $$ = new expression_base($1) }
	| base OPT 
	  { $$ = new expression_base_OPT($1, $2) }
	| base STAR 
	  { $$ = new expression_base_STAR($1, $2) }
	| base PLUS 
	  { $$ = new expression_base_PLUS($1, $2) }
	| COMMENT 
	  { $$ = new expression_COMMENT($1) }


base:
	LITERAL 
	  { $$ = new base_LITERAL($1) }
	| IDENT 
	  { $$ = new base_IDENT($1) }
	| LPAREN expressionList RPAREN 
	  { $$ = new base_LPAREN_expressionList_RPAREN($1, $2, $3) }
	| LPAREN alternation RPAREN 
	  { $$ = new base_LPAREN_alternation_RPAREN($1, $2, $3) }


alternation:
	expression OR expression 
	  { $$ = new alternation_expression_OR_expression($1, $2, $3) }
	| alternation OR expression 
	  { $$ = new alternation_alternation_OR_expression($1, $2, $3) }
