#!/bin/sh
echo "Running acceptance.sh"
TESTSDIR=`pwd`
BUILDDIR=${TESTSDIR}/..
TOPSRCDIR=@top_srcdir@
SRCTESTSDIR=${TOPSRCDIR}/tests

for x in 1 2; do
	echo "Running Test $x"
	(${BUILDDIR}/ebnf2yacc ${SRCTESTSDIR}/test${x}.e2y test${x}visitor.h test${x}ast.h test${x}yacc.y test${x}tv.h test${x}tv.cpp 2>&1) > ebnf2yacc.${x}.out || exit 1
	echo "diff test${x}visitor.h ${SRCTESTSDIR}/test${x}visitor.h || exit 1"
	diff test${x}visitor.h ${SRCTESTSDIR}/test${x}visitor.h || exit 1
	echo "diff test${x}ast.h ${SRCTESTSDIR}/test${x}ast.h || exit 1"
	diff test${x}ast.h ${SRCTESTSDIR}/test${x}ast.h || exit 1
	echo "diff test${x}yacc.y ${SRCTESTSDIR}/test${x}yacc.y || exit 1"
	diff test${x}yacc.y ${SRCTESTSDIR}/test${x}yacc.y || exit 1
	echo "diff test${x}tv.h ${SRCTESTSDIR}/test${x}tv.h || exit 1"
	diff test${x}tv.h ${SRCTESTSDIR}/test${x}tv.h || exit 1
	echo "diff test${x}tv.cpp ${SRCTESTSDIR}/test${x}tv.cpp || exit 1"
	diff test${x}tv.cpp ${SRCTESTSDIR}/test${x}tv.cpp || exit 1
done


echo "Success"
exit 0
