#include "ast.h"
#include "astgenvisitor1.h"
#include "astgenvisitor2.h"
#include "visitorgenvisitor1.h"
#include "visitorgenvisitor2.h"
#include "yaccgenvisitor1.h"
#include "yaccgenvisitor2.h"
#include "traversalhppgenvisitor.h"
#include "traversalcppgenvisitor.h"
#include <stdio.h>
#include <iostream>

using std::cout;
using std::endl;

grammar* g_grammar;
int line_num = 0;
int yyparse();
extern FILE* yyin;

void usage()
{
	cout << "Usage: <input grammar> <visitor file> <ast file> <yacc file> <traversal visitor header file> <traversal visitor cpp file>\n";
}

int main(int argc, char** argv)
{
	if (argc != 7)
	{
		usage();
		return 1;
	}

	yyin = fopen(argv[1], "rt");
	if (!yyin)
	{
		cout << "Error: could not open file: " << argv[1] << endl;
		usage();
		return 1;
	}

	yyparse();

	{
		astgenvisitor1 astv(argv[3], argv[2]);
		g_grammar->accept(&astv);
	}
	{
		astgenvisitor2 astv(argv[3], argv[2]);
		g_grammar->accept(&astv);
	}
	{
		visitorgenvisitor1 visitorv1(argv[2]);
		g_grammar->accept(&visitorv1);
	}
	{
		visitorgenvisitor2 visitorv2(argv[2]);
		g_grammar->accept(&visitorv2);
	}
	{
		yaccgenvisitor1 yaccv1(argv[4], argv[3]);
		g_grammar->accept(&yaccv1);
	}
	{
		yaccgenvisitor2 yaccv2(argv[4], argv[3]);
		g_grammar->accept(&yaccv2);
	}
	{
		traversalhppgenvisitor tvhv(argv[5], argv[2]);
		g_grammar->accept(&tvhv);
	}
	{
		traversalcppgenvisitor tvcv(argv[6], argv[5], argv[3]);
		g_grammar->accept(&tvcv);
	}

	return 0;
}

