.TH dwarf-ng 1 "(c) 2007-2013-2017 Fernando Iazeolla"
.SH NAME
dwarf-ng - a little and powerful object file manipulation tool and hex editor.
.SH SYNOPSIS
.B dwarf [ options ] [ file ]
.SH DESCRIPTION
.B dwarf-ng
is a powerful object file manipulation tool and hex editor in the spirit of \fIgdb\fP. with \fIdwarf-ng\fP you can read and edit all the file's section headers as well as the raw data. With \fIdwarf-ng\fP you can create and customize new file's header and it can be used as a compiler back-end to create executables/object files. \fIdwarf-ng\fP also permits to inject easily new headers and pieces of code/data into the file.
\fIdwarf-ng\fP currently handles \fIRaw\fP, \fIelf\fP (Elf32 and Elf64), \fIPE\fP (Portable executables, PE32 and PE+) and \fIMach-O (32 and 64 bit)\fP files format. In the future new files type will be added.
.SH OPTIONS
.TP
.B -s, --stdin
file from stdin
.TP
.B -i, --shell --interactive
interactive (shell mode)
.TP
.B -h, --help
show this help
.TP
.B -c '<commands>', --command '<commands>'
command  mode (execute commands)
.P
For example,
.B dwarf -c 'print 2+2'
will output:
4
.TP
.B -e '<commands>', --command '<commands>'
command  mode alias (execute commands)
.TP
.B -x <file>, --execute <file>
execute file script
.TP
.B -v, --version
show dwarf-ng's version number
.TP
.B -f <file>, --file <file>
open file
.TP
.B -p, --probe
probe file and print file type and info
.TP
.B -C [n], --colors [n]
colored output (n=theme num (optional))
.TP
.B -B, --nocolors
nocolored output
.TP
.B -T [n], --theme [n]
theme 2 colored output (n=theme num (optional))
.TP
.B -W, --work-on-copy
work on copy file
.TP
.B -P, --no-work-on-copy
no work on copy file
.TP
.B -D <name>, --tmpdir <name>
set tmp dir path
.TP
.B -N <name>, --tmpname <name>
set tmp filename
.TP
.B -s <offs>, --seek <offs>
set seek offset
.TP
.B -b <size>, --block <size>
set block size
.TP
If more than one or all options are given at the same time the execution order will be: 1)open the file in the command line, 2)loads file structures, 3)execute the script file(-x), 4)executes commands from command line(-c), 5)enter the shell(-i)
.SH THE DWARF'S LANGUAGE
.TP 
.B COMMAND SEPARATOR
the command separator is the semicolon character '\fB;\fP' .
{cmd};{cmd}
.TP
.B COMMENTS
a comment begins with the '#' symbol and ends at the end of the line (CRLF)
.TP
.B VARIABLES
.B dwarf-ng 
recognizes two types of variables: the normal variables (simply called variables) and the structured variables.
The normal \fBvariables\fP are litteral words and are created by the user for normal variable operation (\fIi.e. a=5; b=a+3; print b\fP ).
The \fBstructured variables\fP are created by \fBdwarf\fP when it loads a file into memory and are preceded by the dollar symbol (\fB$\fP). The structured variables reflects the opened file structure and they depends on the file type opened. So, for example,  the Elf structured variables are different from the PE structured variables. Structured variables can be accessed in read or write mode like the normal variables. Structured variables syntax is similar to a C struct:
\fIprint $elf::ph_num\fP will print the ph_num variable of the main header ($elf) of a Elf file.
\fI$elf::sh_num=3\fP will modify the sh_num (number of section headers) in the main header ($elf) of the Elf file.
.TP
.B EXPRESSIONS
Expressions \fBEXPR\fP are in the form : EXPR + EXPR, or EXPR - EXPR, or EXPR * EXPR, or EXPR / EXPR, or EXPR %EXPR. a single expression item can be a number (in decimal or hex form 10=0xa) or an offset. hex values are preceded by a \fB0x\fP...example: a=0x10 (a is 16 decimal!).
.TP
.B OFFSETS
offsets syntax is \fI @foo< \fP or \fI @foo> \fP where \fIfoo\fP is a symbol referring to a specific file data structure. The major (>) or minor (<) symbol indicate if the offset point to the end (>) or the beginning (<) of the specified data structure. whith \fB@<\fP we indicate the beginning of the file. Whith \fB@>\fP wh indicate the end of the file. For example \fIprint @>\fP will output the lenth of the file. Offsets return an integer and can be combined in any expressions EXPR (i.e. a=@>+3 will assign to the variable a the length of the file plus 3).
.SH GENERAL COMMANDS
.TP
.B MAIN COMMANDS SECTION
 Append '?' to any char command to get detailed help.
 general command syntax:
 command[?][+] [%nx] [data] [offset]    n=times,x=format
 | ?                this help
 | q                exit dwarf-ng interpreter
 | i                show file info and headers info.
 | o[?]             open/opened file commands.
 | b[?]             See / change block size.
 | s[?] [addr]      seek to address.
 | e[?]             show config vars.
 | M[?]             move block of file around.
 | p[?]             print commands.
 | x[?]             just an alias for px (print hex).
 | w[?]             write operations.
 | S[?]             section headers operations.
 | !'commands'      execute commands into shell (bash).
.TP
.B open/opened file commands
 open/opened files commands:
 | o [%x] file               open file (o foo) (o %%w foo)(x=w write-on-copy, x=f no write-on-copy).
 | oc                        close opened file.
 | ol                        show opened files list.
 | os                        show opened file size.
 | ou  n                     switch to opened file number n
 | oR  [+ -]n                resize opened file of [+ -]n bytes.
 | oR+ n                     increaes size of opened file of n bytes.
 | oR- n                     decreasesize of opened file of n bytes.
 | oS [filename]             save file (to filename).
 | oT type                   change file type to 'type' (oT elf).
 | oN [%x] [filename] [!type] open new empty file [named filename] x=w (work-on-copy) x=f (no-work-on-copy).
 | oP                        probe opened file type and load data struct.
 | oL                        probe opened file type and load data struct.(probe (oP) alias).
 | oO  [%x] filename         open filename without probing filetype and without loading data structures (x=w write-on-copy, x=f no-write-on-copy).
.TP
.B block size commands
 Get/Set block size
 | b             display current block size
 | b  33         set block size to 33
 | b+ 3          increase blocksize by 3
 | b- 16         decrease blocksize by 16
 | b  0xfa+4     numeric argument can be an expression
.TP
.B seek commands
 | s             Print current address
 | s  addr       Seek to address
 | s-            Undo seek
 | s+            Redo seek
 | s- n          Seek n bytes backward
 | s+ n          Seek n bytes forward
 | s--           Seek blocksize bytes backward
 | s++           Seek blocksize bytes forward
 | s*            List undo seek history
 | s/ DATA       Search for next occurrence of 'DATA'
 | s/x 9091      Search for next occurrence of \x90\x91
 | ss            Seek silently (without adding an entry to the seek history)
 | s             Print current address
.TP
.B print commands
 | pp[?] [%nx] [@]expr     generic print function.
 | px [%n][x]              hex print of n bytes from offset x.
 | pxl n                   hex print n lines.
 | pxx [%n][x]             hex pretty print of n bytes from offset x.
 | ps [%n][x]              print a string at offset x of n len.
 | pn [%x] [offs] [!%z]    print number (cC=char, sS=short(little, big endian), wW=word(little,big endian), qQ=quad) from offset in z format (d=decimal,x=hex) .
 | x  [%n][x]              same as px.
 | xl  n                   same as pxl.
 | xx [%n][x]              same as pxx.
.TP
.B write commands
write operations commands.
append '+' to the commands to perform the operation increasing the file size (not overwriting operations).
 | wx[+] [%n] '9190' [offset]          write hex 0x91 0x90 at offset max n bytes.
 | ws[+] [%n] 'foo' [offset]           write string foo at offset max n chars.
 | wz[+] [%n] 'foo' [offset]           write string zero terminated at offset max n chars.
 | wps[+] [%np|b] 'pattern' [offset]   write string pattern n times at offset (p repeats n times the string, b repeats n times the bytes[can trunc string]).
 | wpx[+] [%np|b] 'pattern' [offset]   write hex pattern n times at offset (p repeats n times the string, b repeats n times the bytes[can trunc string]).
 | wf[+] [%n] ./myfile [offset]        write myfile at offset max n bytes.
 | wr[+] [%n][offset]                  write random bytes at offset max n times.
 | wle[+] [%1|2|4|8] number [offset]   write little endian number of 1,2,4,8 bytes at offset.
 | wbe[+] [%1|2|4|8] number [offset]   write big endian number of 1,2,4,8 bytes at offset.
 | wn[+] [%cCsSwWqQ] number [offset]   write number at offset (c C=1byte, s=le short(little endian 2 bytes), S=be short, w=le word, W=be word(big endian 4 bytes), q=le quad(little endian 8 bytes), Q=be quad).
 | wo[?]                               write over operations commands.
.TP
.B write over commands
write over operations commands (n=times [bytes repeated], offs=offset)
 | woa [%n] expr [offs]        +=  addition (f.ex: woa 0x0102)
 | woA [%n] expr [offs]        &=  and
 | wos [%n] expr [offs]        -=  substraction
 | wol [%n] expr [offs]        <<= shift left
 | wom [%n] expr [offs]        *=  multiply
 | wor [%n] expr [offs]        >>= shift right
 | woo [%n] expr [offs]        |=  or
 | wox [%n] expr [offs]        ^=  xor  (f.ex: wox %4 0x90 0x100)
 | wo2 [offs]                  2=  2 byte endian swap
 | wo4 [offs]                  4=  4 byte endian swap
 | wo8 [offs]                  8=  8 byte endian swap
.SH CONFIG FILE
.TP
.B dwarfrc
\fBdwarf-ng\fP look for config files: \fI/etc/dwarfrc\fP first and then \fI.dwarfrc\fP in the $HOME directory. If no config file is founded dwarf-ng runs with default values. A snapshot of a config file il listed below:
.nf
#dwarf config file.
work_on_tmpcopy=yes #(yes|no)
verbose=0 #this is a comment
tmpdir="/tmp"
tmpname="dw_temp_filex"
colors=yes #(yes|no)
#theme=2 #(0=nocolors, 1=normalcolors, 2=boldcolors)

.fi
where a comment line begins with a \fB#\fP.

.SH FILE TYPES
.TP
.B ELF
.nf
main elf struct: $elf
program header: $ph[0..n]
section header: $sh[0..n]
.fi
.TP
.B PE
.nf
MZEXE struct: $mz
pe main header: $pe
$pe::FileHeader
$pe::OptionalHeader
PE section: $sect[0..n]
.fi
.TP
.B MACH-O
.nf
Macho main header: $mac
load command: $lc[0..n]
Macho section: $lc::sect[0..n]
.fi
.TP
.B MACH-O FAT BINARY (UNIVERSAL BINARY)
.nf
main fat header: $fat
file's architectures: $arch[0..n]
.fi
.SH EXAMPLES
.B #//var assignment
.nf
a=5; pp a
a=7
pp a
b=3
c=a+b+7
pp c
pp %x c		#prints c variable in hexadecimal format
.fi

.B #//structured variable
.nf
o myfile              #open the file
i                     #prints file's main structures
pp $elf               #prints the main elf structure (assuming an elf file :) )
pp $elf::ph_num       #prints program header's number
$elf::ph_num=7        #sets program header number
a=$sh[7]::offset      #puts into 'a' variable the 'offset' member of the 8th section header
pp $ph                #prints a list of all program header
pp $sh[0]             #prints the 1st section header details
.fi

.B #//offsets
.nf
pp @<       #prints the offset of the beginnig of the opened file (zero ;) )
pp @>       #prints the offset of the end of size (filesize ;) )
os          #equivalent to print @>
a=@sh[1]    #a is the offset of the beginning of the 2nd section header
c=@sh[1]<   #c=a
b=@sh[1]>   #b is the offset of the end of the 2nd section header
wx %10 '0' $sh[4]::offset   #inject 10 times the value 0 (zero) from '$sh[4]::offset' offset
wf ./vir.bin @ph[4]>        #inject the content of "vir.bin" file from the end of the 5th program header
.fi

.B #//header create
.nf
Sc+ ph @ph[2]>         #create a program header from the end of the 3rd program header's section 
Sc+ sh @sh[4]          #create a section header from the beginning of the 5th section and shift file so it won't overwrite data. 
                       #old $sh[4] is now $sh[5] and the section created is $sh[4]
$elf::sh_num=$elf::sh_num+1 #remember to increase the section number from the main elf header
.fi
.B #//hex editor && generic file operations
.nf
o myfile      #open the file
oO myfile     #open the file without loading data
oP            #probe file type and loads file data
x             #hexdump from actual offset
x 0x100       #hexdump from offset 0x100
s             #show current offset
s 0x100       #set offset at 0x100
b 0x33        #set block size eq 0x33
pp %x 10+2    #print 10+2 expression result in hex
pp %3 1       #print 3 times '1'
pp %3x @0x100 #print 3 bytes nin hex format starting al 0x100 offset
pp %3c @0     #print 3 char from offset 0
ps %3         #print 3 chat from current offset
oR+ 10        #resize file increase 10 bytes
M 0 +10 0x100 #move 10 bytes block from offset 0 to offset 0x100
M 0 0x23 0x44 #move bytes from 0 to 0x23 at new offset 0x44

...

(and many more....)
.SH SEE ALSO
readelf(1), objdump(1), ht(1), otool(1), gdb(1), elf(5), elfsh(1), elfdump(1)
.SH AUTHOR
.nf
Fernando Iazeolla < fernando.iazeolla_FOobAr_gmail_Baz_com, by replacing _fOoBar_ with a @ and _Baz_ with a . > - founder & core developer.
.SH COPYRIGHT
.nf
Copyright (C) 2007-2013-2017 Fernando Iazeolla < fernando.iazeolla_FOobAr_gmail_Baz_com, by replacing _fOoBar_ with a @ and _Baz_ with a . >
.P
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.P
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.P
You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
