#!/usr/bin/env python

# $Id: ducky.py,v 1.30 2005/12/15 03:36:19 jose Exp $

__copyright__ = """
Copyright (c) 2005 Jose Nazario

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation files
(the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
"""

import codecs, sys
import DuckyLib
from DuckyLib import technorati as tec
from DuckyLib.yahoo.search import webservices
from DuckyLib import alexa, amazon, feedster, flickr, google, noaa, yahoo
from DuckyLib.rss import Rss
# from pprint import pprint

__version__ = '0.9.5'

def info():
    print 'ducky, the web services command line.'
    print 'Version: %s' % __version__
    print 'usage: <CMD> <KEYWORDS>\n'
    print 'Copyright (c) 2005 Jose Nazario, all rights reserved.'
    print 'Uses libraries with these copyrights:'
    print '  Technorati support:', tec.__copyright__
    print '  Google support:', google.__copyright__
    print '  Amazon support:', amazon.__copyright__
    print '  Feedster support:', feedster.__copyright__
    print '  Yahoo! support:', yahoo.search.webservices.__copyright__
    print '  Flickr support:', flickr.__copyright__
    sys.exit(0)

def _descape(input):
    """opposite of cgi.escape() ..."""
    input = input.replace('&gt;', '>')
    input = input.replace('&lt;', '<')
    input = input.replace('&quot;', '"')
    input = input.replace('&#39;', """'""")
    input = input.replace('&amp;', '&')
    return input

def noKey(name):
    print 'Support for %s disabled, no license key found.' % name

def err():
    print 'An error occured.'
    sys.exit(-1)

def setKeys():
    try: amazon.setLicense(amazon.getLicense())
    except: noKey('amazon')
    try: google.setLicense(google.getLicense())
    except: noKey('google')
    try: tec.setLicense(tec.findkey())
    except: noKey('technorati')
    try: flickr.setLicense(flickr.getLicense())
    except: noKey('flickr')

def doYFinance(term):
    """get Yahoo! finance results via RSS"""
    try:
        r = Rss('http://finance.yahoo.com/rss/headline?s=')
        results = r.search(term)[:10]
    except: err()
    r.printRss(results)
    sys.exit(0)

def doYNews(terms):
    """get Yahoo! news results via RSS"""
    try:
        r = Rss('http://news.search.yahoo.com/news/rss?ei=UTF-8&p=')
        results = r.search('+'.join(terms))[1:9] # skip header, footer
    except: err()
    r.printRss(results)
    sys.exit(0)

def doYBlogs(terms):
    """get Yahoo! blog search results via RSS"""
    try:
       r = Rss('http://news.search.yahoo.com/news/rss?p=')
       results = r.search('+'.join(terms))
    except: err()
    r.printRss(results)
    sys.exit(0)

def doYJobs(terms):
    """search Yahoo's job search engine"""
    try: 
         r = Rss('http://hotjobs.yahoo.com/rss/0/USA/-/-/-/')
         results = r.search('+'.join(terms))[:10]
    except: err()
    r.printRss(results)
    sys.exit(0)

def doNoaa(site):
    """get NOAA weather results from an airport"""
    try: results = noaa.search(site.upper())
    except: err()
    for r in results:
	print 'Current conditions:\n%s' % r[u'title']
	print '%s' % r[u'description'].strip()
	print '%s' % r[u'link']
    sys.exit(0)

def doTopix(terms):
    """get topix results via RSS"""
    try:
        r = Rss('http://rss.topix.net/search/?xml=1&q=')
        results = r.search('+'.join(terms))[1:9] # skip header, footer
    except: err()
    r.printRss(results)
    sys.exit(0)

def doTube(terms):
    """get YourTube results via RSS"""
    try:
        r = Rss('http://www.youtube.com/rss/tag/')
        results = r.search('+'.join(terms) + '.rss')
    except: err()
    r.printRss(results)
    sys.exit(0)

def doAlexa(terms):
    print alexa.search(' '.join(terms))

def doAADL(terms):
    """do AADL keyword book search via RSS"""
    try:
        rr = 'http://www.aadl.org/cat/seek/search/X?SEARCH=%s&rss=1' % ('+'.join(terms))
        r = Rss(rr) 
	results = r.search('')
    except: err()
    r.printRss(results)
    sys.exit(0)

def doAmazon(type, terms):
    """wrap the amazon search interface"""
    try: 
        if type == 'keyword': books = amazon.searchByKeyword('%s' % ' '.join(terms))
        elif type == 'asin': books = amazon.searchByASIN(terms)
    except: err()
    for b in books: 
        print '\n%s: %s  ' % (b.Catalog, b.ProductName),
        try: print 'Price: %s' % b.OurPrice,
        except: pass
        try: 
            author = b.Authors.Author
            if len(author) < 5: print '\nAuthors: %s' % ', '.join(author),
            else: print '\nAuthor: %s' % author,
        except: pass
        print '\n%s' % b.URL
    sys.exit(0)

def doTec(terms):
    """wrap the technorati search interface"""
    try: data = tec.search('%s' % ' '.join(terms))
    except: err()
    i = 1
    for r in data['search']:
        r['excerpt'] = r['excerpt'].replace('<strong class="keyword">', '')
        r['excerpt'] = r['excerpt'].replace('</strong>', '')
        blog = r['weblog']
        try:
            print '\n%d. %s' % (i, _descape(blog['name'].encode('utf-8')))
            print '     %s' % _descape(r['excerpt'].encode('utf-8'))
            print u'     %s' % blog['url']
            print u'     %s' % blog['lastupdate']
        except: pass
        i = i + 1
    sys.exit(0)

def doTecTag(terms):
    try:
        r = Rss('http://feeds.technorati.com/feed/posts/tag/')
        results = r.search('%20'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doBlogdig(terms):
    """search the Blogdigger search engine"""
    try: 
        r = Rss('http://www.blogdigger.com/rss.jsp?sortby=date&q=')
        results = r.search('+'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doBlink(terms):
    """search the blink list tag search engine"""
    try:
        r = Rss('http://www.blinklist.com/tag/')
        results = r.search('%20'.join(terms) + '/rss.xml')
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doDaypop(terms):
    """search the Daypop search engine"""
    try: 
        r = Rss('http://www.daypop.com/search?s=1&c=10&t=a&o=rss&q=')
        results = r.search('%20'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doMsn(terms):
    """search the MSN Beta search engine"""
    try: 
        r = Rss('http://beta.search.msn.com/results.aspx?format=rss&q=')
        out = r.search('%20'.join(terms))
    except: err()
    r.printRss(out)
    sys.exit(0)

def doSmug(terms):
    """search the smugmug search engine"""
    try: 
        r = Rss('http://www.smugmug.com/hack/feed.mg?Type=search&format=rss200&Data=')
        out = r.search('%20'.join(terms))
    except: err()
    r.printRss(out[:10])
    sys.exit(0)

def doSimply(terms):
    """search the Simply Hired job search engine"""
    try: 
        r = Rss('http://www.simplyhired.com/rss/_mi/25/_q/')
        out = r.search('_'.join(terms) + '/')
    except: err()
    r.printRss(out[:10])
    sys.exit(0)

def doIce(terms):
    """search the Ice Rocket blog search engine"""
    try: 
        r = Rss('http://www.icerocket.com/search?tab=blog&rss=1&q=')
        results = r.search('%20'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doIndeed(terms):
    """search indeed job search engine"""
    try: 
        r = Rss('http://rss.indeed.com/rss?l=&radius=25&q=')
        results = r.search('+'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doMp3(terms):
    """search the MP3blogs aggregator"""
    try:
       r = Rss('http://hype.non-standard.net/playlist/search/')
       results = r.search('%20'.join(terms) + '/rss/1/feed.xml')
    except: err()
    r.printRss(results)
    sys.exit(0)

def doFlickr(term):
    """search Flickr by tag"""
    import time
    try: results = flickr.photos_search(tags=term)
    except: err()

    def untag(line):
        line = line.replace("""<a href="http://www.geobloggers.com">GeoTagged</a>""", '')
        line = line.replace("""<a href="http://www.geobloggers.com" rel="nofollow">GeoTagged</a>""", '')
        return line.strip()

    i = 1
    for r in results[:10]:
        if not r.ispublic: next
        o = r.owner
        print '%d. %s (%s) %s' % (i, o.realname, o.username, o.location)
        try: print '   %s' % r.getURL()
        except: pass
        if len(r.description) > 1: 
            descr = untag(r.description)
            title = untag(r.title)
            print '   %s: %s' % (title, _descape(descr))
        print '   %s' % time.strftime('%B %d, %Y %H:%M', time.localtime(float(r.dateposted)))
        i = i + 1
    sys.exit(0)

def doDel(terms, type = ''):
    """search del.icio.us by tag"""
    urlstr = 'http://del.icio.us/rss/%s' % type
    try: 
        r = Rss(urlstr)
        out = r.search('+'.join(terms))
    except: err()
    r.printRss(out[:10])
    sys.exit(0)

def doDelUser(terms):
    """search del.icio.us by user"""
    try: 
        r = Rss('http://del.icio.us/rss/')
        out = r.search('+'.join(terms))
    except: err()
    r.printRss(out[:10])
    sys.exit(0)

def doCiteulike(terms):
    """wrap the CIteULike search engine"""
    try: 
        r = Rss('http://www.citeulike.org/rss/search/all?f=tag&q=')
        results = r.search('%s' % '%20'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doConnotea(terms):
    """wrap the Connotea search engine"""
    try: 
        r = Rss('http://www.connotea.org/rss/tag/')
        results = r.search('%s' % '/'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doTag(terms):
    """wrap the gataga search engine"""
    try: 
        r = Rss('http://www.gataga.com/explore-rss.php?q=')
        results = r.search('%s' % '%20'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doFindory(terms):
    """wrap the findory search engine"""
    try: 
        r = Rss('http://rss.findory.com/rss/Blogs?q=')
        results = r.search('%s' % '%20'.join(terms)) 
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doFeed(terms):
    """wrap the feedster search engine ..."""
    try: 
        r = Rss('http://feedster.com/search.php?sort=date&ie=UTF-8&hl=&content=full&type=rss&limit=15&q=')
        results = r.search('%s' % '+'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doFjobs(terms):
    """wrap the feedster jobs search engine ..."""
    try: 
        r = Rss('http://feedster.com/search.php?sort=date&ie=UTF-8&hl=&content=full&type=rss&limit=15&category=jobs&q=')
        results = r.search('%s' % '+'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def doYahoo(terms):
    """wrap the Yahoo! WS search ..."""
    try: x = webservices.create_search("web", "YahooDemo", query=' '.join(terms), results=10)
    except: err()
    srch = x.parse_results()
    i = 1
    for s in srch._get_results():
       print '\n%d. %s' % (i, s['Title'])
       print '   %s' % s['Summary']
       print '   %s' % s['Url']
       i = i + 1
    sys.exit(0)

def doGoogle(terms):
    """wrap the google search interface"""
    try: data = google.doGoogleSearch('%s' % ' '.join(terms))
    except: err()
    print 'Results 1 - 10 of about %s for %s' % \
        (str(data.meta.estimatedTotalResultsCount), ' '.join(terms))
    i = 1
    for r in data.results: 
       title = r.title
       title = title.replace('<b>', '')
       title = title.replace('</b>', '')
       snippet = r.snippet
       snippet = snippet.replace('<b>', '')
       snippet = snippet.replace('</b>', '')
       snippet = snippet.replace('<br>', '')
       url = r.URL
       url = url.replace('<b>', '')
       url = url.replace('</b>', '')
       print u'%d. %s' % (i, title)
       print u'     %s' % _descape(snippet)
       print u'     %s\n' % url
       i = i + 1
    sys.exit(0)

def doGNews(terms):
    """get Google news results via RSS"""
    r = Rss('http://news.google.com/news?hl=en&ned=us&ie=UTF-8&output=rss&q=')
    results = r.search('+'.join(terms)) # skip header, footer
    try:
        r = Rss('http://news.google.com/news?hl=en&ned=us&ie=UTF-8&output=rss&q=')
        results = r.search('+'.join(terms)) # skip header, footer
    except: err()
    r.printRss(results)
    sys.exit(0)

def doGoogleBlog(terms):
    """wrap the feedster jobs search engine ..."""
    try: 
        r = Rss('http://blogsearch.google.com/blogsearch_feeds?hl=en&btnG=Search+Blogs&num=10&output=rss&q=')
        results = r.search('%s' % '+'.join(terms))
    except: err()
    r.printRss(results[:10])
    sys.exit(0)

def main():
    setKeys()
    sys.stdout = codecs.lookup('utf-8')[-1](sys.stdout)

    argv0 = sys.argv[0].split('/')[-1]
    if len(sys.argv) == 1: info()

    # helper
    def doAsin(terms): doAmazon('asin', terms)

    # these take sys.argv[1:] as their args.
    # key: 	cmdline invocation
    # value: 	eval function (as _map[key](sys.argv[1:])
    _map = {
            'aadl':     doAADL,
            'bdig':	doBlogdig,
            'blink':	doBlink,
            'cite':	doCiteulike,
            'conn':	doConnotea,
            'day':	doDaypop,
            'feed':	doFeed,
            'fin':	doFindory,
            'fjobs':	doFjobs,
            'g': 	doGoogle,
            'gblog': 	doGoogleBlog,
            'gnews':	doGNews,
	    'ice':	doIce,
            'ind':	doIndeed,
            'mp3':	doMp3,
            'msn':	doMsn,
            'simp':	doSimply,
            'smug':	doSmug,
            'tag':	doTag,
            'tec':	doTec,
            'tectag':	doTecTag,
            'topix':	doTopix,
            'tube':	doTube,
            'ya':	doYahoo,
            'yblogs':	doYBlogs,
            'ynews':	doYNews,
            'yjobs':	doYJobs
           }

    # amazon mappings to locales
    # sets the locale, then does the search
    _ammap = {'am':	'us',
              'amuk':	'uk',
              'ameu':	'de',
              'amjp':	'jp'
	     }

    # these are functions that take only sys.argv[1]
    # key:	cmdline invocation
    # value:	function (as _1map[argv0](sys.argv[1])
    _1map = {'asin':	doAsin,
             'fl':	doFlickr,
             'isbn':	doAsin,
             'noaa':	doNoaa,
             'yfin':	doYFinance
            }

    _delmap = { 'del':		'tag/',
                'deluser':	''
              }

    if _map.has_key(argv0): _map[argv0](sys.argv[1:])
    elif _ammap.has_key(argv0):
        amazon.setLocale(_ammap[argv0])
        doAmazon('keyword', sys.argv[1:])
    elif _1map.has_key(argv0): _1map[argv0](sys.argv[1])
    elif sys.argv[1] == 'commands':
        print 'Available commands: '
        for cmds in [_map, _ammap, _1map, _delmap]:
            print '%s' % ', '.join(cmds.keys())
    elif _delmap.has_key(argv0): doDel(sys.argv[1:], _delmap[argv0])
    else: 
        print 'For a list of available commands, try %s commands' % sys.argv[0]
        err()

if __name__ == '__main__':
    main()
