/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.sftp.SFTPAttributesFinderFeature;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.EnumSet;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;

public class SFTPTouchFeature
implements Touch<Void> {
    private final SFTPSession session;

    public SFTPTouchFeature(SFTPSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        if (file.isFile()) {
            try {
                FileAttributes attrs = Permission.EMPTY != status.getPermission() ? new FileAttributes.Builder().withPermissions(Integer.parseInt(status.getPermission().getMode(), 8)).build() : FileAttributes.EMPTY;
                RemoteFile handle = this.session.sftp().open(file.getAbsolute(), EnumSet.of(OpenMode.CREAT, OpenMode.TRUNC, OpenMode.WRITE), attrs);
                handle.close();
            }
            catch (IOException e) {
                throw new SFTPExceptionMappingService().map("Cannot create {0}", e, file);
            }
        }
        return new Path(file.getParent(), file.getName(), file.getType(), new SFTPAttributesFinderFeature(this.session).find(file));
    }

    public SFTPTouchFeature withWriter(Write writer) {
        return this;
    }
}

