/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.OneDriveHomeFinderService;
import ch.cyberduck.core.onedrive.OneDriveListService;
import ch.cyberduck.core.onedrive.OneDriveUrlProvider;
import ch.cyberduck.core.onedrive.features.GraphLockFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.types.DirectoryObject;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.DriveItem;

public class OneDriveSession
extends GraphSession {
    public static final GraphSession.ContainerItem MYFILES = new GraphSession.ContainerItem(OneDriveListService.MYFILES_NAME, null, true);
    public static final GraphSession.ContainerItem SHAREDFILES = new GraphSession.ContainerItem(null, OneDriveListService.SHARED_NAME, false);

    public OneDriveSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    @Override
    public DriveItem toItem(Path file, boolean resolveLastItem) throws BackgroundException {
        String itemId;
        String driveId;
        if (file.equals((Object)OneDriveListService.MYFILES_NAME)) {
            return new Drive((DirectoryObject)this.getUser().asDirectoryObject()).getRoot();
        }
        String versionId = this.fileIdProvider.getFileid(file, (ListProgressListener)new DisabledListProgressListener());
        if (StringUtils.isEmpty((CharSequence)versionId)) {
            throw new NotfoundException(String.format("Version ID for %s is empty", file.getAbsolute()));
        }
        String[] idParts = versionId.split(String.valueOf('/'));
        if (idParts.length == 2 || !resolveLastItem) {
            driveId = idParts[0];
            itemId = idParts[1];
        } else if (idParts.length == 4) {
            driveId = idParts[2];
            itemId = idParts[3];
        } else {
            throw new NotfoundException(file.getAbsolute());
        }
        Drive drive = new Drive((OneDriveAPI)this.getClient(), driveId);
        return new DriveItem(drive, itemId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAccessible(Path file, boolean container) {
        if (file.isRoot()) {
            return false;
        }
        GraphSession.ContainerItem containerItem = this.getContainer(file);
        if (containerItem.isDrive()) {
            if (container) return true;
            if (containerItem.getContainerPath().map(arg_0 -> ((Path)file).equals(arg_0)).orElse(false) == false) return true;
        }
        if (containerItem.isDrive()) return false;
        if (containerItem.getCollectionPath().map(o -> file.equals(o) || file.getParent().equals(o)).orElse(false) != false) return false;
        return true;
    }

    @Override
    public GraphSession.ContainerItem getContainer(Path file) {
        if (OneDriveListService.MYFILES_PREDICATE.test(file) || file.isChild(OneDriveListService.MYFILES_NAME)) {
            return MYFILES;
        }
        if (OneDriveListService.SHARED_PREDICATE.test(file) || file.isChild(OneDriveListService.SHARED_NAME)) {
            return SHAREDFILES;
        }
        return GraphSession.ContainerItem.EMPTY;
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new OneDriveListService(this);
        }
        if (type == UrlProvider.class) {
            return (T)new OneDriveUrlProvider();
        }
        if (type == Home.class) {
            return (T)((Object)new OneDriveHomeFinderService(this));
        }
        if (type == Lock.class && null != this.getUser() && null != this.getUser().getCreationType()) {
            return (T)new GraphLockFeature(this);
        }
        return super._getFeature(type);
    }
}

