/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.serializer.Serializer;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Path
extends AbstractPath
implements Referenceable,
Serializable {
    public static final char DELIMITER = '/';
    protected Path parent;
    private String path;
    private Path symlink;
    private EnumSet<AbstractPath.Type> type;
    private PathAttributes attributes;

    public Path(Path copy) {
        this.parent = copy.parent;
        this.path = copy.path;
        this.symlink = copy.symlink;
        this.type = EnumSet.copyOf(copy.type);
        this.attributes = new PathAttributes(copy.attributes);
    }

    public Path(Path parent, String name, EnumSet<AbstractPath.Type> type) {
        this.type = type;
        this.attributes = new PathAttributes();
        this.attributes.setRegion(parent.attributes.getRegion());
        this._setPath(parent, name);
    }

    public Path(String absolute, EnumSet<AbstractPath.Type> type) {
        this.type = type;
        this.attributes = new PathAttributes();
        this.setPath(absolute);
    }

    public Path(String absolute, EnumSet<AbstractPath.Type> type, PathAttributes attributes) {
        this.type = type;
        this.attributes = attributes;
        this.setPath(absolute);
    }

    public Path(Path parent, String name, EnumSet<AbstractPath.Type> type, PathAttributes attributes) {
        this.type = type;
        this.attributes = attributes;
        this._setPath(parent, name);
    }

    @Override
    public <T> T serialize(Serializer dict) {
        dict.setStringForKey(String.valueOf(this.type), "Type");
        dict.setStringForKey(this.getAbsolute(), "Remote");
        if (this.symlink != null) {
            dict.setObjectForKey(this.symlink, "Symbolic Link");
        }
        dict.setObjectForKey(this.attributes, "Attributes");
        return dict.getSerialized();
    }

    private void setPath(String absolute) {
        if (String.valueOf('/').equals(absolute)) {
            this._setPath(null, absolute);
        } else {
            Path parent = new Path(PathNormalizer.parent(absolute, '/'), EnumSet.of(AbstractPath.Type.directory));
            parent.attributes().setRegion(this.attributes.getRegion());
            if (parent.isRoot()) {
                parent.setType(EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
            }
            this._setPath(parent, PathNormalizer.name(absolute));
        }
    }

    private void _setPath(Path parent, String name) {
        this.parent = parent;
        this.path = null == parent ? name : (parent.isRoot() ? parent.getAbsolute() + name : (name.startsWith(String.valueOf('/')) ? parent.getAbsolute() + name : parent.getAbsolute() + '/' + name));
    }

    @Override
    public EnumSet<AbstractPath.Type> getType() {
        return this.type;
    }

    public void setType(EnumSet<AbstractPath.Type> type) {
        this.type = type;
    }

    public boolean isVolume() {
        return this.type.contains((Object)AbstractPath.Type.volume);
    }

    public boolean isDirectory() {
        return this.type.contains((Object)AbstractPath.Type.directory);
    }

    public boolean isPlaceholder() {
        return this.type.contains((Object)AbstractPath.Type.placeholder);
    }

    public boolean isFile() {
        return this.type.contains((Object)AbstractPath.Type.file);
    }

    public boolean isSymbolicLink() {
        return this.type.contains((Object)AbstractPath.Type.symboliclink);
    }

    @Override
    public char getDelimiter() {
        return String.valueOf('/').charAt(0);
    }

    public Path getParent() {
        if (this.isRoot()) {
            return this;
        }
        return this.parent;
    }

    public PathAttributes attributes() {
        return this.attributes;
    }

    public void setAttributes(PathAttributes attributes) {
        this.attributes = attributes;
    }

    public Path withAttributes(PathAttributes attributes) {
        this.setAttributes(attributes);
        return this;
    }

    @Override
    public String getName() {
        if (this.isRoot()) {
            return String.valueOf('/');
        }
        if (this.parent.isRoot()) {
            return StringUtils.substringAfter((String)this.path, (String)this.parent.getAbsolute());
        }
        return StringUtils.substringAfter((String)this.path, (String)(this.parent.getAbsolute() + '/'));
    }

    @Override
    public String getAbsolute() {
        return this.path;
    }

    public Path getSymlinkTarget() {
        return this.symlink;
    }

    public void setSymlinkTarget(Path target) {
        this.symlink = target;
    }

    public int hashCode() {
        return new DefaultPathPredicate(this).hashCode();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof Path) {
            return new DefaultPathPredicate(this).equals(new DefaultPathPredicate((Path)other));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Path{");
        sb.append("path='").append(this.path).append('\'');
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public boolean isChild(Path directory) {
        if (directory.isFile()) {
            return false;
        }
        if (this.isRoot()) {
            return false;
        }
        if (directory.isRoot()) {
            return true;
        }
        if (Objects.equals(this.getParent(), directory.getParent())) {
            return false;
        }
        Path parent = this.getParent();
        while (!parent.isRoot()) {
            if (new SimplePathPredicate(parent).test(directory)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

