/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.ftp.DataConnectionAction;
import ch.cyberduck.core.ftp.DataConnectionActionExecutor;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class FTPWriteFeature
extends AppendWriteFeature<Integer> {
    private static final Logger log = Logger.getLogger(FTPWriteFeature.class);
    private final FTPSession session;

    public FTPWriteFeature(FTPSession session) {
        super((Session)session);
        this.session = session;
    }

    public StatusOutputStream<Integer> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (!((FTPClient)((Object)this.session.getClient())).setFileType(2)) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
            OutputStream out = new DataConnectionActionExecutor(this.session).data(new DataConnectionAction<OutputStream>(){

                @Override
                public OutputStream execute() throws BackgroundException {
                    try {
                        if (status.isAppend()) {
                            if (!status.isExists()) {
                                log.warn((Object)String.format("Allocate %d bytes for file %s", status.getOffset(), file));
                                ((FTPClient)((Object)FTPWriteFeature.this.session.getClient())).allocate((int)status.getOffset());
                            }
                            return ((FTPClient)((Object)FTPWriteFeature.this.session.getClient())).appendFileStream(file.getAbsolute());
                        }
                        return ((FTPClient)((Object)FTPWriteFeature.this.session.getClient())).storeFileStream(file.getAbsolute());
                    }
                    catch (IOException e) {
                        throw new FTPExceptionMappingService().map(e);
                    }
                }
            }, (ProgressListener)new DisabledProgressListener());
            return new ReadReplyOutputStream(out, status);
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    public boolean temporary() {
        return true;
    }

    public boolean random() {
        return false;
    }

    public final class ReadReplyOutputStream
    extends StatusOutputStream<Integer> {
        private final AtomicBoolean close;
        private final TransferStatus status;
        private Integer reply;

        public ReadReplyOutputStream(OutputStream proxy, TransferStatus status) {
            super(proxy);
            this.status = status;
            this.close = new AtomicBoolean();
        }

        public void close() throws IOException {
            block6: {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", new Object[]{this}));
                    return;
                }
                try {
                    super.close();
                    if (!FTPWriteFeature.this.session.isConnected()) break block6;
                    this.reply = ((FTPClient)((Object)FTPWriteFeature.this.session.getClient())).getReply();
                    if (FTPReply.isPositiveCompletion((int)this.reply)) break block6;
                    String text = ((FTPClient)((Object)FTPWriteFeature.this.session.getClient())).getReplyString();
                    if (this.status.isSegment()) {
                        log.warn((Object)String.format("Ignore unexpected reply %s when completing file segment %s", text, this.status));
                        break block6;
                    }
                    if (!this.status.isComplete()) {
                        log.warn((Object)String.format("Ignore unexpected reply %s with incomplete transfer status %s", text, this.status));
                        break block6;
                    }
                    log.warn((Object)String.format("Unexpected reply %s when completing file download with status %s", text, this.status));
                    throw new FTPException(((FTPClient)((Object)FTPWriteFeature.this.session.getClient())).getReplyCode(), text);
                }
                finally {
                    this.close.set(true);
                }
            }
        }

        public Integer getStatus() {
            return this.reply;
        }
    }
}

