/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="User lockout information")
public class UserLockout {
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="maxNumberOfLoginFailures")
    private Integer maxNumberOfLoginFailures = null;
    @JsonProperty(value="lockoutPeriod")
    private Integer lockoutPeriod = null;

    public UserLockout enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(required=true, description="Determines whether user lockout is enabled")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UserLockout maxNumberOfLoginFailures(Integer maxNumberOfLoginFailures) {
        this.maxNumberOfLoginFailures = maxNumberOfLoginFailures;
        return this;
    }

    @Schema(description="Maximum allowed number of failed login attempts")
    public Integer getMaxNumberOfLoginFailures() {
        return this.maxNumberOfLoginFailures;
    }

    public void setMaxNumberOfLoginFailures(Integer maxNumberOfLoginFailures) {
        this.maxNumberOfLoginFailures = maxNumberOfLoginFailures;
    }

    public UserLockout lockoutPeriod(Integer lockoutPeriod) {
        this.lockoutPeriod = lockoutPeriod;
        return this;
    }

    @Schema(description="Amount of minutes a user has to wait to make another login attempt after `maxNumberOfLoginFailures` has been exceeded")
    public Integer getLockoutPeriod() {
        return this.lockoutPeriod;
    }

    public void setLockoutPeriod(Integer lockoutPeriod) {
        this.lockoutPeriod = lockoutPeriod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserLockout userLockout = (UserLockout)o;
        return Objects.equals(this.enabled, userLockout.enabled) && Objects.equals(this.maxNumberOfLoginFailures, userLockout.maxNumberOfLoginFailures) && Objects.equals(this.lockoutPeriod, userLockout.lockoutPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.maxNumberOfLoginFailures, this.lockoutPeriod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserLockout {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    maxNumberOfLoginFailures: ").append(this.toIndentedString(this.maxNumberOfLoginFailures)).append("\n");
        sb.append("    lockoutPeriod: ").append(this.toIndentedString(this.lockoutPeriod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

