/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSDelegatingWriteFeature;
import ch.cyberduck.core.sds.SDSMultipartWriteFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SDSTouchFeature
implements Touch<VersionId> {
    private static final Logger log = Logger.getLogger(SDSTouchFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private Write<VersionId> writer;

    public SDSTouchFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
        this.writer = new SDSDelegatingWriteFeature(session, nodeid, (Write<VersionId>)new SDSMultipartWriteFeature(session, nodeid));
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            if (this.nodeid.isEncrypted(file)) {
                status.setFilekey(this.nodeid.getFileKey());
            }
            StatusOutputStream out = this.writer.write(file, status.complete(), (ConnectionCallback)new DisabledConnectionCallback());
            out.close();
            return new Path(file.getParent(), file.getName(), file.getType(), new PathAttributes(file.attributes()).withVersionId(((VersionId)out.getStatus()).id));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create {0}", (Throwable)e, file);
        }
    }

    public boolean isSupported(Path workdir, String filename) {
        if (workdir.isRoot()) {
            return false;
        }
        if (!this.validate(filename)) {
            log.warn((Object)String.format("Validation failed for target name %s", filename));
            return false;
        }
        if (workdir.attributes().getQuota() != -1L && workdir.attributes().getQuota() <= workdir.attributes().getSize() + (long)PreferencesFactory.get().getInteger("sds.upload.multipart.chunksize")) {
            log.warn((Object)String.format("Quota %d exceeded with %d in %s", workdir.attributes().getQuota(), workdir.attributes().getSize(), workdir));
            return false;
        }
        SDSPermissionsFeature permissions = new SDSPermissionsFeature(this.session, this.nodeid);
        return permissions.containsRole(workdir, SDSPermissionsFeature.CREATE_ROLE) && permissions.containsRole(workdir, SDSPermissionsFeature.DELETE_ROLE);
    }

    public boolean validate(String filename) {
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            if (StringUtils.length((CharSequence)filename) > 150) {
                return false;
            }
            if (StringUtils.containsAny((CharSequence)filename, (char[])new char[]{'\\', '<', '>', ':', '\"', '|', '?', '*', '/'})) {
                return false;
            }
            if (StringUtils.startsWith((CharSequence)filename, (CharSequence)"-")) {
                return false;
            }
            if (StringUtils.endsWith((CharSequence)filename, (CharSequence)".")) {
                return false;
            }
        }
        return true;
    }

    public Touch<VersionId> withWriter(Write<VersionId> writer) {
        this.writer = writer;
        return this;
    }
}

