/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import com.joyent.manta.client.crypto.ExternalSecurityProviderLoader;
import com.joyent.manta.exception.MantaMemoizationException;
import com.joyent.manta.util.Cloner;
import java.security.Provider;
import javax.crypto.Cipher;

public final class CipherCloner
implements Cloner<Cipher> {
    private static final com.rits.cloning.Cloner INSTANCE = new com.rits.cloning.Cloner();

    @Override
    public Cipher createClone(Cipher source) {
        Provider pkcs11Provider = ExternalSecurityProviderLoader.getPkcs11Provider();
        Provider cipherProvider = source.getProvider();
        if (pkcs11Provider != null && cipherProvider.equals(pkcs11Provider)) {
            String msg = String.format("Cannot create clone of Cipher with provider: %s", source.getProvider());
            throw new MantaMemoizationException(msg);
        }
        return (Cipher)INSTANCE.deepClone((Object)source);
    }

    static {
        INSTANCE.dontCloneInstanceOf(new Class[]{Class.class, Provider.class});
    }
}

