/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.FileSystemHelper;
import com.spectralogic.ds3client.helpers.ObjectStorageSpaceVerificationResult;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

class FileSystemHelperImpl
implements FileSystemHelper {
    FileSystemHelperImpl() {
    }

    @Override
    public boolean pathIsDirectory(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null.");
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    public boolean pathObjectExists(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null.");
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    public boolean pathIsWritable(Path path) throws IOException {
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null.");
        if (Platform.isWindows()) {
            return Files.isWritable(path);
        }
        PosixFileAttributes attributes = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        Set<PosixFilePermission> permissions = attributes.permissions();
        return permissions.contains((Object)PosixFilePermission.OWNER_WRITE) || permissions.contains((Object)PosixFilePermission.GROUP_WRITE) || permissions.contains((Object)PosixFilePermission.OTHERS_WRITE);
    }

    @Override
    public long getAvailableFileSpace(Path path) throws IOException {
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null.");
        return Files.getFileStore(path).getUsableSpace();
    }

    @Override
    public ObjectStorageSpaceVerificationResult objectsFromBucketWillFitInDirectory(Ds3ClientHelpers helpers, String bucketName, Collection<String> objectNames, Path destinationDirectory) {
        Preconditions.checkNotNull((Object)helpers, (Object)"helpers may not be null.");
        Guard.throwOnNullOrEmptyString((String)bucketName, (String)"bucketName must have a non-empty value.");
        Preconditions.checkNotNull(objectNames, (Object)"objectNames may not be null.");
        Preconditions.checkNotNull((Object)destinationDirectory, (Object)"destinationDirectory may not be null.");
        long requiredSpace = 0L;
        long availableSpace = 0L;
        if (!this.pathObjectExists(destinationDirectory)) {
            IOException ioException = null;
            return new ObjectStorageSpaceVerificationResult(ObjectStorageSpaceVerificationResult.VerificationStatus.PathDoesNotExist, requiredSpace, availableSpace, ioException);
        }
        if (!this.pathIsDirectory(destinationDirectory)) {
            IOException ioException = null;
            return new ObjectStorageSpaceVerificationResult(ObjectStorageSpaceVerificationResult.VerificationStatus.PathIsNotADirectory, requiredSpace, availableSpace, ioException);
        }
        try {
            if (!this.pathIsWritable(destinationDirectory)) {
                IOException nullIOException = null;
                return new ObjectStorageSpaceVerificationResult(ObjectStorageSpaceVerificationResult.VerificationStatus.PathLacksAccess, requiredSpace, availableSpace, nullIOException);
            }
        }
        catch (IOException ioException) {
            return new ObjectStorageSpaceVerificationResult(ObjectStorageSpaceVerificationResult.VerificationStatus.PathLacksAccess, requiredSpace, availableSpace, ioException);
        }
        try {
            helpers.ensureBucketExists(bucketName);
        }
        catch (IOException e) {
            IOException ioException = null;
            return new ObjectStorageSpaceVerificationResult(ObjectStorageSpaceVerificationResult.VerificationStatus.BucketDoesNotExist, requiredSpace, availableSpace, ioException);
        }
        try {
            requiredSpace = this.getRequiredSpaceForObjects(helpers, bucketName, objectNames);
            availableSpace = this.getAvailableFileSpace(destinationDirectory);
        }
        catch (IOException e) {
            return new ObjectStorageSpaceVerificationResult(ObjectStorageSpaceVerificationResult.VerificationStatus.CaughtIOException, requiredSpace, availableSpace, e);
        }
        ObjectStorageSpaceVerificationResult.VerificationStatus verificationStatus = availableSpace > requiredSpace ? ObjectStorageSpaceVerificationResult.VerificationStatus.OK : ObjectStorageSpaceVerificationResult.VerificationStatus.PathLacksSufficientStorageSpace;
        IOException ioException = null;
        return new ObjectStorageSpaceVerificationResult(verificationStatus, requiredSpace, availableSpace, ioException);
    }

    private long getRequiredSpaceForObjects(Ds3ClientHelpers helpers, String bucketName, Collection<String> objectNames) throws IOException {
        long result = 0L;
        HashMap<String, Long> objectSizeMap = new HashMap<String, Long>();
        Iterable<Contents> bucketContents = helpers.listObjects(bucketName);
        for (Contents bucketContent : bucketContents) {
            objectSizeMap.put(bucketContent.getKey(), bucketContent.getSize());
        }
        objectSizeMap.keySet().retainAll(objectNames);
        Iterator<Contents> iterator = objectSizeMap.values().iterator();
        while (iterator.hasNext()) {
            long objectSize = (Long)((Object)iterator.next());
            result += objectSize;
        }
        return result;
    }
}

