/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.crypto.model;

import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.internal.CryptoUtils;
import com.dracoon.sdk.crypto.internal.CryptoVersion;
import com.dracoon.sdk.crypto.internal.Validator;

public class EncryptedFileKey {
    private final Version version;
    private final String key;
    private final String iv;
    private String tag;

    public EncryptedFileKey(Version version, String key, String iv) throws IllegalArgumentException {
        Validator.validateNotNull("version", version);
        Validator.validateString("key", key);
        Validator.validateString("iv", iv);
        this.version = version;
        this.key = key;
        this.iv = iv;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getKey() {
        return this.key;
    }

    public String getIv() {
        return this.iv;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public static enum Version implements CryptoVersion
    {
        RSA2048_AES256GCM("A"),
        RSA4096_AES256GCM("RSA-4096/AES-256-GCM");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static Version getByValue(String value) throws UnknownVersionException {
            Version v = (Version)CryptoUtils.findCryptoVersionEnum((CryptoVersion[])Version.values(), (String)value);
            if (v == null) {
                throw new UnknownVersionException("Unknown encrypted file key version.");
            }
            return v;
        }
    }
}

