/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.spectra.SpectraBulkService;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferStatus;
import java.security.MessageDigest;
import java.util.List;
import org.jets3t.service.model.StorageObject;

public class SpectraUploadFeature
extends HttpUploadFeature<StorageObject, MessageDigest> {
    private Write<StorageObject> writer;
    private final SpectraBulkService bulk;

    public SpectraUploadFeature(Write<StorageObject> writer, SpectraBulkService bulk) {
        super(writer);
        this.writer = writer;
        this.bulk = bulk;
    }

    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (Checksum.NONE == status.getChecksum()) {
            status.setChecksum(this.writer.checksum(file, status).compute(local.getInputStream(), status));
        }
        List<TransferStatus> chunks = this.bulk.query(Transfer.Type.upload, file, status);
        StorageObject stored = null;
        for (TransferStatus chunk : chunks) {
            chunk.setChecksum(ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5).compute(local.getInputStream(), chunk));
            stored = (StorageObject)super.upload(file, local, throttle, listener, chunk, callback);
        }
        return stored;
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

