/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.DisabledUrlProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.shared.DefaultDownloadFeature;
import ch.cyberduck.core.shared.DisabledMoveFeature;
import ch.cyberduck.core.spectra.SpectraAttributesFinderFeature;
import ch.cyberduck.core.spectra.SpectraBulkService;
import ch.cyberduck.core.spectra.SpectraDeleteFeature;
import ch.cyberduck.core.spectra.SpectraDirectoryFeature;
import ch.cyberduck.core.spectra.SpectraFindFeature;
import ch.cyberduck.core.spectra.SpectraListService;
import ch.cyberduck.core.spectra.SpectraReadFeature;
import ch.cyberduck.core.spectra.SpectraTouchFeature;
import ch.cyberduck.core.spectra.SpectraUploadFeature;
import ch.cyberduck.core.spectra.SpectraVersioningFeature;
import ch.cyberduck.core.spectra.SpectraWriteFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.model.StorageObject;

public class SpectraSession
extends S3Session {
    public SpectraSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public RequestEntityRestStorageService connect(Proxy proxy, HostKeyCallback hostkey, LoginCallback prompt) {
        RequestEntityRestStorageService client = super.connect(proxy, hostkey, prompt);
        Jets3tProperties configuration = client.getConfiguration();
        configuration.setProperty("s3service.enable-storage-classes", String.valueOf(false));
        configuration.setProperty("s3service.disable-dns-buckets", String.valueOf(true));
        return client;
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Find.class) {
            return (T)new SpectraFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new SpectraAttributesFinderFeature(this);
        }
        if (type == ListService.class) {
            return (T)((Object)new SpectraListService(this));
        }
        if (type == Bulk.class) {
            return (T)new SpectraBulkService(this);
        }
        if (type == Touch.class) {
            return (T)new SpectraTouchFeature(this);
        }
        if (type == Directory.class) {
            return (T)((Object)new SpectraDirectoryFeature(this, (Write<StorageObject>)new SpectraWriteFeature(this)));
        }
        if (type == Move.class) {
            return (T)new DisabledMoveFeature();
        }
        if (type == AclPermission.class) {
            return null;
        }
        if (type == Versioning.class) {
            return (T)new SpectraVersioningFeature(this);
        }
        if (type == Redundancy.class) {
            return null;
        }
        if (type == UrlProvider.class) {
            return (T)new DisabledUrlProvider();
        }
        if (type == Delete.class) {
            return (T)((Object)new SpectraDeleteFeature(this));
        }
        if (type == Copy.class) {
            return null;
        }
        if (type == MultipartWrite.class) {
            return null;
        }
        if (type == Write.class) {
            return (T)((Object)new SpectraWriteFeature(this));
        }
        if (type == Read.class) {
            return (T)new SpectraReadFeature(this, new SpectraBulkService(this));
        }
        if (type == Upload.class) {
            return (T)((Object)new SpectraUploadFeature((Write<StorageObject>)new SpectraWriteFeature(this), new SpectraBulkService(this)));
        }
        if (type == Download.class) {
            return (T)new DefaultDownloadFeature((Read)new SpectraReadFeature(this, new SpectraBulkService(this)));
        }
        if (type == Headers.class || type == Metadata.class) {
            return null;
        }
        if (type == DistributionConfiguration.class) {
            return null;
        }
        return (T)super._getFeature(type);
    }
}

