/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.request;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.request.BaseB2Request;
import synapticloop.b2.response.B2AuthorizeAccountResponse;
import synapticloop.b2.response.B2ListFilesResponse;

public class B2ListFileVersionsRequest
extends BaseB2Request {
    private static final String B2_LIST_FILE_VERSIONS = "/b2api/v2/b2_list_file_versions";
    private static final int DEFAULT_MAX_FILE_COUNT = 100;

    public B2ListFileVersionsRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketId) {
        this(client, b2AuthorizeAccountResponse, bucketId, 100);
    }

    public B2ListFileVersionsRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketId, Integer maxFileCount) {
        this(client, b2AuthorizeAccountResponse, bucketId, maxFileCount, null, null, null, null);
    }

    public B2ListFileVersionsRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketId, Integer maxFileCount, String startFileName, String startFileId, String prefix, String delimiter) {
        super(client, b2AuthorizeAccountResponse, b2AuthorizeAccountResponse.getApiUrl() + B2_LIST_FILE_VERSIONS);
        this.addProperty("bucketId", bucketId);
        this.addProperty("maxFileCount", maxFileCount);
        if (null != startFileName) {
            this.addProperty("startFileName", startFileName);
        }
        if (null != startFileId) {
            this.addProperty("startFileId", startFileId);
        }
        if (null != prefix) {
            this.addProperty("prefix", prefix);
        }
        if (null != delimiter) {
            this.addProperty("delimiter", delimiter);
        }
    }

    public B2ListFilesResponse getResponse() throws B2ApiException, IOException {
        return new B2ListFilesResponse(EntityUtils.toString((HttpEntity)this.executePost().getEntity()));
    }
}

