/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class DefaultCopyFeature
implements Copy {
    private Session<?> from;
    private Session<?> to;

    public DefaultCopyFeature(Session<?> from) {
        this.from = from;
        this.to = from;
    }

    @Override
    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        InputStream in = this.from.getFeature(Read.class).read(source, new TransferStatus(status), callback);
        Write write = this.to.getFeature(MultipartWrite.class);
        if (null == write) {
            write = this.to.getFeature(Write.class);
        }
        StatusOutputStream out = write.write(target, status, callback);
        new StreamCopier(status, status).transfer(in, (OutputStream)((Object)out));
        Object reply = out.getStatus();
        if (reply instanceof VersionId) {
            return new Path(target.getParent(), target.getName(), target.getType(), new PathAttributes(target.attributes()).withVersionId(((VersionId)reply).id));
        }
        return target;
    }

    @Override
    public boolean isSupported(Path source, Path target) {
        switch (this.from.getHost().getProtocol().getType()) {
            case ftp: 
            case irods: {
                return !Objects.equals(this.from, this.to);
            }
        }
        return true;
    }

    @Override
    public DefaultCopyFeature withTarget(Session<?> session) {
        this.to = session;
        return this;
    }
}

