/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.AbstractChecksumCompute;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.transfer.TransferStatus;
import com.twmacinta.util.MD5;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;

public class MD5FastChecksumCompute
extends AbstractChecksumCompute {
    @Override
    public Checksum compute(InputStream in, TransferStatus status) throws ChecksumException {
        return new Checksum(HashAlgorithm.md5, Hex.encodeHexString((byte[])this.digest("MD5", this.normalize(in, status))));
    }

    @Override
    protected byte[] digest(String algorithm, InputStream in) throws ChecksumException {
        MD5 md = new MD5();
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                md.Update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new ChecksumException(LocaleFactory.localizedString("Checksum failure", "Error"), e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return md.Final();
    }

    static {
        MD5.initNativeLibrary((boolean)true);
    }
}

