/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.CredentialsConfigurator;
import ch.cyberduck.core.HostnameConfigurator;
import ch.cyberduck.core.JumphostConfigurator;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractProtocol
implements Protocol {
    @Override
    public String getProvider() {
        return this.getIdentifier();
    }

    @Override
    public boolean isBundled() {
        return false;
    }

    @Override
    public String getName() {
        return this.getScheme().name().toUpperCase(Locale.ROOT);
    }

    @Override
    public String favicon() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public Protocol.Statefulness getStatefulness() {
        return Protocol.Statefulness.stateless;
    }

    @Override
    public String[] getSchemes() {
        LinkedHashSet<String> schemes = new LinkedHashSet<String>(Arrays.asList(this.getIdentifier(), this.getScheme().name()));
        return schemes.toArray(new String[schemes.size()]);
    }

    public String toString() {
        return this.getProvider();
    }

    @Override
    public String disk() {
        return String.format("%s.tiff", this.getIdentifier());
    }

    @Override
    public String icon() {
        return this.disk();
    }

    @Override
    public boolean isSecure() {
        return this.getScheme().isSecure();
    }

    @Override
    public boolean isHostnameConfigurable() {
        return StringUtils.isBlank((CharSequence)this.getDefaultHostname());
    }

    @Override
    public boolean isPortConfigurable() {
        return StringUtils.isBlank((CharSequence)this.getDefaultHostname());
    }

    @Override
    public boolean isPathConfigurable() {
        return true;
    }

    @Override
    public boolean isEncodingConfigurable() {
        return false;
    }

    @Override
    public boolean isAnonymousConfigurable() {
        return false;
    }

    @Override
    public boolean isUsernameConfigurable() {
        return true;
    }

    @Override
    public boolean isPasswordConfigurable() {
        return StringUtils.isBlank((CharSequence)this.getOAuthClientId());
    }

    @Override
    public boolean isTokenConfigurable() {
        return false;
    }

    @Override
    public boolean isOAuthConfigurable() {
        return StringUtils.isNotBlank((CharSequence)this.getOAuthClientId());
    }

    @Override
    public boolean isCertificateConfigurable() {
        return false;
    }

    @Override
    public boolean isPrivateKeyConfigurable() {
        return false;
    }

    @Override
    public boolean isUTCTimezone() {
        return true;
    }

    @Override
    public String getUsernamePlaceholder() {
        return LocaleFactory.localizedString("Username", "Credentials");
    }

    @Override
    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString("Password", "Credentials");
    }

    @Override
    public String getTokenPlaceholder() {
        return this.getPasswordPlaceholder();
    }

    @Override
    public String getOAuthClientId() {
        return null;
    }

    @Override
    public String getOAuthClientSecret() {
        return null;
    }

    @Override
    public String getOAuthRedirectUrl() {
        return null;
    }

    @Override
    public String getDefaultHostname() {
        return PreferencesFactory.get().getProperty("connection.hostname.default");
    }

    @Override
    public Set<Location.Name> getRegions() {
        return Collections.emptySet();
    }

    @Override
    public int getDefaultPort() {
        return this.getScheme().getPort();
    }

    @Override
    public String getDefaultPath() {
        return null;
    }

    @Override
    public String getDefaultNickname() {
        return null;
    }

    @Override
    public String getContext() {
        return null;
    }

    @Override
    public String getAuthorization() {
        return null;
    }

    @Override
    public String getOAuthAuthorizationUrl() {
        return null;
    }

    @Override
    public String getOAuthTokenUrl() {
        return null;
    }

    @Override
    public List<String> getOAuthScopes() {
        return Collections.emptyList();
    }

    @Override
    public String getRegion() {
        return null;
    }

    @Override
    public Protocol.Type getType() {
        return Protocol.Type.valueOf(this.getIdentifier());
    }

    @Override
    public String getPrefix() {
        return String.format("%s.%s", this.getClass().getPackage().getName(), StringUtils.capitalize((String)this.getType().name()));
    }

    @Override
    public boolean validate(Credentials credentials, LoginOptions options) {
        if (options.user && StringUtils.isBlank((CharSequence)credentials.getUsername())) {
            return false;
        }
        if (options.certificate && credentials.isCertificateAuthentication()) {
            return true;
        }
        if (options.publickey) {
            if (credentials.isPublicKeyAuthentication()) {
                return true;
            }
            if (!options.password) {
                return false;
            }
        }
        if (options.password) {
            switch (this.getType()) {
                case ftp: 
                case dav: {
                    return Objects.nonNull(credentials.getPassword());
                }
                case sftp: {
                    return true;
                }
            }
            return StringUtils.isNotBlank((CharSequence)credentials.getPassword());
        }
        if (options.token) {
            return StringUtils.isNotBlank((CharSequence)credentials.getToken());
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Protocol)) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        if (this.getIdentifier() != null ? !this.getIdentifier().equals(protocol.getIdentifier()) : protocol.getIdentifier() != null) {
            return false;
        }
        if (this.getScheme() != null ? !this.getScheme().equals((Object)protocol.getScheme()) : protocol.getScheme() != null) {
            return false;
        }
        return !(this.getProvider() != null ? !this.getProvider().equals(protocol.getProvider()) : protocol.getProvider() != null);
    }

    @Override
    public int compareTo(Protocol o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public int hashCode() {
        int result = this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0;
        result = 31 * result + (this.getScheme() != null ? this.getScheme().hashCode() : 0);
        result = 31 * result + (this.getProvider() != null ? this.getProvider().hashCode() : 0);
        return result;
    }

    @Override
    public CredentialsConfigurator getCredentialsFinder() {
        return CredentialsConfigurator.DISABLED;
    }

    @Override
    public HostnameConfigurator getHostnameFinder() {
        return HostnameConfigurator.DISABLED;
    }

    @Override
    public JumphostConfigurator getJumpHostFinder() {
        return JumphostConfigurator.DISABLED;
    }

    @Override
    public Protocol.Case getCaseSensitivity() {
        return Protocol.Case.sensitive;
    }

    @Override
    public Protocol.DirectoryTimestamp getDirectoryTimestamp() {
        return Protocol.DirectoryTimestamp.implicit;
    }

    @Override
    public Comparator<String> getListComparator() {
        return new NullComparator<String>();
    }

    @Override
    public <T> T getFeature(Class<T> type) {
        return null;
    }
}

