/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveUrlProvider;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import com.google.api.services.drive.Drive;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;

public class DriveReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(DriveReadFeature.class);
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveReadFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public boolean offset(Path file) {
        return true;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (file.getType().contains(AbstractPath.Type.placeholder)) {
            DescriptiveUrl link = new DriveUrlProvider().toUrl(file).find(DescriptiveUrl.Type.http);
            if (DescriptiveUrl.EMPTY.equals((Object)link)) {
                log.warn((Object)String.format("Missing web link for file %s", file));
                return new NullInputStream(file.attributes().getSize());
            }
            return IOUtils.toInputStream((String)UrlFileWriterFactory.get().write(link), (Charset)Charset.defaultCharset());
        }
        try {
            HttpGet request = new HttpGet(String.format("%sdrive/v3/files/%s?alt=media&supportsTeamDrives=%s", ((Drive)this.session.getClient()).getRootUrl(), this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable")));
            return this.read((HttpUriRequest)request, file, status);
        }
        catch (RetriableAccessDeniedException e) {
            throw e;
        }
        catch (AccessDeniedException e) {
            if (!PreferencesFactory.get().getBoolean(String.format("connection.unsecure.download.%s", this.session.getHost().getHostname()))) {
                callback.warn(this.session.getHost(), MessageFormat.format(LocaleFactory.localizedString((String)"Download {0} failed", (String)"Error"), file.getName()), "Acknowledge the risk of downloading known malware or other abusive file.", LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), LocaleFactory.localizedString((String)"Cancel", (String)"Localizable"), String.format("connection.unsecure.download.%s", this.session.getHost().getHostname()));
            }
            HttpGet request = new HttpGet(String.format("%sdrive/v3/files/%s?alt=media&supportsTeamDrives=%s&acknowledgeAbuse=true", ((Drive)this.session.getClient()).getRootUrl(), this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable")));
            return this.read((HttpUriRequest)request, file, status);
        }
    }

    private InputStream read(HttpUriRequest request, Path file, TransferStatus status) throws BackgroundException {
        request.addHeader("Content-Type", "application/json; charset=UTF-8");
        if (status.isAppend()) {
            HttpRange range = HttpRange.withStatus((TransferStatus)status);
            String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Add range header %s for file %s", header, file));
            }
            request.addHeader((Header)new BasicHeader("Range", header));
            request.addHeader((Header)new BasicHeader("Accept-Encoding", "identity"));
        }
        HttpClient client = this.session.getHttpClient();
        try {
            HttpResponse response = client.execute(request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: 
                case 206: {
                    return new HttpMethodReleaseInputStream(response);
                }
            }
            throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Download {0} failed", e, file);
        }
    }
}

