/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.FileSystemInfo;
import org.nuxeo.onedrive.client.types.ItemReference;

public class GraphAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(GraphAttributesFinderFeature.class);
    private final GraphSession session;

    public GraphAttributesFinderFeature(GraphSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        DriveItem item = this.session.toItem(file);
        try {
            DriveItem.Metadata metadata = item.getMetadata();
            return this.toAttributes(metadata);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }

    public PathAttributes toAttributes(DriveItem.Metadata metadata) {
        PathAttributes attributes = new PathAttributes();
        attributes.setETag(metadata.getETag());
        Optional<DescriptiveUrl> webUrl = GraphAttributesFinderFeature.getWebUrl(metadata);
        if (metadata.isPackage()) {
            webUrl.ifPresent(url -> attributes.setSize((long)UrlFileWriterFactory.get().write(url).getBytes(Charset.defaultCharset()).length));
        } else if (null != metadata.getSize()) {
            attributes.setSize(metadata.getSize().longValue());
        }
        ItemReference parent = metadata.getParentReference();
        if (metadata.getRemoteItem() != null) {
            DriveItem.Metadata remoteMetadata = metadata.getRemoteItem();
            ItemReference remoteParent = remoteMetadata.getParentReference();
            if (parent == null) {
                attributes.setVersionId(String.join((CharSequence)String.valueOf('/'), remoteParent.getDriveId(), remoteParent.getId()));
            } else {
                attributes.setVersionId(String.join((CharSequence)String.valueOf('/'), parent.getDriveId(), metadata.getId(), remoteParent.getDriveId(), remoteMetadata.getId()));
            }
        } else {
            attributes.setVersionId(String.join((CharSequence)String.valueOf('/'), parent.getDriveId(), metadata.getId()));
        }
        webUrl.ifPresent(arg_0 -> ((PathAttributes)attributes).setLink(arg_0));
        FileSystemInfo info = (FileSystemInfo)metadata.getFacet(FileSystemInfo.class);
        if (null != info) {
            if (-1L == info.getLastModifiedDateTime().toInstant().toEpochMilli()) {
                attributes.setModificationDate(metadata.getLastModifiedDateTime().toInstant().toEpochMilli());
            } else {
                attributes.setModificationDate(info.getLastModifiedDateTime().toInstant().toEpochMilli());
            }
            if (-1L == info.getCreatedDateTime().toInstant().toEpochMilli()) {
                attributes.setCreationDate(metadata.getCreatedDateTime().toInstant().toEpochMilli());
            } else {
                attributes.setCreationDate(info.getCreatedDateTime().toInstant().toEpochMilli());
            }
        } else {
            attributes.setModificationDate(metadata.getLastModifiedDateTime().toInstant().toEpochMilli());
            attributes.setCreationDate(metadata.getCreatedDateTime().toInstant().toEpochMilli());
        }
        return attributes;
    }

    static Optional<DescriptiveUrl> getWebUrl(DriveItem.Metadata metadata) {
        DescriptiveUrl url = null;
        try {
            url = new DescriptiveUrl(new URI(metadata.getWebUrl()), DescriptiveUrl.Type.http);
        }
        catch (URISyntaxException e) {
            log.warn((Object)String.format("Cannot create URI of WebURL: %s", metadata.getWebUrl()), (Throwable)e);
        }
        return Optional.ofNullable(url);
    }
}

