/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class StoregateWriteFeature
extends AbstractHttpWriteFeature<VersionId> {
    private static final Logger log = Logger.getLogger(StoregateWriteFeature.class);
    private final StoregateSession session;
    private final StoregateIdProvider fileid;
    private final Find finder;
    private final AttributesFinder attributes;

    public StoregateWriteFeature(StoregateSession session, StoregateIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public StoregateWriteFeature(StoregateSession session, StoregateIdProvider fileid, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.fileid = fileid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public HttpResponseOutputStream<VersionId> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<VersionId> command = new DelayedHttpEntityCallable<VersionId>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public VersionId call(AbstractHttpEntity entity) throws BackgroundException {
                String location;
                try {
                    location = StoregateWriteFeature.this.start(file, status);
                }
                catch (InteroperabilityException e) {
                    if (null == status.getLockId()) {
                        throw e;
                    }
                    location = StoregateWriteFeature.this.start(file, status.withLockId(null));
                }
                StoregateApiClient client = (StoregateApiClient)StoregateWriteFeature.this.session.getClient();
                try {
                    String header;
                    HttpPut put = new HttpPut(location);
                    put.setEntity((HttpEntity)entity);
                    if (status.getLength() == 0L) {
                        header = "*/0";
                    } else {
                        HttpRange range = HttpRange.byLength((long)0L, (long)status.getLength());
                        header = String.format("%d-%d/%d", range.getStart(), range.getEnd(), status.getLength());
                    }
                    put.addHeader("Content-Range", String.format("bytes %s", header));
                    CloseableHttpResponse putResponse = client.getClient().execute((HttpUriRequest)put);
                    try {
                        switch (putResponse.getStatusLine().getStatusCode()) {
                            case 200: 
                            case 201: {
                                FileMetadata result = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(putResponse.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                                VersionId version = new VersionId(result.getId());
                                status.setVersion(version);
                                VersionId versionId = version;
                                return versionId;
                            }
                        }
                        throw new StoregateExceptionMappingService().map(new ApiException(putResponse.getStatusLine().getStatusCode(), putResponse.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)putResponse.getEntity())));
                    }
                    catch (BackgroundException e) {
                        StoregateWriteFeature.this.cancel(file, location);
                        throw e;
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)putResponse.getEntity());
                    }
                }
                catch (IOException e) {
                    StoregateWriteFeature.this.cancel(file, location);
                    throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String start(Path file, TransferStatus status) throws BackgroundException {
        try {
            client = (StoregateApiClient)this.session.getClient();
            request = new HttpPost(String.format("%s/v4/upload/resumable", new Object[]{client.getBasePath()}));
            meta = new FileMetadata();
            meta.setId("");
            if (status.isHidden()) {
                meta.setAttributes(2);
            } else {
                meta.setAttributes(0);
            }
            meta.setFlags(0);
            if (status.getLockId() != null) {
                request.addHeader("X-Lock-Id", status.getLockId().toString());
            }
            meta.setFileName(URIEncoder.encode((String)file.getName()));
            meta.setParentId(this.fileid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()));
            meta.setFileSize(status.getLength() > 0L ? Long.valueOf(status.getLength()) : null);
            meta.setCreated(DateTime.now());
            if (null != status.getTimestamp()) {
                meta.setModified(new DateTime((Object)status.getTimestamp()));
            }
            request.setEntity((HttpEntity)new StringEntity(new JSON().getContext(meta.getClass()).writeValueAsString((Object)meta), ContentType.create((String)"application/json", (String)StandardCharsets.UTF_8.name())));
            request.addHeader("Content-Type", "application/json; charset=UTF-8");
            response = client.getClient().execute((HttpUriRequest)request);
            try {
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        ** break;
lbl26:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                    }
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            if (response.containsHeader("Location")) {
                return response.getFirstHeader("Location").getValue();
            }
            throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    protected void cancel(Path file, String location) throws BackgroundException {
        log.warn((Object)String.format("Cancel failed upload %s for %s", location, file));
        try {
            HttpDelete delete = new HttpDelete(location);
            ((StoregateApiClient)this.session.getClient()).getClient().execute((HttpUriRequest)delete);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }
}

