/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.UpdateFilePropertiesRequest;
import ch.cyberduck.core.transfer.TransferStatus;
import org.joda.time.DateTime;

public class StoregateTimestampFeature
extends DefaultTimestampFeature {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateTimestampFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        try {
            FilesApi files = new FilesApi((ApiClient)this.session.getClient());
            files.filesUpdateFile(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), new UpdateFilePropertiesRequest().modified(new DateTime((Object)status.getTimestamp())));
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

