/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateAttributesFinderFeature;
import ch.cyberduck.core.storegate.StoregateCopyFeature;
import ch.cyberduck.core.storegate.StoregateDeleteFeature;
import ch.cyberduck.core.storegate.StoregateDirectoryFeature;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateListService;
import ch.cyberduck.core.storegate.StoregateLockFeature;
import ch.cyberduck.core.storegate.StoregateMoveFeature;
import ch.cyberduck.core.storegate.StoregateMultipartWriteFeature;
import ch.cyberduck.core.storegate.StoregateReadFeature;
import ch.cyberduck.core.storegate.StoregateShareFeature;
import ch.cyberduck.core.storegate.StoregateTimestampFeature;
import ch.cyberduck.core.storegate.StoregateTouchFeature;
import ch.cyberduck.core.storegate.StoregateWriteFeature;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.api.SettingsApi;
import ch.cyberduck.core.storegate.io.swagger.client.api.UsersApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.RootFolder;
import ch.cyberduck.core.storegate.provider.HttpComponentsProvider;
import ch.cyberduck.core.threading.CancelCallback;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.migcomponents.migbase64.Base64;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.internal.InputStreamProvider;

public class StoregateSession
extends HttpSession<StoregateApiClient> {
    private static final Logger log = Logger.getLogger(StoregateSession.class);
    private OAuth2RequestInterceptor authorizationService;
    private List<RootFolder> roots = Collections.emptyList();
    private final StoregateIdProvider fileid = new StoregateIdProvider(this);

    public StoregateSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected StoregateApiClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(proxy, (TranscriptListener)this, prompt).addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                request.addHeader("Authorization", String.format("Basic %s", Base64.encodeToString((byte[])String.format("%s:%s", StoregateSession.this.host.getProtocol().getOAuthClientId(), StoregateSession.this.host.getProtocol().getOAuthClientSecret()).getBytes(StandardCharsets.UTF_8), (boolean)false)));
            }
        }).build(), this.host).withRedirectUri(OAuth2AuthorizationService.CYBERDUCK_REDIRECT_URI.equals(this.host.getProtocol().getOAuthRedirectUrl()) ? this.host.getProtocol().getOAuthRedirectUrl() : (Scheme.isURL((String)this.host.getProtocol().getOAuthRedirectUrl()) ? this.host.getProtocol().getOAuthRedirectUrl() : new HostUrlProvider().withUsername(false).withPath(true).get(this.host.getProtocol().getScheme(), this.host.getPort(), null, this.host.getHostname(), this.host.getProtocol().getOAuthRedirectUrl())));
        this.authorizationService.withParameter("prompt", "login");
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        CloseableHttpClient apache = configuration.build();
        StoregateApiClient client = new StoregateApiClient(apache);
        client.setBasePath(new HostUrlProvider().withUsername(false).withPath(true).get(this.host.getProtocol().getScheme(), this.host.getPort(), null, this.host.getHostname(), this.host.getProtocol().getContext()));
        client.setHttpClient(ClientBuilder.newClient((Configuration)new ClientConfig().register((Object)new InputStreamProvider()).register(MultiPartFeature.class).register((Object)new JSON()).register(JacksonFeature.class).connectorProvider((ConnectorProvider)new HttpComponentsProvider(apache))));
        int timeout = PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000;
        client.setConnectTimeout(timeout);
        client.setReadTimeout(timeout);
        client.setUserAgent(new PreferencesUseragentProvider().get());
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void login(Proxy proxy, LoginCallback controller, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, controller, cancel));
        try {
            request = new HttpPost(new HostUrlProvider().withUsername(false).withPath(true).get(this.host.getProtocol().getScheme(), this.host.getPort(), null, this.host.getHostname(), "/identity/core/connect/userinfo"));
            request.addHeader("Content-Type", "application/json; charset=UTF-8");
            response = ((StoregateApiClient)this.client).getClient().execute((HttpUriRequest)request);
            try {
                switch (response.getStatusLine().getStatusCode()) {
                    case 200: {
                        try {
                            element = JsonParser.parseReader((Reader)new InputStreamReader(response.getEntity().getContent()));
                            if (element.isJsonObject()) {
                                json = element.getAsJsonObject();
                                url = URI.create(json.getAsJsonPrimitive("web_url_api").getAsString());
                                if (StoregateSession.log.isInfoEnabled()) {
                                    StoregateSession.log.info((Object)String.format("Set base path to %s", new Object[]{url}));
                                }
                                ((StoregateApiClient)this.client).setBasePath(StringUtils.removeEnd((String)url.toString(), (String)String.valueOf('/')));
                                ** break;
lbl19:
                                // 1 sources

                            }
                        }
                        catch (JsonParseException | IllegalArgumentException e) {
                            StoregateSession.log.warn((Object)String.format("Ignore failure %s", new Object[]{e}));
                            ** break;
                        }
lbl24:
                        // 1 sources

                        break;
                    }
                    case 403: {
                        failure = new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                        throw new LoginFailureException(failure.getDetail(), (Throwable)failure);
                    }
                    default: {
                        throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                    }
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            me = new UsersApi((ApiClient)this.client).usersGetMe();
            if (StoregateSession.log.isDebugEnabled()) {
                StoregateSession.log.debug((Object)String.format("Authenticated for user %s", new Object[]{me}));
            }
            credentials = this.host.getCredentials();
            credentials.setUsername(me.getUsername());
            this.roots = new SettingsApi((ApiClient)this.client).settingsGetRootfolders();
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map(e);
        }
        catch (IOException e) {
            new DefaultIOExceptionMappingService().map(e);
        }
    }

    public List<RootFolder> roots() {
        return this.roots;
    }

    protected void logout() {
        ((StoregateApiClient)this.client).getHttpClient().close();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == IdProvider.class) {
            return (T)this.fileid;
        }
        if (type == ListService.class) {
            return (T)new StoregateListService(this, this.fileid);
        }
        if (type == Read.class) {
            return (T)new StoregateReadFeature(this, this.fileid);
        }
        if (type == Write.class) {
            return (T)((Object)new StoregateWriteFeature(this, this.fileid));
        }
        if (type == MultipartWrite.class) {
            return (T)new StoregateMultipartWriteFeature(this, this.fileid);
        }
        if (type == Touch.class) {
            return (T)new StoregateTouchFeature(this, this.fileid);
        }
        if (type == Move.class) {
            return (T)new StoregateMoveFeature(this, this.fileid);
        }
        if (type == Copy.class) {
            return (T)new StoregateCopyFeature(this, this.fileid);
        }
        if (type == Directory.class) {
            return (T)new StoregateDirectoryFeature(this, this.fileid);
        }
        if (type == Delete.class) {
            return (T)new StoregateDeleteFeature(this, this.fileid);
        }
        if (type == AttributesFinder.class) {
            return (T)new StoregateAttributesFinderFeature(this, this.fileid);
        }
        if (type == Lock.class) {
            return (T)new StoregateLockFeature(this, this.fileid);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new StoregateShareFeature(this, this.fileid);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new StoregateTimestampFeature(this, this.fileid));
        }
        return (T)super._getFeature(type);
    }
}

