/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.StoregateWriteFeature;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class StoregateMultipartWriteFeature
implements MultipartWrite<VersionId> {
    private static final Logger log = Logger.getLogger(StoregateMultipartWriteFeature.class);
    private final StoregateSession session;
    private final StoregateIdProvider fileid;
    private final Find finder;
    private final AttributesFinder attributes;

    public StoregateMultipartWriteFeature(StoregateSession session, StoregateIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public StoregateMultipartWriteFeature(StoregateSession session, StoregateIdProvider fileid, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.fileid = fileid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public HttpResponseOutputStream<VersionId> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        String location = new StoregateWriteFeature(this.session, this.fileid).start(file, status);
        final MultipartOutputStream proxy = new MultipartOutputStream(location, file, status);
        return new HttpResponseOutputStream<VersionId>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(PreferencesFactory.get().getInteger("storegate.upload.multipart.chunksize")))){

            public VersionId getStatus() {
                return proxy.getVersionId();
            }
        };
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final String location;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<BackgroundException> canceled = new AtomicReference();
        private Long offset = 0L;
        private final Long length;

        public MultipartOutputStream(String location, Path file, TransferStatus status) {
            this.location = location;
            this.file = file;
            this.overall = status;
            this.length = status.getOffset() + status.getLength();
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                if (null != this.canceled.get()) {
                    throw this.canceled.get();
                }
                final byte[] content = Arrays.copyOfRange(b, off, len);
                new DefaultRetryCallable(StoregateMultipartWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Void call() throws BackgroundException {
                        StoregateApiClient client = (StoregateApiClient)StoregateMultipartWriteFeature.this.session.getClient();
                        try {
                            HttpEntity entity = EntityBuilder.create().setBinary(content).build();
                            HttpPut put = new HttpPut(MultipartOutputStream.this.location);
                            put.setEntity(entity);
                            if (0L != MultipartOutputStream.this.overall.getLength() && 0 != content.length) {
                                HttpRange range = HttpRange.byLength((long)MultipartOutputStream.this.offset, (long)content.length);
                                String header = MultipartOutputStream.this.overall.getLength() == -1L ? String.format("%d-%d/*", range.getStart(), range.getEnd()) : String.format("%d-%d/%d", range.getStart(), range.getEnd(), MultipartOutputStream.this.length);
                                put.addHeader("Content-Range", String.format("bytes %s", header));
                            }
                            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)put);
                            try {
                                switch (response.getStatusLine().getStatusCode()) {
                                    case 200: 
                                    case 201: {
                                        FileMetadata result = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                                        MultipartOutputStream.this.overall.setVersion(new VersionId(result.getId()));
                                    }
                                    case 204: {
                                        MultipartOutputStream.this.offset = MultipartOutputStream.this.offset + (long)content.length;
                                        return null;
                                    }
                                    default: {
                                        throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                                    }
                                }
                            }
                            catch (BackgroundException e) {
                                new StoregateWriteFeature(StoregateMultipartWriteFeature.this.session, StoregateMultipartWriteFeature.this.fileid).cancel(MultipartOutputStream.this.file, MultipartOutputStream.this.location);
                                MultipartOutputStream.this.canceled.set(e);
                                throw e;
                            }
                            finally {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                        }
                        catch (IOException e) {
                            throw new DefaultIOExceptionMappingService().map(e);
                        }
                    }
                }, (StreamCancelation)this.overall).call();
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                if (null != this.canceled.get()) {
                    return;
                }
                if (this.overall.getLength() > 0L) return;
                StoregateApiClient client = (StoregateApiClient)StoregateMultipartWriteFeature.this.session.getClient();
                HttpPut put = new HttpPut(this.location);
                put.addHeader("Content-Range", "bytes */0");
                CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)put);
                try {
                    switch (response.getStatusLine().getStatusCode()) {
                        case 200: 
                        case 201: {
                            FileMetadata result = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                            this.overall.setVersion(new VersionId(result.getId()));
                        }
                        case 204: {
                            return;
                        }
                        default: {
                            throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                        }
                    }
                }
                catch (BackgroundException e) {
                    throw new IOException(e);
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            finally {
                this.close.set(true);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("id='").append(this.location).append('\'');
            sb.append(", file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }

        public VersionId getVersionId() {
            return this.overall.getVersion();
        }
    }
}

