/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.storegate.StoregateAttributesFinderFeature;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileContents;
import ch.cyberduck.core.storegate.io.swagger.client.model.RootFolder;
import java.util.EnumSet;

public class StoregateListService
implements ListService {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;
    private final int chunksize = PreferencesFactory.get().getInteger("storegate.listing.chunksize");

    public StoregateListService(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            AttributedList list = new AttributedList();
            for (RootFolder root : this.session.roots()) {
                switch (root.getRootFolderType()) {
                    case 0: 
                    case 1: {
                        PathAttributes attr = new PathAttributes().withVersionId(root.getId());
                        attr.setModificationDate(root.getModified().getMillis());
                        attr.setCreationDate(root.getCreated().getMillis());
                        list.add((Referenceable)new Path(PathNormalizer.normalize((String)root.getName()), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attr));
                    }
                }
            }
            listener.chunk(directory, list);
            return list;
        }
        try {
            FileContents files;
            AttributedList children = new AttributedList();
            StoregateAttributesFinderFeature attributes = new StoregateAttributesFinderFeature(this.session, this.fileid);
            int pageIndex = 0;
            do {
                files = new FilesApi((ApiClient)this.session.getClient()).filesGet(URIEncoder.encode((String)this.fileid.getPrefixedPath(directory)), pageIndex, this.chunksize, "Name asc", 0, true, false, false);
                for (File f : files.getFiles()) {
                    PathAttributes attrs = attributes.toAttributes(f);
                    EnumSet<AbstractPath.Type> type = (f.getFlags() & 1) == 1 ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file);
                    Path p = new Path(directory, f.getName(), type, attrs);
                    children.add((Referenceable)p);
                    listener.chunk(directory, children);
                }
                ++pageIndex;
            } while (children.size() < files.getTotalRowCount());
            return children;
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    public ListService withCache(Cache<Path> cache) {
        this.fileid.withCache((Cache)cache);
        return this;
    }
}

