/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;

public class QueryStringBuilder {
    private Map<String, String> parameters = new HashMap<String, String>();

    public QueryStringBuilder set(String key, int value) {
        return this.set(key, Integer.toString(value));
    }

    public QueryStringBuilder set(String key, long value) {
        return this.set(key, Long.toString(value));
    }

    public QueryStringBuilder set(String key, boolean value) {
        return this.set(key, Boolean.toString(value));
    }

    public QueryStringBuilder set(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public QueryStringBuilder set(String key, QueryStringCommaParameter ... parameters) {
        if (parameters != null && parameters.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (QueryStringCommaParameter parameter : parameters) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(parameter.getKey());
            }
            this.parameters.put(key, builder.toString());
        }
        return this;
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return "";
        }
        try {
            StringBuilder builder = new StringBuilder("?");
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                if (builder.length() != 1) {
                    builder.append("&");
                }
                builder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
        }
    }
}

