/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.DictionaryMatcher;
import com.nulabinc.zxcvbn.matchers.L33tSubsEnumerator;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class L33tMatcher
extends BaseMatcher {
    private final Map<String, Map<String, Integer>> rankedDictionaries;
    private static final Map<Character, Character[]> L33T_TABLE = new HashMap<Character, Character[]>();

    public L33tMatcher() {
        this(new HashMap<String, Map<String, Integer>>());
    }

    public L33tMatcher(Map<String, Map<String, Integer>> rankedDictionaries) {
        if (rankedDictionaries == null) {
            rankedDictionaries = new HashMap<String, Map<String, Integer>>();
        }
        this.rankedDictionaries = rankedDictionaries;
    }

    public HashMap<Character, Character[]> relevantL33tSubTable(CharSequence password) {
        return this.relevantL33tSubTable(password, L33T_TABLE);
    }

    public HashMap<Character, Character[]> relevantL33tSubTable(CharSequence password, Map<Character, Character[]> table) {
        HashMap<Character, Boolean> passwordChars = new HashMap<Character, Boolean>();
        for (int n = 0; n < password.length(); ++n) {
            passwordChars.put(Character.valueOf(password.charAt(n)), true);
        }
        HashMap<Character, Character[]> subTable = new HashMap<Character, Character[]>();
        for (Map.Entry<Character, Character[]> l33tRowRef : table.entrySet()) {
            Character letter = l33tRowRef.getKey();
            Character[] subs = l33tRowRef.getValue();
            ArrayList<Character> relevantSubs = new ArrayList<Character>();
            for (Character sub : subs) {
                if (!passwordChars.containsKey(sub)) continue;
                relevantSubs.add(sub);
            }
            if (relevantSubs.size() <= 0) continue;
            subTable.put(letter, relevantSubs.toArray(new Character[0]));
        }
        return subTable;
    }

    @Override
    public List<Match> execute(CharSequence password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        HashMap<Character, Character[]> subTable = this.relevantL33tSubTable(password);
        L33tSubsEnumerator l33tSubs = new L33tSubsEnumerator(subTable);
        List<Map<Character, Character>> subs = l33tSubs.enumerate();
        for (Map<Character, Character> sub : subs) {
            if (sub.isEmpty()) break;
            CharSequence subbedPassword = this.translate(password, sub);
            for (Match match : new DictionaryMatcher(this.rankedDictionaries).execute(subbedPassword)) {
                WipeableString token = WipeableString.copy(password, match.i, match.j + 1);
                WipeableString lower = WipeableString.lowerCase(token);
                if (lower.equals(match.matchedWord)) {
                    token.wipe();
                    lower.wipe();
                    continue;
                }
                HashMap<Character, Character> matchSub = new HashMap<Character, Character>();
                for (Map.Entry<Character, Character> entry : sub.entrySet()) {
                    Character subbedChr = entry.getKey();
                    Character chr = entry.getValue();
                    if (token.indexOf(subbedChr.charValue()) == -1) continue;
                    matchSub.put(subbedChr, chr);
                }
                ArrayList<String> subDisplays = new ArrayList<String>();
                for (Map.Entry matchSubRef : matchSub.entrySet()) {
                    Character k = (Character)matchSubRef.getKey();
                    Character v = (Character)matchSubRef.getValue();
                    subDisplays.add(String.format("%s -> %s", k, v));
                }
                String string = Arrays.toString(subDisplays.toArray(new String[0]));
                matches.add(MatchFactory.createDictionaryL33tMatch(match.i, match.j, token, match.matchedWord, match.rank, match.dictionaryName, match.reversed, matchSub, string));
                lower.wipe();
            }
        }
        ArrayList<Match> lst = new ArrayList<Match>();
        for (Match match : matches) {
            if (match.tokenLength() <= 1) continue;
            lst.add(match);
        }
        return this.sorted(lst);
    }

    static {
        L33T_TABLE.put(Character.valueOf('a'), new Character[]{Character.valueOf('4'), Character.valueOf('@')});
        L33T_TABLE.put(Character.valueOf('b'), new Character[]{Character.valueOf('8')});
        L33T_TABLE.put(Character.valueOf('c'), new Character[]{Character.valueOf('('), Character.valueOf('{'), Character.valueOf('['), Character.valueOf('<')});
        L33T_TABLE.put(Character.valueOf('e'), new Character[]{Character.valueOf('3')});
        L33T_TABLE.put(Character.valueOf('g'), new Character[]{Character.valueOf('6'), Character.valueOf('9')});
        L33T_TABLE.put(Character.valueOf('i'), new Character[]{Character.valueOf('1'), Character.valueOf('!'), Character.valueOf('|')});
        L33T_TABLE.put(Character.valueOf('l'), new Character[]{Character.valueOf('1'), Character.valueOf('|'), Character.valueOf('7')});
        L33T_TABLE.put(Character.valueOf('o'), new Character[]{Character.valueOf('0')});
        L33T_TABLE.put(Character.valueOf('s'), new Character[]{Character.valueOf('$'), Character.valueOf('5')});
        L33T_TABLE.put(Character.valueOf('t'), new Character[]{Character.valueOf('+'), Character.valueOf('7')});
        L33T_TABLE.put(Character.valueOf('x'), new Character[]{Character.valueOf('%')});
        L33T_TABLE.put(Character.valueOf('z'), new Character[]{Character.valueOf('2')});
    }
}

