/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaClient;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.util.MantaUtils;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PruneEmptyParentDirectoryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PruneEmptyParentDirectoryStrategy.class);
    public static final Integer PRUNE_ALL_PARENTS = -1;

    private PruneEmptyParentDirectoryStrategy() {
    }

    static void pruneParentDirectories(MantaClient client, MantaHttpHeaders headers, String path, int maxDepth) throws IOException {
        int effectiveMaxDepth;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pruning first object: {}", (Object)path);
        }
        client.delete(path, headers, null);
        String[] directories = PruneEmptyParentDirectoryStrategy.extractOrderedWriteableAncestorPaths(path);
        if (maxDepth > directories.length) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Limit [{}] was set to greater than the number of directories in path [{}]", (Object)maxDepth, (Object)directories.length);
            }
            effectiveMaxDepth = directories.length;
        } else if (maxDepth == PRUNE_ALL_PARENTS) {
            effectiveMaxDepth = directories.length;
        } else {
            if (maxDepth < PRUNE_ALL_PARENTS) {
                String msg = String.format("The prune directory limit specified [%d] is less than the minimum value of -1", maxDepth);
                throw new IllegalArgumentException(msg);
            }
            effectiveMaxDepth = maxDepth;
        }
        for (int i = 0; i < effectiveMaxDepth; ++i) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Pruning directory[{}] at path: {}", (Object)i, (Object)directories[i]);
                }
                client.delete(directories[i], headers, null);
                continue;
            }
            catch (MantaClientHttpResponseException responseException) {
                switch (responseException.getServerCode()) {
                    case RESOURCE_NOT_FOUND_ERROR: {
                        LOG.debug("Directory not found: {}", (Object)directories[i]);
                        return;
                    }
                    case DIRECTORY_NOT_EMPTY_ERROR: {
                        LOG.debug("Directory not empty: {}", (Object)directories[i]);
                        return;
                    }
                }
                throw responseException;
            }
        }
    }

    static String[] extractOrderedWriteableAncestorPaths(String path) {
        Object[] directories = MantaUtils.writeablePrefixPaths(path);
        ArrayUtils.reverse((Object[])directories);
        directories = (String[])ArrayUtils.remove((Object[])directories, (int)0);
        return directories;
    }
}

