/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Request model for updating a S3 configuration")
public class S3ConfigUpdateRequest {
    @JsonProperty(value="bucketUrl")
    private String bucketUrl = null;
    @JsonProperty(value="accessKey")
    private String accessKey = null;
    @JsonProperty(value="secretKey")
    private String secretKey = null;
    @JsonProperty(value="region")
    private String region = null;
    @JsonProperty(value="endpointUrl")
    private String endpointUrl = null;
    @JsonProperty(value="bucketName")
    private String bucketName = null;

    public S3ConfigUpdateRequest bucketUrl(String bucketUrl) {
        this.bucketUrl = bucketUrl;
        return this;
    }

    @Schema(description="S3 object storage bucket URL")
    public String getBucketUrl() {
        return this.bucketUrl;
    }

    public void setBucketUrl(String bucketUrl) {
        this.bucketUrl = bucketUrl;
    }

    public S3ConfigUpdateRequest accessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    @Schema(description="Access Key ID")
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public S3ConfigUpdateRequest secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Schema(description="Secret Access Key")
    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public S3ConfigUpdateRequest region(String region) {
        this.region = region;
        return this;
    }

    @Schema(description="S3 region")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public S3ConfigUpdateRequest endpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.24.0  S3 object storage endpoint URL  use `bucketUrl` instead")
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public S3ConfigUpdateRequest bucketName(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.24.0  S3 bucket name  use `bucketUrl` instead")
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ConfigUpdateRequest s3ConfigUpdateRequest = (S3ConfigUpdateRequest)o;
        return Objects.equals(this.bucketUrl, s3ConfigUpdateRequest.bucketUrl) && Objects.equals(this.accessKey, s3ConfigUpdateRequest.accessKey) && Objects.equals(this.secretKey, s3ConfigUpdateRequest.secretKey) && Objects.equals(this.region, s3ConfigUpdateRequest.region) && Objects.equals(this.endpointUrl, s3ConfigUpdateRequest.endpointUrl) && Objects.equals(this.bucketName, s3ConfigUpdateRequest.bucketName);
    }

    public int hashCode() {
        return Objects.hash(this.bucketUrl, this.accessKey, this.secretKey, this.region, this.endpointUrl, this.bucketName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class S3ConfigUpdateRequest {\n");
        sb.append("    bucketUrl: ").append(this.toIndentedString(this.bucketUrl)).append("\n");
        sb.append("    accessKey: ").append(this.toIndentedString(this.accessKey)).append("\n");
        sb.append("    secretKey: ").append(this.toIndentedString(this.secretKey)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    endpointUrl: ").append(this.toIndentedString(this.endpointUrl)).append("\n");
        sb.append("    bucketName: ").append(this.toIndentedString(this.bucketName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

