/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.dropbox.core.v2.common.PathRoot;
import org.apache.commons.lang3.StringUtils;

public class DropboxPathContainerService
extends PathContainerService {
    private boolean useNamespace = false;

    public DropboxPathContainerService withNamespace(boolean useNamespace) {
        this.useNamespace = useNamespace;
        return this;
    }

    public boolean isContainer(Path file) {
        if (file.isRoot()) {
            return true;
        }
        if (super.isContainer(file)) {
            return file.getType().contains(AbstractPath.Type.volume);
        }
        return false;
    }

    public String getKey(Path file) {
        Path container;
        String namespace;
        if (PreferencesFactory.get().getBoolean("dropbox.business.enable") && StringUtils.isNotBlank((CharSequence)(namespace = (container = this.getContainer(file)).attributes().getVersionId()))) {
            String key;
            if (file.isRoot()) {
                if (this.useNamespace) {
                    return String.format("ns:%s", namespace);
                }
                return "";
            }
            String string = key = this.isContainer(file) ? "" : '/' + super.getKey(file);
            if (this.useNamespace) {
                return String.format("ns:%s%s", namespace, key);
            }
            return key;
        }
        return file.isRoot() ? "" : file.getAbsolute();
    }

    protected PathRoot getNamespace(Path file) {
        Path container;
        if (PreferencesFactory.get().getBoolean("dropbox.business.enable") && StringUtils.isNotBlank((CharSequence)(container = this.getContainer(file)).attributes().getVersionId())) {
            return PathRoot.namespaceId((String)container.attributes().getVersionId());
        }
        return PathRoot.HOME;
    }
}

