/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.urlhandler;

import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.urlhandler.AbstractSchemeHandler;
import java.util.ArrayList;
import java.util.List;

public final class LaunchServicesSchemeHandler
extends AbstractSchemeHandler {
    private ApplicationFinder applicationFinder;

    public LaunchServicesSchemeHandler() {
        this(ApplicationFinderFactory.get());
    }

    public LaunchServicesSchemeHandler(ApplicationFinder applicationFinder) {
        this.applicationFinder = applicationFinder;
    }

    public void setDefaultHandler(Application application, List<String> schemes) {
        for (String scheme : schemes) {
            this.setDefaultHandlerForURLScheme(scheme, application.getIdentifier());
        }
    }

    private native void setDefaultHandlerForURLScheme(String var1, String var2);

    public Application getDefaultHandler(String scheme) {
        Application application = this.applicationFinder.getDescription(this.getDefaultHandlerForURLScheme(scheme));
        if (this.applicationFinder.isInstalled(application)) {
            return application;
        }
        return Application.notfound;
    }

    private native String getDefaultHandlerForURLScheme(String var1);

    public List<Application> getAllHandlers(String scheme) {
        ArrayList<Application> handlers = new ArrayList<Application>();
        for (String bundleIdentifier : this.getAllHandlersForURLScheme(scheme)) {
            Application application = this.applicationFinder.getDescription(bundleIdentifier);
            if (!this.applicationFinder.isInstalled(application)) continue;
            handlers.add(application);
        }
        return handlers;
    }

    private native String[] getAllHandlersForURLScheme(String var1);

    static {
        Native.load((String)"core");
    }
}

