/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveRemoteItem;

public class GraphAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(GraphAttributesFinderFeature.class);
    private final GraphSession session;

    public GraphAttributesFinderFeature(GraphSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        OneDriveItem item = this.session.toItem(file);
        try {
            OneDriveItem.Metadata metadata = item.getMetadata(new OneDriveExpand[0]);
            return this.toAttributes(metadata);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }

    public PathAttributes toAttributes(OneDriveItem.Metadata metadata) {
        PathAttributes attributes = new PathAttributes();
        attributes.setETag(metadata.getETag());
        attributes.setSize(metadata.getSize());
        if (metadata instanceof OneDriveRemoteItem.Metadata) {
            OneDriveRemoteItem.Metadata remoteMetadata = (OneDriveRemoteItem.Metadata)metadata;
            OneDriveItem.Metadata originMetadata = remoteMetadata.getRemoteItem();
            attributes.setVersionId(String.join((CharSequence)String.valueOf('/'), metadata.getParentReference().getDriveId(), metadata.getId(), originMetadata.getParentReference().getDriveId(), originMetadata.getId()));
        } else {
            attributes.setVersionId(String.join((CharSequence)String.valueOf('/'), metadata.getParentReference().getDriveId(), metadata.getId()));
        }
        try {
            attributes.setLink(new DescriptiveUrl(new URI(metadata.getWebUrl()), DescriptiveUrl.Type.http));
        }
        catch (URISyntaxException e) {
            log.warn((Object)String.format("Cannot set link. Web URL returned %s", metadata.getWebUrl()), (Throwable)e);
        }
        if (null != metadata.getFileSystemInfo()) {
            if (-1L == metadata.getFileSystemInfo().getLastModifiedDateTime().toInstant().toEpochMilli()) {
                attributes.setModificationDate(metadata.getLastModifiedDateTime().toInstant().toEpochMilli());
            } else {
                attributes.setModificationDate(metadata.getFileSystemInfo().getLastModifiedDateTime().toInstant().toEpochMilli());
            }
            if (-1L == metadata.getFileSystemInfo().getCreatedDateTime().toInstant().toEpochMilli()) {
                attributes.setCreationDate(metadata.getCreatedDateTime().toInstant().toEpochMilli());
            } else {
                attributes.setCreationDate(metadata.getFileSystemInfo().getCreatedDateTime().toInstant().toEpochMilli());
            }
        } else {
            attributes.setModificationDate(metadata.getLastModifiedDateTime().toInstant().toEpochMilli());
            attributes.setCreationDate(metadata.getCreatedDateTime().toInstant().toEpochMilli());
        }
        return attributes;
    }
}

