/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OpenIdProvider {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="issuer")
    private String issuer = null;
    @JsonProperty(value="mappingClaim")
    private String mappingClaim = null;
    @JsonProperty(value="isGlobalAvailable")
    private Boolean isGlobalAvailable = null;

    public OpenIdProvider id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public OpenIdProvider name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the IDP")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OpenIdProvider issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @ApiModelProperty(example="https://www.random-url.com", required=true, value="Issuer identifier of the IDP The value is a case sensitive URL.")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public OpenIdProvider mappingClaim(String mappingClaim) {
        this.mappingClaim = mappingClaim;
        return this;
    }

    @ApiModelProperty(example="email", required=true, value="Name of the claim which is used for the user mapping.")
    public String getMappingClaim() {
        return this.mappingClaim;
    }

    public void setMappingClaim(String mappingClaim) {
        this.mappingClaim = mappingClaim;
    }

    public OpenIdProvider isGlobalAvailable(Boolean isGlobalAvailable) {
        this.isGlobalAvailable = isGlobalAvailable;
        return this;
    }

    @ApiModelProperty(example="false", value="Is available for all customers")
    public Boolean isIsGlobalAvailable() {
        return this.isGlobalAvailable;
    }

    public void setIsGlobalAvailable(Boolean isGlobalAvailable) {
        this.isGlobalAvailable = isGlobalAvailable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIdProvider openIdProvider = (OpenIdProvider)o;
        return Objects.equals(this.id, openIdProvider.id) && Objects.equals(this.name, openIdProvider.name) && Objects.equals(this.issuer, openIdProvider.issuer) && Objects.equals(this.mappingClaim, openIdProvider.mappingClaim) && Objects.equals(this.isGlobalAvailable, openIdProvider.isGlobalAvailable);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.issuer, this.mappingClaim, this.isGlobalAvailable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdProvider {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    mappingClaim: ").append(this.toIndentedString(this.mappingClaim)).append("\n");
        sb.append("    isGlobalAvailable: ").append(this.toIndentedString(this.isGlobalAvailable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

