/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.MoveNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MoveNodesRequest {
    @JsonProperty(value="items")
    private List<MoveNode> items = null;
    @JsonProperty(value="resolutionStrategy")
    private ResolutionStrategyEnum resolutionStrategy = null;
    @JsonProperty(value="keepShareLinks")
    private Boolean keepShareLinks = null;
    @JsonProperty(value="nodeIds")
    private List<Long> nodeIds = null;

    public MoveNodesRequest items(List<MoveNode> items) {
        this.items = items;
        return this;
    }

    public MoveNodesRequest addItemsItem(MoveNode itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<MoveNode>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="List of nodes to be moved")
    public List<MoveNode> getItems() {
        return this.items;
    }

    public void setItems(List<MoveNode> items) {
        this.items = items;
    }

    public MoveNodesRequest resolutionStrategy(ResolutionStrategyEnum resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
        return this;
    }

    @ApiModelProperty(example="autorename", value="Node conflict resolution strategy: * `autorename` * `overwrite` * `fail`  (default: `autorename`)")
    public ResolutionStrategyEnum getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public void setResolutionStrategy(ResolutionStrategyEnum resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
    }

    public MoveNodesRequest keepShareLinks(Boolean keepShareLinks) {
        this.keepShareLinks = keepShareLinks;
        return this;
    }

    @ApiModelProperty(example="false", value="Preserve Download Share Links and point them to the new node. (default: `false`)")
    public Boolean isKeepShareLinks() {
        return this.keepShareLinks;
    }

    public void setKeepShareLinks(Boolean keepShareLinks) {
        this.keepShareLinks = keepShareLinks;
    }

    public MoveNodesRequest nodeIds(List<Long> nodeIds) {
        this.nodeIds = nodeIds;
        return this;
    }

    public MoveNodesRequest addNodeIdsItem(Long nodeIdsItem) {
        if (this.nodeIds == null) {
            this.nodeIds = new ArrayList<Long>();
        }
        this.nodeIds.add(nodeIdsItem);
        return this;
    }

    @ApiModelProperty(value="`DEPRECATED`: Node IDs Please use `items` instead.")
    public List<Long> getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(List<Long> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoveNodesRequest moveNodesRequest = (MoveNodesRequest)o;
        return Objects.equals(this.items, moveNodesRequest.items) && Objects.equals((Object)this.resolutionStrategy, (Object)moveNodesRequest.resolutionStrategy) && Objects.equals(this.keepShareLinks, moveNodesRequest.keepShareLinks) && Objects.equals(this.nodeIds, moveNodesRequest.nodeIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.items, this.resolutionStrategy, this.keepShareLinks, this.nodeIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MoveNodesRequest {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    resolutionStrategy: ").append(this.toIndentedString((Object)this.resolutionStrategy)).append("\n");
        sb.append("    keepShareLinks: ").append(this.toIndentedString(this.keepShareLinks)).append("\n");
        sb.append("    nodeIds: ").append(this.toIndentedString(this.nodeIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResolutionStrategyEnum {
        AUTORENAME("autorename"),
        OVERWRITE("overwrite"),
        FAIL("fail");

        private String value;

        private ResolutionStrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResolutionStrategyEnum fromValue(String text) {
            for (ResolutionStrategyEnum b : ResolutionStrategyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

