/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class CustomerData {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="isProviderCustomer")
    private Boolean isProviderCustomer = null;
    @JsonProperty(value="spaceLimit")
    private Long spaceLimit = null;
    @JsonProperty(value="spaceUsed")
    private Long spaceUsed = null;
    @JsonProperty(value="accountsLimit")
    private Integer accountsLimit = null;
    @JsonProperty(value="accountsUsed")
    private Integer accountsUsed = null;
    @JsonProperty(value="customerEncryptionEnabled")
    private Boolean customerEncryptionEnabled = null;
    @JsonProperty(value="cntFiles")
    private Long cntFiles = null;
    @JsonProperty(value="cntFolders")
    private Long cntFolders = null;
    @JsonProperty(value="cntRooms")
    private Long cntRooms = null;

    public CustomerData id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the customer")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CustomerData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Customer name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomerData isProviderCustomer(Boolean isProviderCustomer) {
        this.isProviderCustomer = isProviderCustomer;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Customer is Provider Customer")
    public Boolean isIsProviderCustomer() {
        return this.isProviderCustomer;
    }

    public void setIsProviderCustomer(Boolean isProviderCustomer) {
        this.isProviderCustomer = isProviderCustomer;
    }

    public CustomerData spaceLimit(Long spaceLimit) {
        this.spaceLimit = spaceLimit;
        return this;
    }

    @ApiModelProperty(required=true, value="Space limit (in bytes)")
    public Long getSpaceLimit() {
        return this.spaceLimit;
    }

    public void setSpaceLimit(Long spaceLimit) {
        this.spaceLimit = spaceLimit;
    }

    public CustomerData spaceUsed(Long spaceUsed) {
        this.spaceUsed = spaceUsed;
        return this;
    }

    @ApiModelProperty(required=true, value="Space used (in bytes)")
    public Long getSpaceUsed() {
        return this.spaceUsed;
    }

    public void setSpaceUsed(Long spaceUsed) {
        this.spaceUsed = spaceUsed;
    }

    public CustomerData accountsLimit(Integer accountsLimit) {
        this.accountsLimit = accountsLimit;
        return this;
    }

    @ApiModelProperty(required=true, value="User accounts limit")
    public Integer getAccountsLimit() {
        return this.accountsLimit;
    }

    public void setAccountsLimit(Integer accountsLimit) {
        this.accountsLimit = accountsLimit;
    }

    public CustomerData accountsUsed(Integer accountsUsed) {
        this.accountsUsed = accountsUsed;
        return this;
    }

    @ApiModelProperty(required=true, value="User accounts used")
    public Integer getAccountsUsed() {
        return this.accountsUsed;
    }

    public void setAccountsUsed(Integer accountsUsed) {
        this.accountsUsed = accountsUsed;
    }

    public CustomerData customerEncryptionEnabled(Boolean customerEncryptionEnabled) {
        this.customerEncryptionEnabled = customerEncryptionEnabled;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Clientside encryption for customer enabled")
    public Boolean isCustomerEncryptionEnabled() {
        return this.customerEncryptionEnabled;
    }

    public void setCustomerEncryptionEnabled(Boolean customerEncryptionEnabled) {
        this.customerEncryptionEnabled = customerEncryptionEnabled;
    }

    public CustomerData cntFiles(Long cntFiles) {
        this.cntFiles = cntFiles;
        return this;
    }

    @ApiModelProperty(value="Total number of files Visible only with at least one global role.")
    public Long getCntFiles() {
        return this.cntFiles;
    }

    public void setCntFiles(Long cntFiles) {
        this.cntFiles = cntFiles;
    }

    public CustomerData cntFolders(Long cntFolders) {
        this.cntFolders = cntFolders;
        return this;
    }

    @ApiModelProperty(value="Total number of folders Visible only with at least one global role.")
    public Long getCntFolders() {
        return this.cntFolders;
    }

    public void setCntFolders(Long cntFolders) {
        this.cntFolders = cntFolders;
    }

    public CustomerData cntRooms(Long cntRooms) {
        this.cntRooms = cntRooms;
        return this;
    }

    @ApiModelProperty(value="Total number of rooms Visible only with at least one global role.")
    public Long getCntRooms() {
        return this.cntRooms;
    }

    public void setCntRooms(Long cntRooms) {
        this.cntRooms = cntRooms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerData customerData = (CustomerData)o;
        return Objects.equals(this.id, customerData.id) && Objects.equals(this.name, customerData.name) && Objects.equals(this.isProviderCustomer, customerData.isProviderCustomer) && Objects.equals(this.spaceLimit, customerData.spaceLimit) && Objects.equals(this.spaceUsed, customerData.spaceUsed) && Objects.equals(this.accountsLimit, customerData.accountsLimit) && Objects.equals(this.accountsUsed, customerData.accountsUsed) && Objects.equals(this.customerEncryptionEnabled, customerData.customerEncryptionEnabled) && Objects.equals(this.cntFiles, customerData.cntFiles) && Objects.equals(this.cntFolders, customerData.cntFolders) && Objects.equals(this.cntRooms, customerData.cntRooms);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.isProviderCustomer, this.spaceLimit, this.spaceUsed, this.accountsLimit, this.accountsUsed, this.customerEncryptionEnabled, this.cntFiles, this.cntFolders, this.cntRooms);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    isProviderCustomer: ").append(this.toIndentedString(this.isProviderCustomer)).append("\n");
        sb.append("    spaceLimit: ").append(this.toIndentedString(this.spaceLimit)).append("\n");
        sb.append("    spaceUsed: ").append(this.toIndentedString(this.spaceUsed)).append("\n");
        sb.append("    accountsLimit: ").append(this.toIndentedString(this.accountsLimit)).append("\n");
        sb.append("    accountsUsed: ").append(this.toIndentedString(this.accountsUsed)).append("\n");
        sb.append("    customerEncryptionEnabled: ").append(this.toIndentedString(this.customerEncryptionEnabled)).append("\n");
        sb.append("    cntFiles: ").append(this.toIndentedString(this.cntFiles)).append("\n");
        sb.append("    cntFolders: ").append(this.toIndentedString(this.cntFolders)).append("\n");
        sb.append("    cntRooms: ").append(this.toIndentedString(this.cntRooms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

