/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.ApiResponse;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.ActiveDirectoryConfig;
import ch.cyberduck.core.sds.io.swagger.client.model.ActiveDirectoryConfigList;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateActiveDirectoryConfigRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateOAuthClientRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateOpenIdIdpConfigRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.OAuthClient;
import ch.cyberduck.core.sds.io.swagger.client.model.OpenIdIdpConfig;
import ch.cyberduck.core.sds.io.swagger.client.model.RadiusConfig;
import ch.cyberduck.core.sds.io.swagger.client.model.RadiusConfigCreateRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.RadiusConfigUpdateRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.TestActiveDirectoryConfigRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.TestActiveDirectoryConfigResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateActiveDirectoryConfigRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateOAuthClientRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateOpenIdIdpConfigRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class SystemAuthConfigApi {
    private ApiClient apiClient;

    public SystemAuthConfigApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SystemAuthConfigApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RadiusConfig create(RadiusConfigCreateRequest body, String xSdsAuthToken) throws ApiException {
        return this.createWithHttpInfo(body, xSdsAuthToken).getData();
    }

    public ApiResponse<RadiusConfig> createWithHttpInfo(RadiusConfigCreateRequest body, String xSdsAuthToken) throws ApiException {
        RadiusConfigCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling create");
        }
        String localVarPath = "/v4/system/config/auth/radius";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RadiusConfig> localVarReturnType = new GenericType<RadiusConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ActiveDirectoryConfig createAdConfig(CreateActiveDirectoryConfigRequest body, String xSdsAuthToken) throws ApiException {
        return this.createAdConfigWithHttpInfo(body, xSdsAuthToken).getData();
    }

    public ApiResponse<ActiveDirectoryConfig> createAdConfigWithHttpInfo(CreateActiveDirectoryConfigRequest body, String xSdsAuthToken) throws ApiException {
        CreateActiveDirectoryConfigRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAdConfig");
        }
        String localVarPath = "/v4/system/config/auth/ads";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<ActiveDirectoryConfig> localVarReturnType = new GenericType<ActiveDirectoryConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuthClient createOAuthClient(CreateOAuthClientRequest body, String xSdsAuthToken) throws ApiException {
        return this.createOAuthClientWithHttpInfo(body, xSdsAuthToken).getData();
    }

    public ApiResponse<OAuthClient> createOAuthClientWithHttpInfo(CreateOAuthClientRequest body, String xSdsAuthToken) throws ApiException {
        CreateOAuthClientRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOAuthClient");
        }
        String localVarPath = "/v4/system/config/oauth/clients";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<OAuthClient> localVarReturnType = new GenericType<OAuthClient>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OpenIdIdpConfig createOpenIdIdpConfig(CreateOpenIdIdpConfigRequest body, String xSdsAuthToken) throws ApiException {
        return this.createOpenIdIdpConfigWithHttpInfo(body, xSdsAuthToken).getData();
    }

    public ApiResponse<OpenIdIdpConfig> createOpenIdIdpConfigWithHttpInfo(CreateOpenIdIdpConfigRequest body, String xSdsAuthToken) throws ApiException {
        CreateOpenIdIdpConfigRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOpenIdIdpConfig");
        }
        String localVarPath = "/v4/system/config/auth/openid/idps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<OpenIdIdpConfig> localVarReturnType = new GenericType<OpenIdIdpConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteAdConfig(Integer adId, String xSdsAuthToken) throws ApiException {
        this.deleteAdConfigWithHttpInfo(adId, xSdsAuthToken);
    }

    public ApiResponse<Void> deleteAdConfigWithHttpInfo(Integer adId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (adId == null) {
            throw new ApiException(400, "Missing the required parameter 'adId' when calling deleteAdConfig");
        }
        String localVarPath = "/v4/system/config/auth/ads/{ad_id}".replaceAll("\\{ad_id\\}", this.apiClient.escapeString(adId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteOAuthClient(String clientId, String xSdsAuthToken) throws ApiException {
        this.deleteOAuthClientWithHttpInfo(clientId, xSdsAuthToken);
    }

    public ApiResponse<Void> deleteOAuthClientWithHttpInfo(String clientId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling deleteOAuthClient");
        }
        String localVarPath = "/v4/system/config/oauth/clients/{client_id}".replaceAll("\\{client_id\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteOpenIdIdpConfig(Integer idpId, String xSdsAuthToken) throws ApiException {
        this.deleteOpenIdIdpConfigWithHttpInfo(idpId, xSdsAuthToken);
    }

    public ApiResponse<Void> deleteOpenIdIdpConfigWithHttpInfo(Integer idpId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling deleteOpenIdIdpConfig");
        }
        String localVarPath = "/v4/system/config/auth/openid/idps/{idp_id}".replaceAll("\\{idp_id\\}", this.apiClient.escapeString(idpId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deteteRadiusConfig(String xSdsAuthToken) throws ApiException {
        this.deteteRadiusConfigWithHttpInfo(xSdsAuthToken);
    }

    public ApiResponse<Void> deteteRadiusConfigWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/system/config/auth/radius";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ActiveDirectoryConfigList getAdConfigs(String xSdsAuthToken) throws ApiException {
        return this.getAdConfigsWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<ActiveDirectoryConfigList> getAdConfigsWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/system/config/auth/ads";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<ActiveDirectoryConfigList> localVarReturnType = new GenericType<ActiveDirectoryConfigList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ActiveDirectoryConfig getAuthAdSetting(Integer adId, String xSdsAuthToken) throws ApiException {
        return this.getAuthAdSettingWithHttpInfo(adId, xSdsAuthToken).getData();
    }

    public ApiResponse<ActiveDirectoryConfig> getAuthAdSettingWithHttpInfo(Integer adId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (adId == null) {
            throw new ApiException(400, "Missing the required parameter 'adId' when calling getAuthAdSetting");
        }
        String localVarPath = "/v4/system/config/auth/ads/{ad_id}".replaceAll("\\{ad_id\\}", this.apiClient.escapeString(adId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<ActiveDirectoryConfig> localVarReturnType = new GenericType<ActiveDirectoryConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuthClient getOAuthClient(String clientId, String xSdsAuthToken) throws ApiException {
        return this.getOAuthClientWithHttpInfo(clientId, xSdsAuthToken).getData();
    }

    public ApiResponse<OAuthClient> getOAuthClientWithHttpInfo(String clientId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling getOAuthClient");
        }
        String localVarPath = "/v4/system/config/oauth/clients/{client_id}".replaceAll("\\{client_id\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<OAuthClient> localVarReturnType = new GenericType<OAuthClient>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuthClient> getOAuthClients(String xSdsAuthToken, String filter, String sort) throws ApiException {
        return this.getOAuthClientsWithHttpInfo(xSdsAuthToken, filter, sort).getData();
    }

    public ApiResponse<List<OAuthClient>> getOAuthClientsWithHttpInfo(String xSdsAuthToken, String filter, String sort) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/system/config/oauth/clients";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<List<OAuthClient>> localVarReturnType = new GenericType<List<OAuthClient>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OpenIdIdpConfig getOpenIdIdpConfig(Integer idpId, String xSdsAuthToken) throws ApiException {
        return this.getOpenIdIdpConfigWithHttpInfo(idpId, xSdsAuthToken).getData();
    }

    public ApiResponse<OpenIdIdpConfig> getOpenIdIdpConfigWithHttpInfo(Integer idpId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getOpenIdIdpConfig");
        }
        String localVarPath = "/v4/system/config/auth/openid/idps/{idp_id}".replaceAll("\\{idp_id\\}", this.apiClient.escapeString(idpId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<OpenIdIdpConfig> localVarReturnType = new GenericType<OpenIdIdpConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OpenIdIdpConfig> getOpenIdIdpConfigs(String xSdsAuthToken) throws ApiException {
        return this.getOpenIdIdpConfigsWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<List<OpenIdIdpConfig>> getOpenIdIdpConfigsWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/system/config/auth/openid/idps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<List<OpenIdIdpConfig>> localVarReturnType = new GenericType<List<OpenIdIdpConfig>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RadiusConfig getRadiusConfig(String xSdsAuthToken) throws ApiException {
        return this.getRadiusConfigWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<RadiusConfig> getRadiusConfigWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/system/config/auth/radius";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RadiusConfig> localVarReturnType = new GenericType<RadiusConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TestActiveDirectoryConfigResponse testAdConfig(TestActiveDirectoryConfigRequest body, String xSdsAuthToken) throws ApiException {
        return this.testAdConfigWithHttpInfo(body, xSdsAuthToken).getData();
    }

    public ApiResponse<TestActiveDirectoryConfigResponse> testAdConfigWithHttpInfo(TestActiveDirectoryConfigRequest body, String xSdsAuthToken) throws ApiException {
        TestActiveDirectoryConfigRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling testAdConfig");
        }
        String localVarPath = "/v4/system/config/actions/test/ad";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<TestActiveDirectoryConfigResponse> localVarReturnType = new GenericType<TestActiveDirectoryConfigResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void testRadiusConfig(String xSdsAuthToken) throws ApiException {
        this.testRadiusConfigWithHttpInfo(xSdsAuthToken);
    }

    public ApiResponse<Void> testRadiusConfigWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/system/config/actions/test/radius";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ActiveDirectoryConfig updateAuthAdSetting(Integer adId, UpdateActiveDirectoryConfigRequest body, String xSdsAuthToken) throws ApiException {
        return this.updateAuthAdSettingWithHttpInfo(adId, body, xSdsAuthToken).getData();
    }

    public ApiResponse<ActiveDirectoryConfig> updateAuthAdSettingWithHttpInfo(Integer adId, UpdateActiveDirectoryConfigRequest body, String xSdsAuthToken) throws ApiException {
        UpdateActiveDirectoryConfigRequest localVarPostBody = body;
        if (adId == null) {
            throw new ApiException(400, "Missing the required parameter 'adId' when calling updateAuthAdSetting");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAuthAdSetting");
        }
        String localVarPath = "/v4/system/config/auth/ads/{ad_id}".replaceAll("\\{ad_id\\}", this.apiClient.escapeString(adId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<ActiveDirectoryConfig> localVarReturnType = new GenericType<ActiveDirectoryConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuthClient updateOAuthClient(UpdateOAuthClientRequest body, String clientId, String xSdsAuthToken) throws ApiException {
        return this.updateOAuthClientWithHttpInfo(body, clientId, xSdsAuthToken).getData();
    }

    public ApiResponse<OAuthClient> updateOAuthClientWithHttpInfo(UpdateOAuthClientRequest body, String clientId, String xSdsAuthToken) throws ApiException {
        UpdateOAuthClientRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOAuthClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling updateOAuthClient");
        }
        String localVarPath = "/v4/system/config/oauth/clients/{client_id}".replaceAll("\\{client_id\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<OAuthClient> localVarReturnType = new GenericType<OAuthClient>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OpenIdIdpConfig updateOpenIdIdpConfig(UpdateOpenIdIdpConfigRequest body, Integer idpId, String xSdsAuthToken) throws ApiException {
        return this.updateOpenIdIdpConfigWithHttpInfo(body, idpId, xSdsAuthToken).getData();
    }

    public ApiResponse<OpenIdIdpConfig> updateOpenIdIdpConfigWithHttpInfo(UpdateOpenIdIdpConfigRequest body, Integer idpId, String xSdsAuthToken) throws ApiException {
        UpdateOpenIdIdpConfigRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOpenIdIdpConfig");
        }
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling updateOpenIdIdpConfig");
        }
        String localVarPath = "/v4/system/config/auth/openid/idps/{idp_id}".replaceAll("\\{idp_id\\}", this.apiClient.escapeString(idpId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<OpenIdIdpConfig> localVarReturnType = new GenericType<OpenIdIdpConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RadiusConfig updateRadiusConfig(RadiusConfigUpdateRequest body, String xSdsAuthToken) throws ApiException {
        return this.updateRadiusConfigWithHttpInfo(body, xSdsAuthToken).getData();
    }

    public ApiResponse<RadiusConfig> updateRadiusConfigWithHttpInfo(RadiusConfigUpdateRequest body, String xSdsAuthToken) throws ApiException {
        RadiusConfigUpdateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRadiusConfig");
        }
        String localVarPath = "/v4/system/config/auth/radius";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RadiusConfig> localVarReturnType = new GenericType<RadiusConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

